/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.worldelements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.jiw.unity.runtime.PluginGameObjectManager;
import net.jiw.unity.runtime.PluginManager;
import net.risingworld.api.Timer;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.collider.Collider;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class GameObject {
    final int id;
    final int pluginID;
    boolean active = true;
    Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
    Quaternion rotation = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f);
    Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    Collider collider = null;
    GameObject parent = null;
    PluginGameObjectManager.AttachTarget attachTarget = PluginGameObjectManager.AttachTarget.None;
    Object attachTargetObject = null;
    long attachTargetObjectID = -1L;
    int flags;
    int layer = 0;
    Crosshair crosshair = Crosshair.Default;
    boolean isDisposed = false;
    private ArrayList<GameObject> childs = new ArrayList(4);
    private Timer moveToTimer = null;
    private Consumer<Vector3f> moveToConsumer = null;
    private ConcurrentHashMap<String, Object> attributes = null;
    private static final AtomicInteger id_counter = new AtomicInteger(1);
    private static final int FLAG_LISTEN_FOR_HIT_EVENTS = 1;
    private static final int FLAG_LISTEN_FOR_INTERACTIONS = 2;
    private static final int FLAG_LISTEN_FOR_COLLISIONS = 4;
    private static final int FLAG_VISUALIZE_COLLIDER = 128;
    private static final int TYPE = 0;

    public GameObject() {
        this(0);
    }

    public GameObject(int layer) {
        this.layer = layer;
        this.id = id_counter.getAndIncrement();
        this.pluginID = PluginManager.getPluginIDFromContext();
    }

    int getType() {
        return 0;
    }

    public int getID() {
        return this.id;
    }

    public int getPluginID() {
        return this.pluginID;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void setActive(boolean set) {
        if (this.active != set) {
            this.active = set;
            this.updateObject(false);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setLayer(int layer) {
        if (this.layer != layer) {
            this.layer = layer;
            this.updateObject(false);
        }
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLocalPosition(Vector3f position) {
        this.setLocalPosition(position.x, position.y, position.z);
    }

    public void setLocalPosition(float x, float y, float z) {
        if (this.moveToTimer != null) {
            this.moveToTimer.kill();
            this.moveToTimer = null;
        }
        if (this.position.x != x || this.position.y != y || this.position.z != z) {
            this.position.set(x, y, z);
            this.updateLocalTransform(true, false, false);
        }
    }

    public Vector3f getLocalPosition() {
        return this.position;
    }

    public void setLocalRotation(Quaternion rotation) {
        if (!this.rotation.equals(rotation)) {
            this.rotation.set(rotation);
            this.updateLocalTransform(false, true, false);
        }
    }

    public void setLocalRotation(float pitch, float yaw, float roll) {
        int hash = this.rotation.hashCode();
        this.rotation = this.rotation.fromAngles(pitch, yaw, roll);
        if (hash != this.rotation.hashCode()) {
            this.updateLocalTransform(false, true, false);
        }
    }

    public Quaternion getLocalRotation() {
        return this.rotation;
    }

    public void setLocalScale(Vector3f scale) {
        this.setLocalScale(scale.x, scale.y, scale.z);
    }

    public void setLocalScale(float x, float y, float z) {
        if (this.scale.x != x || this.scale.y != y || this.scale.z != z) {
            this.scale.set(x, y, z);
            this.updateLocalTransform(false, false, true);
        }
    }

    public Vector3f getLocalScale() {
        return this.scale;
    }

    public void moveToLocalPosition(Vector3f position, float speed) {
        this.moveToLocalPosition(position.x, position.y, position.z, speed);
    }

    public void moveToLocalPosition(float x, float y, float z, float speed) {
        this.moveToLocalPosition(x, y, z, speed, null);
    }

    public void moveToLocalPosition(Vector3f position, float speed, Callback<Consumer<Vector3f>> callback) {
        this.moveToLocalPosition(position.x, position.y, position.z, speed, callback);
    }

    public void moveToLocalPosition(float x, float y, float z, float speed, Callback<Consumer<Vector3f>> callback) {
        if (speed <= 0.0f) {
            this.setLocalPosition(x, y, z);
            return;
        }
        float[] lastTpf = new float[]{0.0f};
        Vector3f oldPosition = new Vector3f(this.position);
        Vector3f targetPosition = new Vector3f(x, y, z);
        if (this.moveToTimer != null) {
            this.moveToTimer.kill();
        }
        this.moveToTimer = new Timer(0.0f, 0.0f, -1, null);
        this.moveToTimer.setTask(() -> {
            float passedSeconds = this.moveToTimer.getPassedSeconds();
            float tpf = passedSeconds - lastTpf[0];
            lastTpf[0] = passedSeconds;
            float dist = this.position.distance(x, y, z);
            if (dist <= 1.0E-5f) {
                this.position.set(targetPosition);
                this.moveToTimer.kill();
                this.moveToTimer = null;
            } else {
                float mu = Utils.MathUtils.saturate(tpf * speed / dist);
                this.position.interpolateLocal(targetPosition, mu);
            }
            if (callback != null) {
                if (this.moveToConsumer == null) {
                    this.moveToConsumer = new Consumer<Vector3f>(){

                        @Override
                        public void accept(Vector3f v) {
                            GameObject.this.position.set(v);
                            GameObject.this.updateLocalTransform(true, false, false, false);
                        }
                    };
                }
                callback.onCall(this.moveToConsumer);
            }
        });
        this.moveToTimer.start();
        this.updateLocalTransform(targetPosition, speed);
    }

    public void rotateToLocalRotation(Quaternion rotation, float speed) {
        this.rotation.set(rotation.x, rotation.y, rotation.z, rotation.w);
        this.updateLocalTransform(false, true, false, speed);
    }

    public void moveToLocalTransform(Vector3f position, Quaternion rotation, float speed) {
        this.position.set(position.x, position.y, position.z);
        this.rotation.set(rotation.x, rotation.y, rotation.z, rotation.w);
        this.updateLocalTransform(true, true, false, speed);
    }

    public void readWorldPosition(Player player, Callback<Vector3f> callback) {
        PluginGameObjectManager.readPosition((GameObject)this, (int)this.id, (int)(player == null ? -1 : player.getDbID()), (boolean)false, null, callback);
    }

    public void readWorldRotation(Player player, Callback<Quaternion> callback) {
        PluginGameObjectManager.readRotation((GameObject)this, (int)this.id, (int)(player == null ? -1 : player.getDbID()), (boolean)false, null, callback);
    }

    public void attachTo(Player player, AttachTarget target) {
        PluginGameObjectManager.AttachTarget t = player == null ? PluginGameObjectManager.AttachTarget.None : (target == AttachTarget.Root ? PluginGameObjectManager.AttachTarget.Player : (target == AttachTarget.Head ? PluginGameObjectManager.AttachTarget.PlayerHead : (target == AttachTarget.LeftHand ? PluginGameObjectManager.AttachTarget.PlayerLeftHand : (target == AttachTarget.RightHand ? PluginGameObjectManager.AttachTarget.PlayerRightHand : PluginGameObjectManager.AttachTarget.Player))));
        if (this.attachTarget != t && this.attachTargetObject != player) {
            this.attachTarget = t;
            this.attachTargetObject = player;
            this.attachTargetObjectID = player == null || t == PluginGameObjectManager.AttachTarget.None ? -1L : (long)player.getDbID();
            this.updateAttachTarget();
        }
    }

    public void attachTo(Npc npc, AttachTarget target) {
        PluginGameObjectManager.AttachTarget t = npc == null ? PluginGameObjectManager.AttachTarget.None : (target == AttachTarget.Root ? PluginGameObjectManager.AttachTarget.Npc : (target == AttachTarget.Head ? PluginGameObjectManager.AttachTarget.NpcHead : (target == AttachTarget.LeftHand ? PluginGameObjectManager.AttachTarget.NpcLeftHand : (target == AttachTarget.RightHand ? PluginGameObjectManager.AttachTarget.NpcRightHand : PluginGameObjectManager.AttachTarget.Npc))));
        if (this.attachTarget != t && this.attachTargetObject != npc) {
            this.attachTarget = t;
            this.attachTargetObject = npc;
            this.attachTargetObjectID = npc == null || t == PluginGameObjectManager.AttachTarget.None ? -1L : npc.getGlobalID();
            this.updateAttachTarget();
        }
    }

    public boolean isAttached() {
        return this.attachTarget != PluginGameObjectManager.AttachTarget.None && this.attachTargetObject != null;
    }

    public void setCollider(Collider collider) {
        if (this.collider != collider) {
            this.collider = collider;
            this.updateObject(true);
        }
    }

    public Collider getCollider() {
        return this.collider;
    }

    public void setColliderVisible(boolean set) {
        if (this.isColliderVisible() != set) {
            this.flags |= 0x80;
            this.updateObject(false);
        }
    }

    public boolean isColliderVisible() {
        return (this.flags & 0x80) != 0;
    }

    public void addComponent(String component) {
        PluginGameObjectManager.addOrRemoveComponent((boolean)true, (GameObject)this, null, (String)component, (boolean)true);
    }

    public void removeComponent(String component) {
        PluginGameObjectManager.addOrRemoveComponent((boolean)false, (GameObject)this, null, (String)component, (boolean)true);
    }

    public void setComponentEnabled(String component, boolean enabled) {
        PluginGameObjectManager.setComponentEnabled((GameObject)this, null, (String)component, (boolean)enabled);
    }

    public void setComponentProperty(String component, String property, Object value) {
        PluginGameObjectManager.invokeComponentMethod((GameObject)this, null, (String)component, (String)property, (boolean)true, (Object[])new Object[]{value});
    }

    public void invokeComponentMethod(String component, String method, Object ... parameters) {
        if (component == null || method == null) {
            return;
        }
        PluginGameObjectManager.invokeComponentMethod((GameObject)this, null, (String)component, (String)method, (boolean)false, (Object[])parameters);
    }

    public void addChild(GameObject child) {
        if (child == null || this.childs.contains(child)) {
            return;
        }
        if (child == this) {
            throw new IllegalStateException("Cannot add game object to itself");
        }
        if (child.parent != null) {
            child.removeFromParent();
        } else {
            PluginGameObjectManager.unregisterGameObjectForAllPlayers((GameObject)child, (boolean)true);
        }
        this.childs.add(child);
        child.parent = this;
        this.updateHierarchy(child);
    }

    public void removeChild(GameObject child) {
        if (child == null) {
            return;
        }
        if (this.childs.remove(child)) {
            child.parent = null;
            PluginGameObjectManager.unregisterGameObjectForAllPlayers((GameObject)child, (boolean)true);
        }
    }

    public void removeAllChilds() {
        for (GameObject child : this.childs) {
            child.parent = null;
            PluginGameObjectManager.unregisterGameObjectForAllPlayers((GameObject)child, (boolean)true);
        }
        this.childs.clear();
    }

    public GameObject getParent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public List<GameObject> getChilds() {
        if (this.childs == null) {
            return null;
        }
        return Collections.unmodifiableList(this.childs);
    }

    public int getChildCount() {
        return this.childs.size();
    }

    public void setAttribute(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new ConcurrentHashMap(10, 0.9f, 1);
        }
        if (value == null) {
            this.deleteAttribute(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public <T> T getAttribute(String key) {
        if (this.attributes == null || key == null) {
            return null;
        }
        return (T)this.attributes.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.attributes != null && this.attributes.containsKey(key);
    }

    public boolean hasAttribute(String key, Class type) {
        if (this.attributes == null) {
            return false;
        }
        Object attribute = this.attributes.get(key);
        return attribute != null && attribute.getClass() == type;
    }

    public void deleteAttribute(String key) {
        if (this.attributes != null && key != null) {
            if (this.hasAttribute("tes", Boolean.class)) {
                boolean bl = (Boolean)this.getAttribute("test");
            }
            this.attributes.remove(key);
        }
    }

    public Set<Map.Entry<String, Object>> getAttributes() {
        return this.attributes.entrySet();
    }

    private void updateObject(boolean updateCollider) {
        PluginGameObjectManager.updateObject((GameObject)this, (int)this.id, (boolean)updateCollider);
    }

    private void updateLocalTransform(boolean updatePosition, boolean updateRotation, boolean updateScale) {
        PluginGameObjectManager.updateTransform((GameObject)this, (int)this.id, (Vector3f)this.position, (boolean)updatePosition, (Quaternion)this.rotation, (boolean)updateRotation, (Vector3f)this.scale, (boolean)updateScale, (boolean)true, (float)-1.0f);
    }

    private void updateLocalTransform(boolean updatePosition, boolean updateRotation, boolean updateScale, float speed) {
        PluginGameObjectManager.updateTransform((GameObject)this, (int)this.id, (Vector3f)this.position, (boolean)updatePosition, (Quaternion)this.rotation, (boolean)updateRotation, (Vector3f)this.scale, (boolean)updateScale, (boolean)false, (float)speed);
    }

    private void updateLocalTransform(boolean updatePosition, boolean updateRotation, boolean updateScale, boolean resetSmoothTransform) {
        PluginGameObjectManager.updateTransform((GameObject)this, (int)this.id, (Vector3f)this.position, (boolean)updatePosition, (Quaternion)this.rotation, (boolean)updateRotation, (Vector3f)this.scale, (boolean)updateScale, (boolean)resetSmoothTransform, (float)-1.0f);
    }

    private void updateLocalTransform(Vector3f targetPosition, float speed) {
        PluginGameObjectManager.updateTransform((GameObject)this, (int)this.id, (Vector3f)targetPosition, (boolean)true, (Quaternion)this.rotation, (boolean)false, (Vector3f)this.scale, (boolean)false, (boolean)false, (float)speed);
    }

    private void updateHierarchy(GameObject newChild) {
        PluginGameObjectManager.updateHierarchy((GameObject)this, (GameObject)newChild);
    }

    private void updateAttachTarget() {
        PluginGameObjectManager.updateAttachTarget((GameObject)this, (int)this.id, (int)this.attachTarget.ordinal(), (long)this.attachTargetObjectID);
    }

    public static enum AttachTarget {
        Root,
        Head,
        LeftHand,
        RightHand;

    }
}

