/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.world.batch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.risingworld.api.utils.Utils;

public class WorldEditBatch {
    private ArrayList<Entry> entries;

    public WorldEditBatch() {
        this(32);
    }

    public WorldEditBatch(int initialCapacity) {
        this.entries = new ArrayList(initialCapacity);
    }

    public void add(int terrainID, int cx, int cy, int cz, int bx, int by, int bz) {
        if (bx < 0 || bx >= Utils.ChunkUtils.CHUNK_SIZE_X) {
            float x = (float)(cx * Utils.ChunkUtils.CHUNK_SIZE_X + bx) + 0.5f;
            cx = Utils.ChunkUtils.getChunkPositionX(x);
            bx = Utils.ChunkUtils.getBlockPositionX(x, cx);
        }
        if (by < 0 || by >= Utils.ChunkUtils.CHUNK_SIZE_Y) {
            float y = (float)(cy * Utils.ChunkUtils.CHUNK_SIZE_Y + by) + 0.5f;
            cy = Utils.ChunkUtils.getChunkPositionY(y);
            by = Utils.ChunkUtils.getBlockPositionY(y, cy);
        }
        if (bz < 0 || bz >= Utils.ChunkUtils.CHUNK_SIZE_Z) {
            float z = (float)(cz * Utils.ChunkUtils.CHUNK_SIZE_Z + bz) + 0.5f;
            cz = Utils.ChunkUtils.getChunkPositionZ(z);
            bz = Utils.ChunkUtils.getBlockPositionZ(z, cz);
        }
        this.entries.add(new Entry(terrainID, cx, cy, cz, bx, by, bz));
    }

    public int count() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    private byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(4 + this.entries.size() * 28);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.entries.size());
        int len = this.entries.size();
        for (int i = 0; i < len; ++i) {
            Entry e = this.entries.get(i);
            buffer.putInt(e.terrainID);
            buffer.putInt(e.cx);
            buffer.putInt(e.cy);
            buffer.putInt(e.cz);
            buffer.putInt(e.bx);
            buffer.putInt(e.by);
            buffer.putInt(e.bz);
        }
        return buffer.array();
    }

    record Entry(int terrainID, int cx, int cy, int cz, int bx, int by, int bz) {
    }
}

