/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.sounds;

import net.risingworld.api.Server;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public final class Sound {
    private final int instanceID;
    private final int playerDbID;
    boolean paused;
    float volume;
    float pitch;

    private Sound(int id, int playerDbID) {
        this.instanceID = id;
        this.playerDbID = playerDbID;
    }

    public int getID() {
        return this.instanceID;
    }

    public int getPlayerDbID() {
        return this.playerDbID;
    }

    public Player getPlayer() {
        return Server.getPlayerByDbID(this.playerDbID);
    }

    public void setPaused(boolean paused) {
        this.setPaused(this.instanceID, this.playerDbID, paused);
    }

    public void setVolume(float volume) {
        this.setVolume(this.instanceID, this.playerDbID, volume);
    }

    public void setPitch(float pitch) {
        this.setPitch(this.instanceID, this.playerDbID, pitch);
    }

    public void setTimelinePosition(float position, boolean normalized) {
        this.setTimelinePosition(this.instanceID, this.playerDbID, position, normalized);
    }

    public void setPosition(Vector3f position) {
        if (position == null) {
            return;
        }
        this.setPosition(this.instanceID, this.playerDbID, position.x, position.y, position.z);
    }

    public void setDirection(Vector3f direction) {
        if (direction == null) {
            return;
        }
        this.setDirection(this.instanceID, this.playerDbID, direction.x, direction.y, direction.z);
    }

    public void setVelocity(Vector3f velocity) {
        if (velocity == null) {
            return;
        }
        this.setVelocity(this.instanceID, this.playerDbID, velocity.x, velocity.y, velocity.z);
    }

    public void setMinMaxDistance(float minDist, float maxDist) {
        this.setMinMaxDistance(this.instanceID, this.playerDbID, minDist, maxDist);
    }

    public void setGameMusicFade(float fade) {
        this.setGameMusicFade(this.instanceID, this.playerDbID, fade);
    }

    public void stop(boolean immediately) {
        this.stop(this.instanceID, this.playerDbID, immediately);
    }

    public boolean equals(Object o) {
        if (o instanceof Sound) {
            Sound s = (Sound)o;
            return s.instanceID == this.instanceID && s.playerDbID == this.instanceID;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + this.instanceID;
        hash = 83 * hash + this.playerDbID;
        return hash;
    }

    private native void setVolume(int var1, int var2, float var3);

    private native void setPitch(int var1, int var2, float var3);

    private native void setPosition(int var1, int var2, float var3, float var4, float var5);

    private native void setDirection(int var1, int var2, float var3, float var4, float var5);

    private native void setVelocity(int var1, int var2, float var3, float var4, float var5);

    private native void setTimelinePosition(int var1, int var2, float var3, boolean var4);

    private native void setMinMaxDistance(int var1, int var2, float var3, float var4);

    private native void setGameMusicFade(int var1, int var2, float var3);

    private native void sync(int var1, int var2, float var3, float var4, float var5, boolean var6, float var7, float var8, Vector3f var9, Vector3f var10, Vector3f var11);

    private native void setPaused(int var1, int var2, boolean var3);

    private native void stop(int var1, int var2, boolean var3);
}

