/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects.world;

import net.risingworld.api.objects.world.Chunk;
import net.risingworld.api.utils.Utils;

public class ChunkPart {
    public static final int SIZE_Y = Utils.ChunkUtils.CHUNK_SIZE_Y;
    public static final int TERRAIN_BITS = 255;
    public static final int STRENGTH_BITS = 65280;
    public static final int STRENGTH_BITSHIFT = 8;
    final int cx;
    final int cy;
    final int cz;

    private ChunkPart(int cx, int cy, int cz) {
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
    }

    public boolean isValid() {
        return this.isValid(this.cx, this.cy, this.cz);
    }

    private native boolean isValid(int var1, int var2, int var3);

    public int getChunkPositionX() {
        return this.cx;
    }

    public int getChunkPositionY() {
        return this.cy;
    }

    public int getChunkPositionZ() {
        return this.cz;
    }

    public boolean isLoadedFromDB() {
        return this.isLoadedFromDB(this.cx, this.cy, this.cz);
    }

    private native boolean isLoadedFromDB(int var1, int var2, int var3);

    public byte[] getTerrain() {
        return this.getTerrain(this.cx, this.cy, this.cz);
    }

    private native byte[] getTerrain(int var1, int var2, int var3);

    public short[] getRawTerrain() {
        return this.getRawTerrain(this.cx, this.cy, this.cz);
    }

    private native short[] getRawTerrain(int var1, int var2, int var3);

    public byte[] getRawCompressedTerrain() {
        return this.getRawCompressedTerrain(this.cx, this.cy, this.cz);
    }

    private native byte[] getRawCompressedTerrain(int var1, int var2, int var3);

    public int getTerrainID(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= Chunk.SIZE_X || y >= SIZE_Y || z >= Chunk.SIZE_Z) {
            throw new IndexOutOfBoundsException("Invalid x, y or z index (x: " + x + ", y: " + y + ", z: " + z + ")!");
        }
        return this.getTerrainID(this.cx, this.cy, this.cz, x, y, z, false);
    }

    public int getRawTerrainID(int x, int y, int z) {
        if (x < 0 || y < 0 || z < 0 || x >= Chunk.SIZE_X || y >= SIZE_Y || z >= Chunk.SIZE_Z) {
            throw new IndexOutOfBoundsException("Invalid x, y or z index (x: " + x + ", y: " + y + ", z: " + z + ")!");
        }
        return this.getTerrainID(this.cx, this.cy, this.cz, x, y, z, true);
    }

    private native int getTerrainID(int var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    public static int getTerrainIndex(int x, int y, int z) {
        return x + y * Chunk.SIZE_X + z * Chunk.SIZE_X * SIZE_Y;
    }

    public static int getRawTerrainIndex(int x, int y, int z) {
        return x + y * (Chunk.SIZE_X + 4) + z * (Chunk.SIZE_X + 4) * (SIZE_Y + 4);
    }

    public boolean equals(Object o) {
        if (o instanceof ChunkPart) {
            ChunkPart c = (ChunkPart)o;
            return c.cx == this.cx && c.cz == this.cz;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.cx;
        hash = 83 * hash + this.cz;
        return hash;
    }
}

