/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Vehicles;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public final class Vehicle {
    private final long handle;

    protected Vehicle(long handle) {
        this.handle = handle;
    }

    public long getGlobalID() {
        return this.handle;
    }

    public Vehicles.VehicleDefinition getDefinition() {
        return Definitions.getVehicleDefinition(this.getTypeID(this.handle));
    }

    public short getTypeID() {
        return this.getTypeID(this.handle);
    }

    private native short getTypeID(long var1);

    public boolean isDestroyed() {
        return this.isDestroyed(this.handle);
    }

    private native boolean isDestroyed(long var1);

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(long var1);

    public void setName(String name) {
        this.setName(this.handle, name);
    }

    private native void setName(long var1, String var3);

    public Vector3f getPosition() {
        return this.getPosition(this.handle);
    }

    private native Vector3f getPosition(long var1);

    public void setPosition(Vector3f position) {
        this.setPosition(this.handle, position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.setPosition(this.handle, x, y, z);
    }

    private native void setPosition(long var1, float var3, float var4, float var5);

    public Quaternion getRotation() {
        return this.getRotation(this.handle);
    }

    private native Quaternion getRotation(long var1);

    public void setRotation(Quaternion rotation) {
        this.setRotation(this.handle, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    private native void setRotation(long var1, float var3, float var4, float var5, float var6);

    public int getStrength() {
        return this.getStrength(this.handle);
    }

    private native int getStrength(long var1);

    public void setStrength(int strength) {
        this.setStrength(this.handle, strength);
    }

    private native void setStrength(long var1, int var3);

    public int getColor() {
        return this.getColor(this.handle);
    }

    private native int getColor(long var1);

    public void setColor(float r, float g, float b, float a) {
        this.setColor(this.handle, Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setColor(int color) {
        this.setColor(this.handle, color);
    }

    private native void setColor(long var1, int var3);

    public Player getPassenger(int seat) {
        return this.getPassenger(this.handle, seat);
    }

    private native Player getPassenger(long var1, int var3);

    public Player[] getPassengers() {
        return this.getPassengers(this.handle);
    }

    private native Player[] getPassengers(long var1);

    public void ejectAllPassengers() {
        this.ejectAllPassengers(this.handle);
    }

    private native void ejectAllPassengers(long var1);

    public void destroy() {
        this.destroy(this.handle, false);
    }

    private native void destroy(long var1, boolean var3);
}

