/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import net.risingworld.api.events.player.world.PlayerObjectEvent;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class PlayerPlaceObjectEvent
extends PlayerObjectEvent {
    private PlayerPlaceObjectEvent(long pointer) {
        super(pointer);
    }

    public Vector3f getPosition() {
        this.CheckIsValid();
        return this.getObjectPosition(this.pointer);
    }

    public Quaternion getRotation() {
        this.CheckIsValid();
        return this.getObjectRotation(this.pointer);
    }

    public Vector3f getScale() {
        this.CheckIsValid();
        return this.getObjectScale(this.pointer);
    }

    public int getColor() {
        this.CheckIsValid();
        return this.getObjectColor(this.pointer);
    }

    public byte getStatus() {
        this.CheckIsValid();
        return this.getObjectStatus(this.pointer);
    }

    public long getInfoID() {
        this.CheckIsValid();
        return this.getObjectInfoID(this.pointer);
    }

    public void setColor(int rgba) {
        this.CheckIsValid();
        this.setObjectColor(this.pointer, rgba);
    }

    public void setPosition(Vector3f position) {
        this.CheckIsValid();
        if (position == null) {
            return;
        }
        this.setObjectPosition(this.pointer, position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.CheckIsValid();
        this.setObjectPosition(this.pointer, x, y, z);
    }

    public void setRotation(Quaternion rotation) {
        this.CheckIsValid();
        if (rotation == null) {
            rotation = Quaternion.IDENTITY;
        }
        this.setObjectRotation(this.pointer, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    private native Vector3f getObjectPosition(long var1);

    private native Quaternion getObjectRotation(long var1);

    private native Vector3f getObjectScale(long var1);

    private native int getObjectColor(long var1);

    private native byte getObjectStatus(long var1);

    private native long getObjectInfoID(long var1);

    private native void setObjectColor(long var1, int var3);

    private native void setObjectPosition(long var1, float var3, float var4, float var5);

    private native void setObjectRotation(long var1, float var3, float var4, float var5, float var6);
}

