/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.utils.Bounds;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class PlayerPlaceBlueprintEvent
extends PlayerEvent
implements Cancellable {
    private PlayerPlaceBlueprintEvent(long pointer) {
        super(pointer);
    }

    public long getBlueprintID() {
        this.CheckIsValid();
        return this.getBlueprintID(this.pointer);
    }

    public int getPlaceID() {
        this.CheckIsValid();
        return this.getPlaceID(this.pointer);
    }

    public Vector3f getPosition() {
        this.CheckIsValid();
        return this.getWorldPosition(this.pointer);
    }

    public void setPosition(Vector3f position) {
        this.setPosition(position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.CheckIsValid();
        this.setWorldPosition(this.pointer, x, y, z);
    }

    public Quaternion getRotation() {
        this.CheckIsValid();
        return this.getWorldRotation(this.pointer);
    }

    public void setRotation(Quaternion rotation) {
        this.CheckIsValid();
        this.setWorldRotation(this.pointer, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public Vector3f getScale() {
        this.CheckIsValid();
        return this.getScale(this.pointer);
    }

    public void setScale(Vector3f scale) {
        this.CheckIsValid();
        this.setScale(this.pointer, scale.x, scale.y, scale.z);
    }

    public Bounds getBounds() {
        this.CheckIsValid();
        return this.getBounds(this.pointer);
    }

    public float getMaxExtent() {
        Bounds bounds = this.getBounds();
        float x = bounds.getXExtent();
        float y = bounds.getYExtent();
        float z = bounds.getZExtent();
        if (x > y) {
            if (x > z) {
                return x;
            }
            return z;
        }
        if (z > y) {
            return z;
        }
        return y;
    }

    public int getConstructionCount() {
        this.CheckIsValid();
        return this.getConstructionCount(this.pointer);
    }

    public int getObjectCount() {
        this.CheckIsValid();
        return this.getObjectCount(this.pointer);
    }

    public int getPlantCount() {
        this.CheckIsValid();
        return this.getPlantCount(this.pointer);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    private native long getBlueprintID(long var1);

    private native int getPlaceID(long var1);

    private native Vector3f getWorldPosition(long var1);

    private native void setWorldPosition(long var1, float var3, float var4, float var5);

    private native Quaternion getWorldRotation(long var1);

    private native void setWorldRotation(long var1, float var3, float var4, float var5, float var6);

    private native Vector3f getScale(long var1);

    private native void setScale(long var1, float var3, float var4, float var5);

    private native Vector3f getExtents(long var1);

    private native Bounds getBounds(long var1);

    private native int getConstructionCount(long var1);

    private native int getObjectCount(long var1);

    private native int getPlantCount(long var1);
}

