/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.assets;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import net.jiw.unity.runtime.PluginAssetManager;
import net.jiw.unity.runtime.PluginManager;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.Plugin;
import net.risingworld.api.assets.AssetBundle;
import net.risingworld.api.utils.Utils;

public abstract class Asset {
    private static HashMap<Integer, Asset> AllAssets = new HashMap(16);
    int handle;
    int dependency;
    int sourcePlugin = -1;
    final Type type;
    Source source;
    byte[] cachedData;
    String rawPath;
    String rawName;
    String name;
    String checksum;
    String extension;
    long lastAccess = 0L;
    boolean persistent = false;
    private boolean isDisposed = false;
    protected static final String DEFAULT_EXTENSION = "asset";

    static Asset find(Type type, Source source, String rawPath, byte[] data, int dependency) {
        for (Asset asset : AllAssets.values()) {
            if (asset.type != type || asset.source != source || rawPath != null && !Objects.equals(asset.rawPath, rawPath) || data != null && !Arrays.equals(asset.cachedData, data) || asset.dependency != dependency) continue;
            System.out.println("Loading asset (" + String.valueOf((Object)type) + ") from cache: " + String.valueOf(rawPath == null ? data : (byte[])rawPath));
            return asset;
        }
        return null;
    }

    static Asset load(Asset asset, byte[] bytes) {
        try {
            Asset other = Asset.find(asset.type, Source.Raw, null, bytes, -1);
            if (other != null) {
                return other;
            }
            asset.source = Source.Raw;
            asset.loadFromBytes(bytes);
            AllAssets.put(asset.handle, asset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asset;
    }

    static Asset loadFromGame(Asset asset, String path, boolean persistent) {
        try {
            Asset other = Asset.find(asset.type, Source.GameAsset, path, null, -1);
            if (other != null) {
                return other;
            }
            asset.source = Source.GameAsset;
            asset.setupFileInfo(-1, -1, path, path, path, DEFAULT_EXTENSION, null);
            asset.persistent = persistent;
            AllAssets.put(asset.handle, asset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asset;
    }

    static Asset loadFromURL(Asset asset, String url) {
        try {
            Asset other = Asset.find(asset.type, Source.URL, url, null, -1);
            if (other != null) {
                return other;
            }
            asset.source = Source.URL;
            asset.setupFileInfo(-1, -1, url, url, url, DEFAULT_EXTENSION, null);
            AllAssets.put(asset.handle, asset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asset;
    }

    static Asset loadFromFile(Asset asset, String file) {
        try {
            File f = new File(file);
            Asset other = Asset.find(asset.type, Source.File, f.getAbsolutePath(), null, -1);
            if (other != null) {
                return other;
            }
            asset.source = Source.File;
            asset.loadFromFile(f);
            AllAssets.put(asset.handle, asset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asset;
    }

    static Asset loadFromPlugin(Asset asset, Plugin plugin, String resource) {
        try {
            asset.source = Source.File;
            asset.loadFromResource(plugin, resource);
            AllAssets.put(asset.handle, asset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asset;
    }

    static Asset loadFromAssetBundle(Asset asset, AssetBundle assetBundle, String path) {
        try {
            Asset other = Asset.find(asset.type, Source.AssetBundle, path, null, assetBundle != null ? assetBundle.handle : -1);
            if (other != null) {
                return other;
            }
            asset.source = Source.AssetBundle;
            asset.loadFromAssetBundle(assetBundle, path);
            AllAssets.put(asset.handle, asset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return asset;
    }

    Asset(Type type) {
        this.type = type;
    }

    private boolean loadFromResource(Plugin plugin, String resourcepath) {
        if (!this.checkFileExtension(resourcepath)) {
            throw new UnsupportedOperationException("File format of \"" + resourcepath + "\" not supported!");
        }
        int ext = resourcepath.lastIndexOf(46);
        int slash = resourcepath.lastIndexOf(47);
        if (slash < 0) {
            slash = 0;
        }
        String extension = resourcepath.substring(ext + 1);
        String filename = resourcepath.substring(slash, ext);
        String md5 = PluginManager.getResourceMd5((int)plugin.getID(), (String)resourcepath);
        if (md5 == null) {
            return false;
        }
        String pluginMain = plugin.getDescription("main");
        if (pluginMain == null) {
            pluginMain = String.valueOf(plugin.getID());
        }
        String name = pluginMain.hashCode() + "_" + InternalUtils.StringUtils.getMd5((String)resourcepath) + "_" + md5;
        this.setupFileInfo(-1, plugin.getID(), resourcepath, filename, name, extension, md5);
        System.out.println("Load from resources (plugin " + plugin.getID() + "): " + name + " " + md5);
        return true;
    }

    private boolean loadFromFile(File file) throws IOException {
        if (file != null) {
            Object name = file.getName();
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
            if (file.isDirectory()) {
                throw new FileNotFoundException("You have to specify a single file instead of a directory");
            }
            if (!this.checkFileExtension((String)name)) {
                throw new UnsupportedOperationException("File format of \"" + file.getName() + "\" not supported!");
            }
            int ext = ((String)name).lastIndexOf(46);
            String extension = ext <= 0 ? "" : ((String)name).substring(ext + 1);
            String filename = ext <= 0 ? name : ((String)name).substring(0, ext);
            String md5 = InternalUtils.FileUtils.getMd5((File)file);
            name = InternalUtils.StringUtils.getMd5((String)file.getAbsolutePath()) + "_" + md5;
            this.setupFileInfo(-1, -1, file.getAbsolutePath(), filename, (String)name, extension, md5);
            return true;
        }
        return false;
    }

    private boolean loadFromAssetBundle(AssetBundle bundle, String path) {
        if (bundle != null) {
            int ext = path.lastIndexOf(46);
            int slash = path.lastIndexOf(47);
            if (slash < 0) {
                slash = 0;
            }
            String extension = ext <= 0 ? "" : path.substring(ext + 1);
            String filename = ext <= 0 ? path.substring(slash) : path.substring(slash, ext);
            String md5 = bundle.checksum + Utils.StringUtils.getMd5(path) + this.type.ordinal();
            this.setupFileInfo(bundle.handle, -1, path, filename, path, extension, md5);
            return true;
        }
        return false;
    }

    private boolean loadFromBytes(byte[] bytes) throws IOException {
        if (bytes != null && bytes.length > 0) {
            String md5 = InternalUtils.ByteUtils.getMd5((byte[])bytes);
            this.cachedData = bytes;
            this.setupFileInfo(-1, -1, null, null, bytes[0] + md5 + bytes[bytes.length - 1], DEFAULT_EXTENSION, md5);
            return true;
        }
        return false;
    }

    void setupFileInfo(int dependency, int sourcePluginID, String rawPath, String rawName, String name, String extension, String checksum) {
        this.dependency = dependency;
        this.sourcePlugin = sourcePluginID;
        this.rawPath = rawPath;
        this.name = name;
        this.checksum = checksum;
        this.extension = extension;
        this.handle = PluginAssetManager.registerAsset((Asset)this);
        this.onInit();
    }

    byte[] loadData(boolean saveInCache) {
        if (this.cachedData != null) {
            return this.cachedData;
        }
        if (this.source == Source.File) {
            if (this.sourcePlugin >= 0) {
                byte[] data = PluginManager.getResource((int)this.sourcePlugin, (String)this.rawPath);
                if (saveInCache) {
                    this.cachedData = data;
                }
                return data;
            }
            byte[] data = InternalUtils.FileUtils.readBytesFromFile((String)this.rawPath);
            if (saveInCache) {
                this.cachedData = data;
            }
            return data;
        }
        return null;
    }

    abstract void onInit();

    abstract boolean checkFileExtension(String var1);

    public int getHandle() {
        return this.handle;
    }

    public Source getSource() {
        return this.source;
    }

    public Type getType() {
        return this.type;
    }

    public int getDependency() {
        return this.dependency;
    }

    public String getPath() {
        return this.rawPath;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public boolean dispose() {
        if (this.persistent) {
            throw new UnsupportedOperationException("You cannot release this asset!");
        }
        boolean result = PluginAssetManager.disposeAsset((Asset)this);
        this.release();
        return result;
    }

    private void release() {
        AllAssets.remove(this.handle);
        this.handle = -1;
        this.dependency = -1;
        this.sourcePlugin = -1;
        this.source = Source.None;
        this.cachedData = null;
        this.name = null;
        this.checksum = null;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Asset)) {
            return false;
        }
        Asset compare = (Asset)o;
        return this.handle == compare.handle;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.handle);
        return hash;
    }

    public static enum Type {
        Unspecified,
        AssetBundle,
        Texture,
        Model,
        Mesh,
        Prefab,
        Material,
        Sound,
        USS,
        UXML,
        ModelImportSettings;

        private static Type[] values;

        public static Type get(int ordinal) {
            if (values == null) {
                values = Type.values();
            }
            return values[ordinal];
        }
    }

    public static enum Source {
        None,
        Raw,
        File,
        GameAsset,
        AssetBundle,
        URL;

        private static Source[] values;

        public static Source get(int ordinal) {
            if (values == null) {
                values = Source.values();
            }
            return values[ordinal];
        }
    }
}

