/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.util.Arrays;

public enum Key {
    None(0),
    Space(1),
    Enter(2),
    Tab(3),
    Backquote(4),
    Quote(5),
    Semicolon(6),
    Comma(7),
    Period(8),
    Slash(9),
    Backslash(10),
    LeftBracket(11),
    RightBracket(12),
    Minus(13),
    Equals(14),
    A(15),
    B(16),
    C(17),
    D(18),
    E(19),
    F(20),
    G(21),
    H(22),
    I(23),
    J(24),
    K(25),
    L(26),
    M(27),
    N(28),
    O(29),
    P(30),
    Q(31),
    R(32),
    S(33),
    T(34),
    U(35),
    V(36),
    W(37),
    X(38),
    Y(39),
    Z(40),
    Digit1(41),
    Digit2(42),
    Digit3(43),
    Digit4(44),
    Digit5(45),
    Digit6(46),
    Digit7(47),
    Digit8(48),
    Digit9(49),
    Digit0(50),
    LeftShift(51),
    RightShift(52),
    LeftAlt(53),
    RightAlt(54),
    AltGr(54),
    LeftCtrl(55),
    RightCtrl(56),
    LeftMeta(57),
    RightMeta(58),
    LeftWindows(57),
    RightWindows(58),
    LeftApple(57),
    RightApple(58),
    LeftCommand(57),
    RightCommand(58),
    ContextMenu(59),
    Escape(60),
    LeftArrow(61),
    RightArrow(62),
    UpArrow(63),
    DownArrow(64),
    Backspace(65),
    PageDown(66),
    PageUp(67),
    Home(68),
    End(69),
    Insert(70),
    Delete(71),
    CapsLock(72),
    NumLock(73),
    PrintScreen(74),
    ScrollLock(75),
    Pause(76),
    NumpadEnter(77),
    NumpadDivide(78),
    NumpadMultiply(79),
    NumpadPlus(80),
    NumpadMinus(81),
    NumpadPeriod(82),
    NumpadEquals(83),
    Numpad0(84),
    Numpad1(85),
    Numpad2(86),
    Numpad3(87),
    Numpad4(88),
    Numpad5(89),
    Numpad6(90),
    Numpad7(91),
    Numpad8(92),
    Numpad9(93),
    F1(94),
    F2(95),
    F3(96),
    F4(97),
    F5(98),
    F6(99),
    F7(100),
    F8(101),
    F9(102),
    F10(103),
    F11(104),
    F12(105),
    OEM1(106),
    OEM2(107),
    OEM3(108),
    OEM4(109),
    OEM5(110),
    IMESelected(111);

    private int keyCode;
    private static String[] names;
    private static Key[] values;

    private Key(int keyCode) {
        this.keyCode = keyCode;
    }

    private static Key get(int ordinal) {
        if (values == null) {
            values = Key.values();
        }
        return values[ordinal];
    }

    public static Key fromKeyCode(int keyCode) {
        if (values == null) {
            values = Key.values();
        }
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            if (Key.values[i].keyCode != keyCode) continue;
            return values[i];
        }
        return None;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public Key parse(String s) {
        if (s != null) {
            if (names == null) {
                names = (String[])Arrays.stream((Key[])Key.class.getEnumConstants()).map(Enum::name).toArray(String[]::new);
            }
            for (String name : names) {
                if (!name.equalsIgnoreCase(s)) continue;
                return Key.valueOf(name);
            }
        }
        return None;
    }
}

