/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player.world;

import net.risingworld.api.events.player.world.PlayerVegetationEvent;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class PlayerPlaceVegetationEvent
extends PlayerVegetationEvent {
    protected PlayerPlaceVegetationEvent(long pointer) {
        super(pointer);
    }

    public void setTypeID(short typeID) {
        this.CheckIsValid();
        this.setPlantTypeID(this.pointer, typeID);
    }

    public void setPosition(Vector3f position) {
        this.CheckIsValid();
        if (position == null) {
            position = Vector3f.ZERO;
        }
        this.setPlantPosition(this.pointer, position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.CheckIsValid();
        this.setPlantPosition(this.pointer, x, y, z);
    }

    public void setRotation(Quaternion rotation) {
        this.CheckIsValid();
        if (rotation == null) {
            rotation = Quaternion.IDENTITY;
        }
        this.setPlantRotation(this.pointer, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public void setRotation(float pitch, float yaw, float roll) {
        this.CheckIsValid();
        Quaternion rotation = new Quaternion().fromAngles(pitch, yaw, roll);
        this.setPlantRotation(this.pointer, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public boolean isGrowable() {
        this.CheckIsValid();
        return this.getPlantDefinition().cangrow;
    }

    public int getGrowthTime() {
        this.CheckIsValid();
        return this.getGrowthTime(this.pointer);
    }

    public void setGrowthTime(int growthTime) {
        this.CheckIsValid();
        this.setGrowthTime(this.pointer, growthTime);
    }

    private native void setPlantTypeID(long var1, short var3);

    private native void setPlantPosition(long var1, float var3, float var4, float var5);

    private native void setPlantRotation(long var1, float var3, float var4, float var5, float var6);

    private native int getGrowthTime(long var1);

    private native void setGrowthTime(long var1, int var3);
}

