/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.HashMap;
import java.util.Map;
import main.DbHandler;
import main.PlayerPortalMenu;
import main.PortalAssets;
import main.PortalController;
import main.PortalListener;
import main.PortalSettings;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.objects.Area;
import net.risingworld.api.worldelements.Area3D;
import net.risingworld.api.worldelements.Prefab;

public class Portals
extends Plugin {
    private PortalListener portalListener;
    public static Portals portalsMain;
    public static PortalSettings settings;
    public static DbHandler dbHandler;
    public static PortalAssets assets;
    public static HashMap<Area, PortalController> portalControllers;
    public static HashMap<String, PlayerPortalMenu> playerMenus;
    public static HashMap<Area, Prefab> prefabs;

    public void onEnable() {
        portalsMain = this;
        settings = new PortalSettings(this);
    }

    public void continueLoad() {
        assets = new PortalAssets(this);
        portalControllers = new HashMap();
        prefabs = new HashMap();
        this.portalListener = new PortalListener(this);
        playerMenus = new HashMap();
        dbHandler = new DbHandler(this);
    }

    public void onDisable() {
    }

    public void removePortal(Area area) {
        PortalController portalController = portalControllers.get(area);
        String ownerId = portalController.ownerID;
        Integer isAdminPortal = portalController.isAdminPortal;
        if (isAdminPortal == 0) {
            int currentPlacedPortals = dbHandler.getPlacedPortals(ownerId);
            int newPlacedPortalsCount = currentPlacedPortals - 1;
            dbHandler.updatePlacePortals(newPlacedPortalsCount, ownerId);
        }
        this.removeArea3Ds(area);
        dbHandler.removePortal(area);
    }

    public void removeArea3Ds(Area area) {
        for (Map.Entry<String, PlayerPortalMenu> entry : playerMenus.entrySet()) {
            PlayerPortalMenu playerPortalMenu = entry.getValue();
            playerPortalMenu.removeArea3D(area);
        }
        portalControllers.remove(area);
    }

    public void addArea3Ds(Area area, PortalController portalController) {
        portalControllers.put(area, portalController);
        String ownerId = portalController.ownerID;
        Area3D area3D = portalController.area3D;
        for (Map.Entry<String, PlayerPortalMenu> entry : playerMenus.entrySet()) {
            PlayerPortalMenu playerPortalMenu = entry.getValue();
            if (!playerPortalMenu.player.getUID().equalsIgnoreCase(ownerId)) continue;
            playerPortalMenu.addArea3D(area, area3D);
        }
    }

    public void setIsPublic(Long areaId, int isPublic) {
        Area area = Server.getArea((long)areaId);
        if (area != null && portalControllers.containsKey(area)) {
            PortalController portalController = portalControllers.get(area);
            if (isPublic == 0) {
                dbHandler.updateIsPublic(areaId, isPublic);
                portalController.area3D.setColor(1.0f, 0.0f, 1.0f, 0.025f);
                portalController.area3D.setFrameColor(1.0f, 0.0f, 1.0f, 1.0f);
                this.updateArea3Ds(area, isPublic, portalController);
            } else {
                dbHandler.updateIsPublic(areaId, isPublic);
                portalController.area3D.setColor(0.0f, 1.0f, 0.0f, 0.025f);
                portalController.area3D.setFrameColor(0.0f, 1.0f, 0.0f, 1.0f);
                this.updateArea3Ds(area, isPublic, portalController);
            }
        }
    }

    private void updateArea3Ds(Area area, Integer isPublic, PortalController portalController) {
        if (isPublic == 0) {
            for (Map.Entry<String, PlayerPortalMenu> entry : playerMenus.entrySet()) {
                PlayerPortalMenu playerPortalMenu = entry.getValue();
                if (playerPortalMenu.player.getUID().equalsIgnoreCase(portalController.ownerID)) continue;
                playerPortalMenu.removeArea3D(area);
            }
        } else {
            for (Map.Entry<String, PlayerPortalMenu> entry : playerMenus.entrySet()) {
                PlayerPortalMenu playerPortalMenu = entry.getValue();
                if (playerPortalMenu.player.getUID().equalsIgnoreCase(portalController.ownerID)) continue;
                playerPortalMenu.addArea3D(area, portalController.area3D);
            }
        }
    }
}

