/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.DestinationListUi;
import main.PlayerPortalMenu;
import main.PortalController;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UIScrollView;
import net.risingworld.api.ui.style.Pivot;

public class PortalUI {
    private Plugin plugin;
    public PortalController portalController;
    private UIElement portalUI;
    public UILabel publicLabel;
    public UILabel nameLabel;
    public DestinationListUi destinationListUi;
    public UILabel desLabel;

    public PortalUI(Plugin plugin, PortalController portalController) {
        this.plugin = plugin;
        this.portalController = portalController;
        this.destinationListUi = null;
        this.createUi();
    }

    private void createUi() {
        this.portalUI = new UIElement();
        this.portalUI.setSize(40.0f, 40.0f, true);
        this.portalUI.setPosition(50.0f, 50.0f, true);
        this.portalUI.setPivot(Pivot.MiddleCenter);
        this.portalUI.setVisible(false);
        this.portalUI.style.backgroundImage.set(Portals.assets.background);
        this.portalUI.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.portalUI.setBorder(1.0f);
        this.portalUI.setBorderEdgeRadius(10.0f, false);
        this.exitButton();
        this.areaName();
        this.isPublic();
        this.destination();
    }

    private void exitButton() {
        UILabel exitButton = new UILabel("Close"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                PortalUI.this.hideUI(player);
            }
        };
        exitButton.setPivot(Pivot.MiddleCenter);
        exitButton.setBorderEdgeRadius(10.0f, false);
        exitButton.setBorder(1.0f);
        exitButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        exitButton.setVisible(true);
        exitButton.setClickable(true);
        exitButton.setFontSize(22.0f);
        exitButton.setSize(10.0f, 6.0f, true);
        exitButton.setPosition(50.0f, 94.0f, true);
        this.portalUI.addChild((UIElement)exitButton);
    }

    private void areaName() {
        this.nameLabel = new UILabel("Name: " + this.portalController.areaName);
        this.nameLabel.setPivot(Pivot.MiddleCenter);
        this.nameLabel.setVisible(true);
        this.nameLabel.setClickable(false);
        this.nameLabel.setFontSize(22.0f);
        this.nameLabel.setSize(10.0f, 6.0f, true);
        this.nameLabel.setPosition(25.0f, 25.0f, true);
        this.portalUI.addChild((UIElement)this.nameLabel);
        this.renameAreaButton();
    }

    public void renameAreaButton() {
        UILabel renameAreaButton = new UILabel("Rename Area"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                player.showInputMessageBox("Rename Portal", "Enter A New Name)", PortalUI.this.portalController.areaName, text -> {
                    if (text == null) {
                        player.showStatusMessage("Not A valid Name", 5);
                        return;
                    }
                    PortalUI.this.portalController.initAreaRename((String)text);
                });
            }
        };
        renameAreaButton.setPivot(Pivot.MiddleCenter);
        renameAreaButton.setBorderEdgeRadius(10.0f, false);
        renameAreaButton.setBorder(1.0f);
        renameAreaButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        renameAreaButton.setVisible(true);
        renameAreaButton.setClickable(true);
        renameAreaButton.setFontSize(22.0f);
        renameAreaButton.setSize(25.0f, 6.0f, true);
        renameAreaButton.setPosition(75.0f, 25.0f, true);
        this.portalUI.addChild((UIElement)renameAreaButton);
    }

    private void isPublic() {
        String pub = "Type: Private";
        if (this.portalController.isPublic == 1) {
            pub = "Type: Public";
        }
        this.publicLabel = new UILabel(pub);
        this.publicLabel.setPivot(Pivot.MiddleCenter);
        this.publicLabel.setVisible(true);
        this.publicLabel.setClickable(false);
        this.publicLabel.setFontSize(22.0f);
        this.publicLabel.setSize(10.0f, 6.0f, true);
        this.publicLabel.setPosition(25.0f, 50.0f, true);
        this.portalUI.addChild((UIElement)this.publicLabel);
        this.isPublicButton();
    }

    public void isPublicButton() {
        UILabel isPublicButton = new UILabel("Switch"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                PortalUI.this.portalController.updateIsPublic();
            }
        };
        isPublicButton.setPivot(Pivot.MiddleCenter);
        isPublicButton.setBorderEdgeRadius(10.0f, false);
        isPublicButton.setBorder(1.0f);
        isPublicButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        isPublicButton.setVisible(true);
        isPublicButton.setClickable(true);
        isPublicButton.setFontSize(22.0f);
        isPublicButton.setSize(20.0f, 6.0f, true);
        isPublicButton.setPosition(75.0f, 50.0f, true);
        this.portalUI.addChild((UIElement)isPublicButton);
    }

    private void destination() {
        this.desLabel = new UILabel("Dest.: " + String.valueOf(this.portalController.destinationId));
        this.desLabel.setPivot(Pivot.MiddleCenter);
        this.desLabel.setVisible(true);
        this.desLabel.setClickable(false);
        this.desLabel.setFontSize(22.0f);
        this.desLabel.setSize(10.0f, 6.0f, true);
        this.desLabel.setPosition(25.0f, 75.0f, true);
        this.portalUI.addChild((UIElement)this.desLabel);
        this.destinationButton();
    }

    public void destinationButton() {
        UILabel destinationButton = new UILabel("Set"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                PortalUI.this.destinationListUi = new DestinationListUi(PortalUI.this.plugin, player, PortalUI.this.portalController.areaId, PortalUI.this.portalUI, PortalUI.this.portalController);
            }
        };
        destinationButton.setPivot(Pivot.MiddleCenter);
        destinationButton.setBorderEdgeRadius(10.0f, false);
        destinationButton.setBorder(1.0f);
        destinationButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        destinationButton.setVisible(true);
        destinationButton.setClickable(true);
        destinationButton.setFontSize(22.0f);
        destinationButton.setSize(20.0f, 6.0f, true);
        destinationButton.setPosition(75.0f, 75.0f, true);
        this.portalUI.addChild((UIElement)destinationButton);
    }

    public void showUI(Player player) {
        this.portalUI.setVisible(true);
        player.addUIElement(this.portalUI);
        player.setMouseCursorVisible(true);
        PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
        playerPortalMenu.hasMenuOpen = true;
    }

    public void hideUI(Player player) {
        this.portalUI.setVisible(false);
        player.removeUIElement(this.portalUI);
        player.setMouseCursorVisible(false);
        PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
        playerPortalMenu.hasMenuOpen = false;
        if (this.destinationListUi != null) {
            UIScrollView list = this.destinationListUi.destinationUI;
            this.portalUI.removeChild((UIElement)list);
            this.destinationListUi = null;
        }
    }
}

