/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import main.Portals;
import net.risingworld.api.Internals;
import net.risingworld.api.Plugin;
import net.risingworld.api.utils.Utils;

public class PortalSettings {
    private Plugin plugin;
    public Properties properties;
    public String areaOwnerPermission;
    public String defaultAreaPermission;
    public String areaOwnerPermissionFile;
    public String defaultAreaPermissionFile;
    public Integer maxPortals;
    public String canPlaceWilderness;
    public String enableCommand;
    public File[] files;
    public boolean canBoot = false;
    public boolean areaOwnerIsValid = false;
    public boolean defaultAreaIsValid = false;
    public boolean maxPortalsIsValid = false;

    public PortalSettings(Plugin plugin) {
        this.plugin = plugin;
        String directoryPath = Utils.FileUtils.ROOT_DIR;
        String areaPermsPath = directoryPath + "/Permissions/Areas";
        File directory = new File(areaPermsPath);
        this.files = directory.listFiles();
        try {
            this.loadSettings();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadSettings() throws IOException {
        this.properties = new Properties();
        try (FileInputStream stream = new FileInputStream(this.plugin.getPath() + "/portals.properties");){
            boolean isValidInt;
            this.properties.load(stream);
            this.areaOwnerPermissionFile = this.properties.getProperty("AreaOwnerPermissionFile");
            this.defaultAreaPermissionFile = this.properties.getProperty("DefaultAreaPermissionFile");
            this.canPlaceWilderness = this.properties.getProperty("CanPlaceWilderness");
            if (!this.canPlaceWilderness.equalsIgnoreCase("true")) {
                this.canPlaceWilderness = "false";
            }
            this.enableCommand = this.properties.getProperty("ShowAreas");
            if (!this.enableCommand.equalsIgnoreCase("true")) {
                this.enableCommand = "false";
            }
            String maxPortalsString = this.properties.getProperty("MaxPortals");
            ArrayList<String> areaPermissions = new ArrayList<String>();
            for (File file : this.files) {
                String name = file.getName();
                areaPermissions.add(name);
                Internals.println((String)("[WTGPortals] " + name), (int)6);
            }
            if (areaPermissions.contains(this.areaOwnerPermissionFile)) {
                this.areaOwnerPermission = this.areaOwnerPermissionFile.substring(0, this.areaOwnerPermissionFile.lastIndexOf("."));
                this.areaOwnerIsValid = true;
            }
            if (areaPermissions.contains(this.defaultAreaPermissionFile)) {
                this.defaultAreaPermission = this.defaultAreaPermissionFile.substring(0, this.defaultAreaPermissionFile.lastIndexOf("."));
                this.defaultAreaIsValid = true;
            }
            if (isValidInt = this.isInteger(maxPortalsString)) {
                this.maxPortals = Integer.valueOf(maxPortalsString);
                this.maxPortalsIsValid = true;
            }
            if (this.areaOwnerIsValid && this.defaultAreaIsValid && this.maxPortalsIsValid) {
                this.canBoot = true;
            }
        }
        if (this.canBoot) {
            Portals.portalsMain.continueLoad();
            Internals.println((String)("[WTGPortals] Owner Permission: " + this.areaOwnerPermission), (int)6);
            Internals.println((String)("[WTGPortals] Default Permission: " + this.defaultAreaPermission), (int)6);
            Internals.println((String)("[WTGPortals] Max Portals: " + String.valueOf(this.maxPortals)), (int)6);
            Internals.println((String)("[WTGPortals] Place Wilderness: " + String.valueOf(this.canPlaceWilderness)), (int)6);
            Internals.println((String)("[WTGPortals] Show command enabled: " + String.valueOf(this.enableCommand)), (int)6);
        } else {
            if (!this.areaOwnerIsValid) {
                Internals.println((String)("[WTGPortals] Owner Permission: " + this.areaOwnerPermissionFile), (int)6);
                Internals.println((String)"[WTGPortals] Invalid owner permission no entry found or file does not exist", (int)14);
            }
            if (!this.defaultAreaIsValid) {
                Internals.println((String)("[WTGPortals] Default Permission: " + this.defaultAreaPermissionFile), (int)6);
                Internals.println((String)"[WTGPortals] Invalid default permission no entry found or file does not exist", (int)14);
            }
            if (!this.maxPortalsIsValid) {
                Internals.println((String)("[WTGPortals] Max Portals: " + this.properties.getProperty("MaxPortals")), (int)6);
                Internals.println((String)"[WTGPortals] Invalid Max Portals no entry or is not a whole number", (int)14);
            }
            Internals.println((String)"[WTGPortals] Portals Plugin Disabled", (int)14);
        }
    }

    public boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

