/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.PlayerPortalMenu;
import main.PortalController;
import main.Portals;
import net.risingworld.api.Internals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Key;
import net.risingworld.api.worldelements.Area3D;
import net.risingworld.api.worldelements.GameObject;

public class PortalListener
implements Listener {
    private Plugin plugin;

    public PortalListener(Plugin plugin) {
        this.plugin = plugin;
        plugin.registerEventListener((Listener)this);
        Internals.println((String)"[WTGPortals] Portal Listener Started", (int)6);
    }

    @EventMethod
    public void playerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.setListenForKeyInput(true);
        player.registerKeys(new Key[]{Key.X});
        this.initPlayer(player);
    }

    @EventMethod
    public void playerDisConnect(PlayerDisconnectEvent event) {
        Player player = event.getPlayer();
        Portals.playerMenus.remove(player.getUID());
    }

    public void initPlayer(Player player) {
        boolean exists = Portals.dbHandler.checkDbForPlayer(player.getUID());
        if (exists) {
            Portals.dbHandler.loadPlayer(player);
        } else {
            Portals.dbHandler.initNewPlayer(player);
        }
    }

    @EventMethod
    public void enterArea(PlayerEnterAreaEvent event) {
        Player player = event.getPlayer();
        Area area = event.getArea();
        if (area.hasAttribute("PortalController")) {
            PortalController portalController = (PortalController)area.getAttribute("PortalController");
            if (portalController.ownerID.equalsIgnoreCase(player.getUID()) || portalController.isPublic == 1) {
                player.sendYellMessage("Press X to Open Portal!", 3.0f, false);
            }
        }
    }

    @EventMethod
    public void onKeyInput(PlayerKeyEvent event) {
        Player player = event.getPlayer();
        if (event.isPressed()) {
            Area area;
            PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
            if (playerPortalMenu.hasMenuOpen) {
                return;
            }
            if (event.getKey() == Key.X && (area = player.getCurrentArea()) != null && area.hasAttribute("PortalController")) {
                PortalController portalController = (PortalController)area.getAttribute("PortalController");
                portalController.portalMenu(player);
            }
        }
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String[] cmd = event.getCommand().split(" ");
        PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
        if (cmd[0].equalsIgnoreCase("/showareas")) {
            if (Portals.settings.enableCommand.equalsIgnoreCase("true")) {
                Area[] areas;
                for (Area area : areas = Server.getAllAreas()) {
                    String areaPerm;
                    if (area.hasAttribute("PortalController") || (areaPerm = area.getPlayerPermission(player)) == null) continue;
                    Area3D area3D = new Area3D(area);
                    area3D.setAlwaysVisible(true);
                    area3D.setFrameVisible(true);
                    area3D.setColor(1.0f, 0.0f, 0.0f, 0.75f);
                    area3D.setFrameColor(1.0f, 0.0f, 0.0f, 1.0f);
                    player.addGameObject((GameObject)area3D);
                    playerPortalMenu.showareas.add(area3D);
                }
            } else {
                player.sendTextMessage("Command Disabled");
            }
        }
        if (cmd[0].equalsIgnoreCase("/hideareas")) {
            if (Portals.settings.enableCommand.equalsIgnoreCase("true")) {
                for (Area3D area3d : playerPortalMenu.showareas) {
                    player.removeGameObject((GameObject)area3d);
                }
                playerPortalMenu.showareas.clear();
            } else {
                player.sendTextMessage("Command Disabled");
            }
        }
    }
}

