/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.DbHandler;
import main.PlayerPortalMenu;
import main.PortalTpButton;
import main.PortalUI;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.Area3D;
import net.risingworld.api.worldelements.Prefab;

public class PortalController {
    private Plugin plugin;
    public Long areaId;
    public String ownerID;
    public Integer isPublic;
    public Vector3f landing;
    public Area3D area3D;
    public Prefab prefab;
    public PortalUI portalUI;
    public Integer isAdminPortal;
    public PortalTpButton portalTpButton;
    public Area area;
    public String areaName;
    public Long destinationId;
    private DbHandler dbHandler;
    public String[] ownerMenu = new String[]{"Open", "Edit", "Set Home", "Remove"};
    public String[] publicMenu = new String[]{"Open"};

    public PortalController(DbHandler dbHandler, Plugin plugin, Long areaId, String ownerID, Integer isPublic, float landingX, float landingY, float landingZ, Integer isAdminPortal, Long destination) {
        this.area = Server.getArea((long)areaId);
        this.isAdminPortal = isAdminPortal;
        this.ownerID = ownerID;
        this.dbHandler = dbHandler;
        if (this.area == null) {
            dbHandler.removeInvalidAreaData(areaId, ownerID, isAdminPortal);
            return;
        }
        this.destinationId = destination;
        this.areaName = this.area.getName();
        Portals.portalsMain.addArea3Ds(this.area, this);
        this.area.setAttribute("PortalController", (Object)this);
        this.plugin = plugin;
        this.areaId = areaId;
        this.isPublic = isPublic;
        this.landing = new Vector3f(landingX, landingY, landingZ);
        this.prefab = null;
        this.portalUI = new PortalUI(plugin, this);
        this.portalTpButton = new PortalTpButton(plugin, this, this.area.getName());
        ++dbHandler.loadedPortals;
        this.createArea3D(this.area);
    }

    public void initAreaRename(String text) {
        Portals.dbHandler.updateName(this.areaId, text);
        this.areaName = text;
        this.updateAreaName();
    }

    private void createArea3D(Area area) {
        this.area3D = new Area3D(area);
        this.area3D.setAlwaysVisible(false);
        this.area3D.setFrameVisible(false);
        if (this.isPublic == 0) {
            this.area3D.setColor(1.0f, 0.0f, 1.0f, 0.025f);
            this.area3D.setFrameColor(1.0f, 0.0f, 1.0f, 1.0f);
        } else {
            this.area3D.setColor(0.0f, 1.0f, 0.0f, 0.025f);
            this.area3D.setFrameColor(0.0f, 1.0f, 0.0f, 1.0f);
        }
    }

    public void updateArea3D() {
        if (this.isPublic == 0) {
            this.area3D.setColor(1.0f, 0.0f, 1.0f, 0.025f);
            this.area3D.setFrameColor(1.0f, 0.0f, 1.0f, 1.0f);
        } else {
            this.area3D.setColor(0.0f, 1.0f, 0.0f, 0.025f);
            this.area3D.setFrameColor(0.0f, 1.0f, 0.0f, 1.0f);
        }
    }

    public void portalMenu(Player player) {
        if (player.getUID().equalsIgnoreCase(this.ownerID)) {
            this.showOwnerMenu(player);
        } else if (this.isPublic == 1) {
            this.showPublicMenu(player);
        }
    }

    public void updateIsPublic() {
        if (this.isPublic == 0) {
            this.isPublic = 1;
            Portals.portalsMain.setIsPublic(this.areaId, this.isPublic);
            this.portalUI.publicLabel.setText("Type: Public");
            return;
        }
        this.isPublic = 0;
        Portals.portalsMain.setIsPublic(this.areaId, this.isPublic);
        this.portalUI.publicLabel.setText("Type: Private");
    }

    public void updateAreaName() {
        this.portalUI.nameLabel.setText("Name: " + this.areaName);
        this.portalTpButton.updateName(this.areaName);
    }

    public void updateDestination(Long destinationId) {
        this.destinationId = destinationId;
        this.portalUI.desLabel.setText("Dest.: " + String.valueOf(destinationId));
        this.dbHandler.updateDestination(this.areaId, destinationId);
    }

    private void showOwnerMenu(Player player) {
        PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
        if (playerPortalMenu.disabled == 1) {
            player.sendYellMessage("Portals Disabled", 10.0f, true);
            return;
        }
        player.showContextMenu(this.ownerMenu, entry -> {
            Area area;
            if (entry.equals(this.ownerMenu[0])) {
                if (this.destinationId == 0L) {
                    playerPortalMenu.showPlayerPortalUI();
                } else {
                    area = Server.getArea((long)this.destinationId);
                    if (area != null) {
                        PortalController desPortal = (PortalController)area.getAttribute("PortalController");
                        player.setPosition(desPortal.landing);
                    } else {
                        player.sendYellMessage("Error with destination portal! \n Opening portal menu", 5.0f, false);
                        playerPortalMenu.showPlayerPortalUI();
                        this.destinationId = 0L;
                        this.dbHandler.updateDestination(this.areaId, this.destinationId);
                    }
                }
            }
            if (entry.equals(this.ownerMenu[1])) {
                this.portalUI.showUI(playerPortalMenu.player);
            }
            if (entry.equals(this.ownerMenu[2])) {
                playerPortalMenu.setHome(this.areaId);
            }
            if (entry.equals(this.ownerMenu[3])) {
                area = Server.getArea((long)this.areaId);
                Portals.portalsMain.removePortal(area);
            }
        });
    }

    private void showPublicMenu(Player player) {
        PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
        if (playerPortalMenu.disabled == 1) {
            player.sendYellMessage("Portals Disabled", 10.0f, true);
            return;
        }
        player.showContextMenu(this.publicMenu, entry -> {
            if (entry.equals(this.publicMenu[0])) {
                playerPortalMenu.showPlayerPortalUI();
            }
        });
    }
}

