/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.HashMap;
import java.util.Map;
import main.PlayerPortalMenu;
import main.PortalController;
import main.PortalTpButton;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UIScrollView;
import net.risingworld.api.ui.style.Pivot;

public class PlayerPortalUI {
    private Plugin plugin;
    private PlayerPortalMenu playerPortalMenu;
    private UIElement playerPortalUI;
    private Player player;
    private UIScrollView publicPortalsScroll;
    private UIScrollView playerPortalsScroll;
    private HashMap<UIElement, PortalController> publicButtons;

    public PlayerPortalUI(Plugin plugin, PlayerPortalMenu playerPortalMenu) {
        this.plugin = plugin;
        this.playerPortalMenu = playerPortalMenu;
        this.player = playerPortalMenu.player;
        this.publicButtons = new HashMap();
        this.createUi(this.player);
    }

    private void createUi(Player player) {
        this.playerPortalUI = new UIElement();
        this.playerPortalUI.setSize(50.0f, 90.0f, true);
        this.playerPortalUI.setPosition(50.0f, 50.0f, true);
        this.playerPortalUI.setPivot(Pivot.MiddleCenter);
        this.playerPortalUI.setVisible(false);
        this.playerPortalUI.style.backgroundImage.set(Portals.assets.background);
        this.playerPortalUI.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.playerPortalUI.setBorder(1.0f);
        this.playerPortalUI.setBorderEdgeRadius(10.0f, false);
        UILabel playerPortalLabel = new UILabel("My Portals");
        playerPortalLabel.setPivot(Pivot.MiddleCenter);
        playerPortalLabel.setPosition(25.0f, 5.0f, true);
        playerPortalLabel.setVisible(true);
        playerPortalLabel.setFontSize(16.0f);
        this.playerPortalUI.addChild((UIElement)playerPortalLabel);
        UILabel publicPortalLabel = new UILabel("Public Portals");
        publicPortalLabel.setPivot(Pivot.MiddleCenter);
        publicPortalLabel.setPosition(75.0f, 5.0f, true);
        publicPortalLabel.setVisible(true);
        publicPortalLabel.setFontSize(16.0f);
        this.playerPortalUI.addChild((UIElement)publicPortalLabel);
        UILabel portalLabel = new UILabel("Portals");
        portalLabel.setPivot(Pivot.MiddleCenter);
        portalLabel.setPosition(50.0f, 2.0f, true);
        portalLabel.setVisible(true);
        portalLabel.setFontSize(30.0f);
        this.playerPortalUI.addChild((UIElement)portalLabel);
        this.exitButton();
        this.playerPortals();
        this.publicPortals();
        player.addUIElement(this.playerPortalUI);
    }

    private void exitButton() {
        UILabel exitButton = new UILabel("Close"){

            public void onClick(PlayerUIElementClickEvent event) {
                PlayerPortalUI.this.playerPortalMenu.hidePlayerPortalUI();
            }
        };
        exitButton.setPivot(Pivot.MiddleCenter);
        exitButton.setBorderEdgeRadius(10.0f, false);
        exitButton.setBorder(1.0f);
        exitButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        exitButton.setVisible(true);
        exitButton.setClickable(true);
        exitButton.setFontSize(22.0f);
        exitButton.setSize(10.0f, 5.0f, true);
        exitButton.setPosition(50.0f, 94.0f, true);
        this.playerPortalUI.addChild((UIElement)exitButton);
    }

    private void playerPortals() {
        this.playerPortalsScroll = new UIScrollView(UIScrollView.ScrollViewMode.Vertical);
        this.playerPortalsScroll.setVerticalScrollerVisibility(UIScrollView.ScrollerVisibility.Hidden);
        this.playerPortalsScroll.setPivot(Pivot.MiddleCenter);
        this.playerPortalsScroll.setSize(40.0f, 80.0f, true);
        this.playerPortalsScroll.setPosition(25.0f, 47.5f, true);
        this.playerPortalsScroll.style.paddingTop.set(1.0f);
        this.playerPortalsScroll.style.paddingBottom.set(1.0f);
        this.playerPortalsScroll.setBorder(2.0f);
        this.playerPortalsScroll.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.playerPortalsScroll.setBorderEdgeRadius(10.0f, false);
        this.playerPortalsScroll.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.5f);
        this.playerPortalsScroll.setPivot(Pivot.MiddleCenter);
        this.playerPortalsScroll.setVisible(true);
        this.playerPortalUI.addChild((UIElement)this.playerPortalsScroll);
    }

    private void publicPortals() {
        this.publicPortalsScroll = new UIScrollView(UIScrollView.ScrollViewMode.Vertical);
        this.publicPortalsScroll.setVerticalScrollerVisibility(UIScrollView.ScrollerVisibility.Hidden);
        this.publicPortalsScroll.setPivot(Pivot.MiddleCenter);
        this.publicPortalsScroll.setSize(40.0f, 80.0f, true);
        this.publicPortalsScroll.setPosition(75.0f, 47.5f, true);
        this.publicPortalsScroll.style.paddingTop.set(1.0f);
        this.publicPortalsScroll.style.paddingBottom.set(1.0f);
        this.publicPortalsScroll.setBorder(2.0f);
        this.publicPortalsScroll.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.publicPortalsScroll.setBorderEdgeRadius(10.0f, false);
        this.publicPortalsScroll.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.5f);
        this.publicPortalsScroll.setPivot(Pivot.MiddleCenter);
        this.publicPortalsScroll.setVisible(true);
        this.playerPortalUI.addChild((UIElement)this.publicPortalsScroll);
    }

    private void loadPortals() {
        String playerId = this.player.getUID();
        for (Map.Entry<Area, PortalController> entry : Portals.portalControllers.entrySet()) {
            PortalController portalController = entry.getValue();
            PortalTpButton portalTpButton = portalController.portalTpButton;
            if (portalController.ownerID.equalsIgnoreCase(playerId)) {
                this.playerPortalsScroll.addChild(portalTpButton.portalTpButton);
            }
            if (portalController.isPublic != 1) continue;
            UIElement publicButton = portalTpButton.publicTpButton(this.player);
            this.publicPortalsScroll.addChild(publicButton);
            this.publicButtons.put(publicButton, portalController);
        }
    }

    public void showUI() {
        this.playerPortalUI.setVisible(true);
        this.player.setMouseCursorVisible(true);
        this.loadPortals();
    }

    public void hideUI() {
        this.playerPortalUI.setVisible(false);
        this.player.setMouseCursorVisible(false);
        this.publicPortalsScroll.removeAllChilds();
        this.playerPortalsScroll.removeAllChilds();
        this.publicButtons.clear();
    }
}

