/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import main.AdminMenu;
import main.PlayerPortalUI;
import main.PortalController;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.MessageBoxButtons;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UITarget;
import net.risingworld.api.ui.style.FontStyle;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.worldelements.Area3D;
import net.risingworld.api.worldelements.GameObject;

public class PlayerPortalMenu {
    private Plugin plugin;
    public UIElement portalsMenu;
    public UILabel placedPortalsLabel;
    public UILabel placePortalButton;
    public UILabel showPortalButton;
    public Player player;
    public int disabled;
    public int placedPortals;
    public long homePortalId;
    public int maxPortals;
    public boolean hasMenuOpen = false;
    public PlayerPortalUI playerPortalUI;
    public HashMap<Area, Area3D> area3Ds;
    public ArrayList<Area3D> showareas;
    private AdminMenu adminMenu;

    public PlayerPortalMenu(Plugin plugin, Player player, Integer placedPortals, Long homePortalId, Integer maxPortals, Integer disabled) {
        this.plugin = plugin;
        this.player = player;
        this.placedPortals = placedPortals;
        this.homePortalId = homePortalId;
        this.maxPortals = maxPortals;
        this.disabled = disabled;
        this.adminMenu = null;
        this.showareas = new ArrayList();
        this.addElement();
        this.playerPortalUI = new PlayerPortalUI(plugin, this);
        Portals.playerMenus.put(player.getUID(), this);
        this.area3Ds = new HashMap();
        this.init3Ds();
    }

    private void init3Ds() {
        for (Map.Entry<Area, PortalController> entry : Portals.portalControllers.entrySet()) {
            Area area = entry.getKey();
            PortalController portalController = entry.getValue();
            if (!portalController.ownerID.equalsIgnoreCase(this.player.getUID()) && portalController.isPublic != 1) continue;
            this.area3Ds.put(area, portalController.area3D);
        }
    }

    public void showAreas() {
        for (Map.Entry<Area, Area3D> entry : this.area3Ds.entrySet()) {
            Area3D area3D = entry.getValue();
            area3D.setAlwaysVisible(false);
            this.player.addGameObject((GameObject)area3D);
        }
    }

    public void hideAreas() {
        for (Map.Entry<Area, Area3D> entry : this.area3Ds.entrySet()) {
            Area3D area3D = entry.getValue();
            area3D.setAlwaysVisible(false);
            this.player.removeGameObject((GameObject)area3D);
        }
    }

    public void removeArea3D(Area area) {
        if (this.area3Ds.containsKey(area)) {
            this.player.removeGameObject((GameObject)this.area3Ds.get(area));
            this.area3Ds.remove(area);
        }
    }

    public void addArea3D(Area area, Area3D area3D) {
        this.area3Ds.put(area, area3D);
        if (this.showPortalButton.getText().equalsIgnoreCase("Hide")) {
            this.player.addGameObject((GameObject)area3D);
        }
    }

    public void addElement() {
        this.portalsMenu = new UIElement();
        this.portalsMenu.setPivot(Pivot.MiddleCenter);
        this.portalsMenu.setSize(45.0f, 9.0f, true);
        this.portalsMenu.setPosition(50.0f, 9.0f, true);
        this.portalsMenu.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.75f);
        this.portalsMenu.setBorderEdgeRadius(22.5f, false);
        this.portalsMenu.setVisible(true);
        UILabel portalsMenuLabel = new UILabel("Portals");
        portalsMenuLabel.setFontSize(22.0f);
        portalsMenuLabel.setPivot(Pivot.MiddleCenter);
        portalsMenuLabel.style.fontStyleAndWeight.set((Enum)FontStyle.Bold);
        portalsMenuLabel.setPosition(50.0f, 11.0f, true);
        this.portalsMenu.addChild((UIElement)portalsMenuLabel);
        this.player.addUIElement(this.portalsMenu, UITarget.Inventory);
        this.buildMenu();
    }

    private void buildMenu() {
        this.placePortalButton();
        this.placedPortalsLabel();
        this.showPortalButton();
        this.homePortalButton();
        if (this.player.isAdmin()) {
            this.adminPortalButton();
        }
        this.initMenu();
    }

    public void initMenu() {
        if (this.placedPortals < this.maxPortals) {
            this.placePortalButton.setClickable(true);
        }
        if (this.placedPortals >= this.maxPortals) {
            this.placePortalButton.setClickable(false);
        }
        this.placedPortalsLabel.setText(String.valueOf(this.placedPortals) + " of " + String.valueOf(this.maxPortals));
    }

    private void placedPortalsLabel() {
        this.placedPortalsLabel = new UILabel();
        this.placedPortalsLabel.setFontSize(20.0f);
        this.placedPortalsLabel.setPivot(Pivot.MiddleCenter);
        this.placedPortalsLabel.setPosition(7.5f, 50.0f, true);
        this.portalsMenu.addChild((UIElement)this.placedPortalsLabel);
    }

    private void placePortalButton() {
        this.placePortalButton = new UILabel("Place"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                Area area = player.getCurrentArea();
                if (area == null) {
                    if (Portals.settings.canPlaceWilderness.equalsIgnoreCase("True") || player.isAdmin()) {
                        PlayerPortalMenu.this.showPlacePortalMessage(player);
                    } else {
                        player.sendYellMessage("Cannot Place Portal Here", 10.0f, false);
                    }
                }
                if (area != null) {
                    String areaPerm = area.getPlayerPermission(player);
                    if (area.hasAttribute("PortalController")) {
                        player.sendYellMessage("Cannot Place Portal Here", 10.0f, false);
                        return;
                    }
                    if (player.isAdmin()) {
                        PlayerPortalMenu.this.showPlacePortalMessage(player);
                        return;
                    }
                    if (areaPerm != null) {
                        PlayerPortalMenu.this.showPlacePortalMessage(player);
                        return;
                    }
                    player.sendYellMessage("Cannot Place Portal Here", 10.0f, false);
                }
            }
        };
        this.placePortalButton.setFontSize(20.0f);
        this.placePortalButton.setPivot(Pivot.MiddleCenter);
        this.placePortalButton.setPosition(25.0f, 50.0f, true);
        this.placePortalButton.setSize(10.0f, 25.0f, true);
        this.placePortalButton.setBorderEdgeRadius(7.5f, false);
        this.placePortalButton.setBorder(2.0f);
        this.placePortalButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.placePortalButton.setClickable(true);
        this.portalsMenu.addChild((UIElement)this.placePortalButton);
    }

    private void showPlacePortalMessage(Player player) {
        if (this.disabled == 1) {
            player.sendYellMessage("Portals Disabled", 10.0f, true);
            return;
        }
        player.showMessageBox(MessageBoxButtons.Yes_No, "Place Portal", "Place Portal?", 15, response -> {
            if (response == 0) {
                if (player.isAdmin()) {
                    player.showMessageBox(MessageBoxButtons.Yes_No, "Place Portal", "Place Portal As Admin ?\n Admin Portals do NOT count Against Placed Portal Count!", 15, asAdmin -> {
                        if (asAdmin == 0) {
                            Portals.dbHandler.createPortal(player, "admin");
                        }
                        if (asAdmin == 1 || asAdmin == 2) {
                            Portals.dbHandler.createPortal(player, "player");
                        }
                    });
                } else {
                    Portals.dbHandler.createPortal(player, "player");
                }
            }
            if (response == 1 || response == 2) {
                player.showStatusMessage("Place Portal Canceled", 5);
            }
        });
    }

    private void showPortalButton() {
        this.showPortalButton = new UILabel("Show"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                if (PlayerPortalMenu.this.showPortalButton.getText().equalsIgnoreCase("Show")) {
                    PlayerPortalMenu.this.showPortalButton.setText("Hide");
                    PlayerPortalMenu.this.showAreas();
                } else {
                    PlayerPortalMenu.this.showPortalButton.setText("Show");
                    PlayerPortalMenu.this.hideAreas();
                }
            }
        };
        this.showPortalButton.setFontSize(20.0f);
        this.showPortalButton.setPivot(Pivot.MiddleCenter);
        this.showPortalButton.setPosition(45.0f, 50.0f, true);
        this.showPortalButton.setSize(10.0f, 25.0f, true);
        this.showPortalButton.setBorderEdgeRadius(7.5f, false);
        this.showPortalButton.setBorder(2.0f);
        this.showPortalButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.showPortalButton.setClickable(true);
        this.portalsMenu.addChild((UIElement)this.showPortalButton);
    }

    private void homePortalButton() {
        UILabel homePortalButton = new UILabel("Home"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                if (PlayerPortalMenu.this.disabled == 1) {
                    player.sendYellMessage("Portals Disabled", 10.0f, true);
                    return;
                }
                if (PlayerPortalMenu.this.homePortalId == 0L) {
                    player.showMessageBox(MessageBoxButtons.Yes_No, "Home", "No Home Portal Set! TP to Server Spawn?", 15, response -> {
                        if (response == 0) {
                            player.setPosition(Server.getDefaultSpawnPosition());
                        }
                        if (response == 1 || response == 2) {
                            player.showStatusMessage("Home Canceled", 5);
                        }
                    });
                } else {
                    Area area = Server.getArea((long)PlayerPortalMenu.this.homePortalId);
                    if (area != null) {
                        PortalController portalController = (PortalController)area.getAttribute("PortalController");
                        player.setPosition(portalController.landing);
                    } else {
                        player.showWarningMessageBox("Invalid Area", "This portal is no long valid\n redirecting you to spawn");
                        player.setPosition(Server.getDefaultSpawnPosition());
                        Portals.dbHandler.updateHomePortal(player.getUID(), 0L);
                        PlayerPortalMenu.this.homePortalId = 0L;
                    }
                }
            }
        };
        homePortalButton.setFontSize(20.0f);
        homePortalButton.setPivot(Pivot.MiddleCenter);
        homePortalButton.setPosition(65.0f, 50.0f, true);
        homePortalButton.setSize(10.0f, 25.0f, true);
        homePortalButton.setBorderEdgeRadius(7.5f, false);
        homePortalButton.setBorder(2.0f);
        homePortalButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        homePortalButton.setClickable(true);
        this.portalsMenu.addChild((UIElement)homePortalButton);
    }

    private void adminPortalButton() {
        UILabel adminPortalButton = new UILabel("Admin"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                if (PlayerPortalMenu.this.adminMenu != null) {
                    PlayerPortalMenu.this.adminMenu.buildPlayers();
                    PlayerPortalMenu.this.adminMenu.buildPortals();
                    PlayerPortalMenu.this.adminMenu.initAdminArea3Ds();
                    PlayerPortalMenu.this.adminMenu.adminUI.setVisible(true);
                    player.setMouseCursorVisible(true);
                    player.hideInventory();
                }
            }
        };
        adminPortalButton.setFontSize(20.0f);
        adminPortalButton.setPivot(Pivot.MiddleCenter);
        adminPortalButton.setPosition(85.0f, 50.0f, true);
        adminPortalButton.setSize(10.0f, 25.0f, true);
        adminPortalButton.setBorderEdgeRadius(7.5f, false);
        adminPortalButton.setBorder(2.0f);
        adminPortalButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        adminPortalButton.setClickable(true);
        this.portalsMenu.addChild((UIElement)adminPortalButton);
        this.adminMenu = new AdminMenu(this.plugin, this.player);
    }

    public void showPlayerPortalUI() {
        this.playerPortalUI.showUI();
        this.hasMenuOpen = true;
    }

    public void hidePlayerPortalUI() {
        this.playerPortalUI.hideUI();
        this.hasMenuOpen = false;
    }

    public void setHome(Long areaId) {
        this.homePortalId = areaId;
        Portals.dbHandler.updateHomePortal(this.player.getUID(), areaId);
    }
}

