/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.Map;
import main.PortalController;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UIScrollView;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.ui.style.TextAnchor;

public class DestinationListUi {
    private Plugin plugin;
    private Long currentArea;
    public UIScrollView destinationUI;
    public UIElement portalUI;
    private PortalController portalController;
    private String playerId;

    public DestinationListUi(Plugin plugin, Player player, Long currentArea, UIElement portalUI, PortalController portalController) {
        this.plugin = plugin;
        this.currentArea = currentArea;
        this.portalUI = portalUI;
        this.portalController = portalController;
        this.playerId = player.getUID();
        this.createDestinationList();
    }

    public void createDestinationList() {
        this.destinationUI = new UIScrollView(UIScrollView.ScrollViewMode.Vertical);
        this.destinationUI.setVerticalScrollerVisibility(UIScrollView.ScrollerVisibility.Hidden);
        this.destinationUI.setPivot(Pivot.MiddleCenter);
        this.destinationUI.setSize(40.0f, 80.0f, true);
        this.destinationUI.setPosition(50.0f, 50.0f, true);
        this.destinationUI.style.paddingTop.set(1.0f);
        this.destinationUI.style.paddingBottom.set(1.0f);
        this.destinationUI.setBorder(2.0f);
        this.destinationUI.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.destinationUI.setBorderEdgeRadius(10.0f, false);
        this.destinationUI.setBackgroundColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.destinationUI.setPivot(Pivot.MiddleCenter);
        this.destinationUI.setVisible(true);
        this.portalUI.addChild((UIElement)this.destinationUI);
        this.closeButton();
    }

    private void closeButton() {
        UILabel exitButton = new UILabel("Close List"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                DestinationListUi.this.closeList();
            }
        };
        exitButton.setTextAlign(TextAnchor.MiddleCenter);
        exitButton.setBorder(1.0f);
        exitButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        exitButton.style.height.set(50.0f);
        exitButton.style.marginTop.set(4.0f);
        exitButton.style.marginLeft.set(10.0f);
        exitButton.style.marginRight.set(10.0f);
        exitButton.setBorderEdgeRadius(10.0f, false);
        exitButton.setVisible(true);
        exitButton.setClickable(true);
        this.destinationUI.addChild((UIElement)exitButton);
        this.resetDestinationButton();
    }

    private void resetDestinationButton() {
        UILabel resetButton = new UILabel("Remove Destination"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                DestinationListUi.this.portalController.updateDestination(0L);
                DestinationListUi.this.closeList();
            }
        };
        resetButton.setTextAlign(TextAnchor.MiddleCenter);
        resetButton.setBorder(1.0f);
        resetButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        resetButton.style.height.set(50.0f);
        resetButton.style.marginTop.set(4.0f);
        resetButton.style.marginLeft.set(10.0f);
        resetButton.style.marginRight.set(10.0f);
        resetButton.setBorderEdgeRadius(10.0f, false);
        resetButton.setVisible(true);
        resetButton.setClickable(true);
        this.destinationUI.addChild((UIElement)resetButton);
        this.destinationButtons();
    }

    private void destinationButtons() {
        for (Map.Entry<Area, PortalController> entry : Portals.portalControllers.entrySet()) {
            PortalController desPortalController = entry.getValue();
            if (!desPortalController.ownerID.equalsIgnoreCase(this.playerId)) continue;
            String name = desPortalController.areaName;
            final Long desId = desPortalController.areaId;
            UILabel desButton = new UILabel(name){

                public void onClick(PlayerUIElementClickEvent event) {
                    Player player = event.getPlayer();
                    DestinationListUi.this.portalController.updateDestination(desId);
                    DestinationListUi.this.closeList();
                }
            };
            desButton.setTextAlign(TextAnchor.MiddleCenter);
            desButton.setBorder(1.0f);
            desButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
            desButton.style.height.set(50.0f);
            desButton.style.marginTop.set(4.0f);
            desButton.style.marginLeft.set(10.0f);
            desButton.style.marginRight.set(10.0f);
            desButton.setBorderEdgeRadius(10.0f, false);
            desButton.setVisible(true);
            desButton.setClickable(true);
            this.destinationUI.addChild((UIElement)desButton);
        }
    }

    private void closeList() {
        this.destinationUI.removeAllChilds();
        this.destinationUI.getParent().removeChild((UIElement)this.destinationUI);
    }
}

