/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import main.AdminPlayerElement;
import main.AdminPortalElement;
import main.PlayerPortalMenu;
import main.PortalController;
import main.Portals;
import net.risingworld.api.Internals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class DbHandler {
    private Plugin plugin;
    public Database portals;
    public WorldDatabase areasDb;
    public ArrayList<Long> areasToRemove;
    public ArrayList<String> playersToValidate;
    public int loadedPortals = 0;
    public int publicPortals = 0;

    public DbHandler(Plugin plugin) {
        this.plugin = plugin;
        this.areasToRemove = new ArrayList();
        this.playersToValidate = new ArrayList();
        this.loadDb();
    }

    private void loadDb() {
        this.portals = this.plugin.getSQLiteConnection(this.plugin.getPath() + "/" + World.getName() + "/Portals.db");
        this.areasDb = this.plugin.getWorldDatabase(WorldDatabase.Target.Areas);
        this.portals.execute("CREATE TABLE IF NOT EXISTS `PORTALS` (`AREAID` BIGINT, `OWNERID` VARCHAR(255), `ISPUBLIC` BIGINT, `LANDINGX` BIGINT, `LANDINGY` BIGINT, `LANDINGZ` BIGINT, `ADMINPORTAL` BIGINT, `DESTINATION` BIGINT, `PREFABID` BIGINT)");
        this.portals.execute("CREATE TABLE IF NOT EXISTS `PLAYERS` ( `PLAYERID` VARCHAR(255), `HOMEPORTALID` BIGINT, `PLACEDPORTALS` BIGINT, `MAXPORTALS` BIGINT, `DISABLED` BIGINT)");
        this.initPortals();
    }

    public void closeDb() {
        this.portals.close();
    }

    public void updateName(Long areaId, String name) {
        this.areasDb.executeUpdate("UPDATE areas SET `name` = '" + name + "'where id = '" + areaId + "'");
    }

    public void initPortals() {
        try {
            ResultSet result = this.portals.executeQuery("SELECT * FROM `PORTALS` ");
            while (result.next()) {
                long areaId = result.getLong("AREAID");
                float landingx = result.getFloat("LANDINGX");
                float landingy = result.getFloat("LANDINGY");
                float landingz = result.getFloat("LANDINGZ");
                String ownerId = result.getString("OWNERID");
                int isPublic = result.getInt("ISPUBLIC");
                if (isPublic == 1) {
                    ++this.publicPortals;
                }
                long destinationId = result.getInt("DESTINATION");
                Integer isAdminPortal = result.getInt("ADMINPORTAL");
                new PortalController(this, this.plugin, areaId, ownerId, isPublic, landingx, landingy, landingz, isAdminPortal, destinationId);
            }
            Internals.println((String)("[WTGPortals] Loaded " + String.valueOf(this.loadedPortals) + " portals"), (int)6);
            Internals.println((String)("[WTGPortals] Loaded " + String.valueOf(this.publicPortals) + " public portals"), (int)6);
            Internals.println((String)("[WTGPortals] Removing " + String.valueOf(this.areasToRemove.size()) + " invalid areas"), (int)6);
            Internals.println((String)("[WTGPortals] Player needing validation " + String.valueOf(this.playersToValidate.size())), (int)6);
            for (Long areaId : this.areasToRemove) {
                this.removeInvalidAreas(areaId);
            }
            for (String playerID : this.playersToValidate) {
                this.validatePlayer(playerID);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public ArrayList<AdminPlayerElement> buildAdminPlayers() {
        ArrayList<AdminPlayerElement> playerElements = new ArrayList<AdminPlayerElement>();
        try {
            ResultSet result = this.portals.executeQuery("SELECT * FROM `PLAYERS` ");
            while (result.next()) {
                String playerId = result.getString("PLAYERID");
                Long homePortal = result.getLong("HOMEPORTALID");
                String playerName = Server.getLastKnownPlayerName((String)playerId);
                Integer placedPortals = result.getInt("PLACEDPORTALS");
                Integer maxPortals = result.getInt("MAXPORTALS");
                Integer disabled = result.getInt("DISABLED");
                AdminPlayerElement adminPlayerElement = new AdminPlayerElement(this.plugin, playerId, playerName, homePortal, placedPortals, maxPortals, disabled);
                playerElements.add(adminPlayerElement);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return playerElements;
    }

    public ArrayList<AdminPortalElement> buildAdminPortals() {
        ArrayList<AdminPortalElement> portalElements = new ArrayList<AdminPortalElement>();
        try {
            ResultSet result = this.portals.executeQuery("SELECT * FROM `PORTALS` ");
            while (result.next()) {
                long areaID = result.getLong("AREAID");
                String ownerId = result.getString("OWNERID");
                String ownerName = Server.getLastKnownPlayerName((String)ownerId);
                float landingX = result.getFloat("LANDINGX");
                float landingY = result.getFloat("LANDINGY");
                float landingZ = result.getFloat("LANDINGZ");
                int isAdminPortal = result.getInt("ADMINPORTAL");
                int isPublicPortal = result.getInt("ISPUBLIC");
                long destinationId = result.getLong("DESTINATION");
                AdminPortalElement adminPlayerElement = new AdminPortalElement(this.plugin, areaID, ownerId, ownerName, landingX, landingY, landingZ, isAdminPortal, isPublicPortal, destinationId);
                portalElements.add(adminPlayerElement);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return portalElements;
    }

    public void removeInvalidAreaData(Long areaId, String ownerId, Integer isAdminPortal) {
        if (isAdminPortal == 0 && !this.playersToValidate.contains(ownerId)) {
            this.playersToValidate.add(ownerId);
        }
        this.areasToRemove.add(areaId);
    }

    public void validatePlayer(String playerId) {
        int placedPortals = 0;
        try {
            ResultSet result = this.portals.executeQuery("SELECT * FROM `PORTALS` ");
            while (result.next()) {
                String ownerId = result.getString("OWNERID");
                Integer isAdminPortal = result.getInt("ADMINPORTAL");
                if (!ownerId.equalsIgnoreCase(playerId) || isAdminPortal != 0) continue;
                ++placedPortals;
            }
            Internals.println((String)("[WTGPortals] Validating Player " + playerId), (int)6);
            this.updatePlacePortals(placedPortals, playerId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeInvalidAreas(Long areaId) {
        this.portals.execute("DELETE FROM `PORTALS` WHERE  `AREAID` = '" + areaId + "'");
        Internals.println((String)("[WTGPortals] Removed invalid area data " + String.valueOf(areaId)), (int)6);
    }

    public Boolean checkDbForPlayer(String playerId) {
        try {
            ResultSet result = this.portals.executeQuery("SELECT * FROM `PLAYERS` WHERE `PLAYERID` = '" + playerId + "'");
            boolean exist = result.next();
            return exist;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void initNewPlayer(Player player) {
        this.portals.execute("INSERT INTO `PLAYERS`(PLAYERID, HOMEPORTALID, PLACEDPORTALS, MAXPORTALS, DISABLED) Values ('" + player.getUID() + "','0', '0', '" + Portals.settings.maxPortals + "', '0')");
        this.loadPlayer(player);
    }

    public void loadPlayer(Player player) {
        String playerId = player.getUID();
        this.validatePlayer(player.getUID());
        try {
            ResultSet result = this.portals.executeQuery("SELECT * FROM `PLAYERS` WHERE `PLAYERID` = '" + playerId + "'");
            int disabled = result.getInt("DISABLED");
            int placedPortals = result.getInt("PLACEDPORTALS");
            int maxPortals = result.getInt("MAXPORTALS");
            long homePortalID = result.getLong("HOMEPORTALID");
            PlayerPortalMenu playerPortalMenu = new PlayerPortalMenu(this.plugin, player, placedPortals, homePortalID, maxPortals, disabled);
            player.setAttribute("PlayerPortalMenu", (Object)playerPortalMenu);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getPlacedPortals(String playerId) {
        int placedPortals = 0;
        try {
            ResultSet result = this.portals.executeQuery("SELECT * FROM `PLAYERS` WHERE `PLAYERID` = '" + playerId + "'");
            placedPortals = result.getInt("PLACEDPORTALS");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return placedPortals;
    }

    public void updateMaxPortals(Integer maxPortals, String playerId) {
        this.portals.executeUpdate("UPDATE PLAYERS SET `MAXPORTALS` = '" + maxPortals + "'where PLAYERID = '" + playerId + "'");
        Player player = Server.getPlayerByUID((String)playerId);
        if (player != null && player.hasAttribute("PlayerPortalMenu")) {
            PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
            playerPortalMenu.maxPortals = maxPortals;
            playerPortalMenu.initMenu();
        }
    }

    public void updatePlacePortals(Integer placedPortals, String playerId) {
        this.portals.executeUpdate("UPDATE PLAYERS SET `PLACEDPORTALS` = '" + placedPortals + "'where PLAYERID = '" + playerId + "'");
        Player player = Server.getPlayerByUID((String)playerId);
        if (player != null && player.hasAttribute("PlayerPortalMenu")) {
            PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
            playerPortalMenu.placedPortals = placedPortals;
            playerPortalMenu.initMenu();
        }
    }

    public void createPortal(Player player, String portalType) {
        int isAdminPortal = 0;
        if (!portalType.equalsIgnoreCase("admin")) {
            int newPlaced;
            playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
            placed = playerPortalMenu.placedPortals;
            playerPortalMenu.placedPortals = newPlaced = placed + 1;
            this.updatePlacePortals(newPlaced, player.getUID());
            playerPortalMenu.initMenu();
        } else {
            playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
            placed = playerPortalMenu.placedPortals;
            isAdminPortal = 1;
            playerPortalMenu.initMenu();
        }
        Vector3f pp = player.getPosition();
        Vector3f startPosition = new Vector3f(pp.x - 1.5f, pp.y + 3.5f, pp.z - 1.5f);
        Vector3f endPosition = new Vector3f(pp.x + 1.5f, pp.y, pp.z + 1.5f);
        Area area = new Area(startPosition, endPosition);
        area.setPriority(10);
        float xdis = Utils.MathUtils.distance((float)startPosition.x, (float)endPosition.x) / 2.0f;
        float ydis = Utils.MathUtils.distance((float)startPosition.y, (float)endPosition.y) / 2.0f;
        float zdis = Utils.MathUtils.distance((float)startPosition.z, (float)endPosition.z) / 2.0f;
        float landingx = startPosition.x + xdis;
        float landingy = startPosition.y + ydis - 3.0f;
        float landingz = startPosition.z + zdis;
        long areaId = area.getID();
        String ownerId = player.getUID();
        int isPublic = 0;
        ++this.loadedPortals;
        String name = player.getName();
        area.setName(name);
        area.setPlayerPermission(player, Portals.settings.areaOwnerPermission);
        area.setDefaultPermission(Portals.settings.defaultAreaPermission);
        Server.addArea((Area)area, (boolean)true);
        this.portals.execute("INSERT INTO `PORTALS`(AREAID, OWNERID, ISPUBLIC, LANDINGX, LANDINGY, LANDINGZ, ADMINPORTAL, DESTINATION) Values ('" + areaId + "','" + ownerId + "', '0', '" + landingx + "', '" + landingy + "', '" + landingz + "', '" + isAdminPortal + "', '0')");
        this.addPortalAtt(areaId, ownerId, isPublic, landingx, landingy, landingz, isAdminPortal);
    }

    public void addPortalAtt(Long areaId, String ownerId, int isPublic, float landingx, float landingy, float landingz, Integer isAdminPortal) {
        Area area = Server.getArea((long)areaId);
        PortalController portalController = new PortalController(this, this.plugin, areaId, ownerId, isPublic, landingx, landingy, landingz, isAdminPortal, 0L);
        Portals.portalsMain.addArea3Ds(area, portalController);
        area.setAttribute("PortalController", (Object)portalController);
    }

    public void removePortal(Area area) {
        long areaId = area.getID();
        this.portals.execute("DELETE FROM `PORTALS` WHERE  AREAID = '" + areaId + "'");
        Server.removeArea((Area)area);
    }

    public void updateHomePortal(String playerID, Long areaID) {
        this.portals.executeUpdate("UPDATE PLAYERS SET `HOMEPORTALID` = '" + areaID + "' WHERE PLAYERID = '" + playerID + "'");
    }

    public void updateIsPublic(Long areaId, int isPublic) {
        if (isPublic == 0) {
            --this.publicPortals;
        }
        if (isPublic == 1) {
            ++this.publicPortals;
        }
        this.portals.executeUpdate("UPDATE PORTALS SET `ISPUBLIC` = '" + isPublic + "' WHERE AREAID = '" + areaId + "'");
    }

    public void updateDestination(Long areaId, Long destinationId) {
        this.portals.executeUpdate("UPDATE PORTALS SET `DESTINATION` = '" + destinationId + "' WHERE AREAID = '" + areaId + "'");
    }

    public void updateDisabled(String playerID, Integer disabled) {
        this.portals.executeUpdate("UPDATE PLAYERS SET `DISABLED` = '" + disabled + "' WHERE PLAYERID = '" + playerID + "'");
        Player player = Server.getPlayerByUID((String)playerID);
        if (player != null) {
            PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)player.getAttribute("PlayerPortalMenu");
            playerPortalMenu.disabled = disabled;
        }
    }
}

