/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.PortalController;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.MessageBoxButtons;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.ui.style.TextAnchor;
import net.risingworld.api.utils.Vector3f;

public class AdminPortalElement {
    private Plugin plugin;
    public long areaID;
    public String areaName;
    public String ownerId;
    public String ownerName;
    public float landingX;
    public float landingY;
    public float landingZ;
    public int isAdminPortal;
    public int isPublicPortal;
    public long destinationId;
    public PortalController portalController;
    public int prefabId;
    public String landingString;
    public UIElement portalUi;
    public UILabel nameLabel;
    public Vector3f landingPosition;
    public UILabel isAdminLabel;
    public UILabel isPublicLabel;

    public AdminPortalElement(Plugin plugin, Long areaID, String ownerId, String ownerName, float landingX, float landingY, float landingZ, int isAdminPortal, int isPublicPortal, long destinationId) {
        this.plugin = plugin;
        this.areaID = areaID;
        this.ownerId = ownerId;
        this.ownerName = ownerName;
        this.landingX = landingX;
        this.landingY = landingY;
        this.landingZ = landingZ;
        this.isAdminPortal = isAdminPortal;
        this.isPublicPortal = isPublicPortal;
        this.destinationId = destinationId;
        this.areaName = Server.getArea((long)areaID).getName();
        this.portalController = (PortalController)Server.getArea((long)areaID).getAttribute("PortalController");
        this.landingString = landingX + "," + landingY + "," + landingZ;
        this.landingPosition = new Vector3f().fromString(this.landingString);
        this.buildUi();
    }

    public void buildUi() {
        this.portalUi = new UIElement();
        this.portalUi.setBorder(1.0f);
        this.portalUi.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.portalUi.style.height.set(150.0f);
        this.portalUi.style.marginTop.set(4.0f);
        this.portalUi.style.marginLeft.set(10.0f);
        this.portalUi.style.marginRight.set(10.0f);
        this.portalUi.setBorderEdgeRadius(10.0f, false);
        this.portalUi.setVisible(true);
        this.portalUi.setClickable(true);
        this.areaNameLabel();
        this.areaIdLabel();
        this.ownerNameLabel();
        this.landingLabel();
        this.destinationLabel();
        this.isAdminLabel();
        this.isPublicLabel();
        this.removeLabel();
    }

    private void areaNameLabel() {
        this.nameLabel = new UILabel(this.areaName){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                player.showInputMessageBox("Rename Portal", "Enter A New Name)", AdminPortalElement.this.portalController.areaName, text -> {
                    if (text == null) {
                        player.showStatusMessage("Not A valid Name", 5);
                        return;
                    }
                    AdminPortalElement.this.portalController.initAreaRename((String)text);
                    AdminPortalElement.this.nameLabel.setText(text);
                });
            }
        };
        this.nameLabel.setTextAlign(TextAnchor.MiddleCenter);
        this.nameLabel.setPivot(Pivot.MiddleCenter);
        this.nameLabel.setVisible(true);
        this.nameLabel.setClickable(true);
        this.nameLabel.setFontSize(22.0f);
        this.nameLabel.setBorder(1.0f);
        this.nameLabel.setBorderEdgeRadius(12.0f, false);
        this.nameLabel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.nameLabel.setSize(50.0f, 20.0f, true);
        this.nameLabel.setPosition(26.0f, 20.0f, true);
        this.portalUi.addChild((UIElement)this.nameLabel);
    }

    private void areaIdLabel() {
        UILabel areaIdLabel = new UILabel("ID: " + String.valueOf(this.areaID));
        areaIdLabel.setTextAlign(TextAnchor.MiddleCenter);
        areaIdLabel.setPivot(Pivot.MiddleCenter);
        areaIdLabel.setVisible(true);
        areaIdLabel.setClickable(false);
        areaIdLabel.setFontSize(22.0f);
        areaIdLabel.setSize(4.5f, 20.0f, true);
        areaIdLabel.setPosition(70.0f, 20.0f, true);
        this.portalUi.addChild((UIElement)areaIdLabel);
    }

    private void ownerNameLabel() {
        UILabel ownerNameLabel = new UILabel("Owner: " + this.ownerName);
        ownerNameLabel.setTextAlign(TextAnchor.MiddleCenter);
        ownerNameLabel.setPivot(Pivot.MiddleCenter);
        ownerNameLabel.setVisible(true);
        ownerNameLabel.setClickable(false);
        ownerNameLabel.setFontSize(22.0f);
        ownerNameLabel.setSize(4.5f, 20.0f, true);
        ownerNameLabel.setPosition(26.0f, 50.0f, true);
        this.portalUi.addChild((UIElement)ownerNameLabel);
    }

    private void landingLabel() {
        UILabel landingLabel = new UILabel("GoTo"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                player.setPosition(AdminPortalElement.this.landingPosition);
            }
        };
        landingLabel.setTextAlign(TextAnchor.MiddleCenter);
        landingLabel.setPivot(Pivot.MiddleCenter);
        landingLabel.setVisible(true);
        landingLabel.setClickable(true);
        landingLabel.setFontSize(22.0f);
        landingLabel.setBorder(1.0f);
        landingLabel.setBorderEdgeRadius(12.0f, false);
        landingLabel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        landingLabel.setSize(10.0f, 20.0f, true);
        landingLabel.setPosition(92.0f, 50.0f, true);
        this.portalUi.addChild((UIElement)landingLabel);
    }

    private void destinationLabel() {
        UILabel destinationLabel = new UILabel("Dest. ID: " + String.valueOf(this.destinationId));
        destinationLabel.setTextAlign(TextAnchor.MiddleCenter);
        destinationLabel.setPivot(Pivot.MiddleCenter);
        destinationLabel.setVisible(true);
        destinationLabel.setClickable(false);
        destinationLabel.setFontSize(22.0f);
        destinationLabel.setSize(40.0f, 20.0f, true);
        destinationLabel.setPosition(65.0f, 50.0f, true);
        this.portalUi.addChild((UIElement)destinationLabel);
    }

    private void isAdminLabel() {
        this.isAdminLabel = new UILabel();
        this.isAdminLabel.setTextAlign(TextAnchor.MiddleCenter);
        this.isAdminLabel.setPivot(Pivot.MiddleCenter);
        this.isAdminLabel.setVisible(true);
        this.isAdminLabel.setClickable(true);
        this.isAdminLabel.setFontSize(22.0f);
        this.isAdminLabel.setSize(15.0f, 20.0f, true);
        this.isAdminLabel.setPosition(25.0f, 80.0f, true);
        this.portalUi.addChild((UIElement)this.isAdminLabel);
        this.updateIsAdminLabel();
    }

    public void updateIsAdminLabel() {
        if (this.isAdminPortal == 0) {
            this.isAdminLabel.setText("Player");
        } else {
            this.isAdminLabel.setText("Admin");
        }
    }

    private void isPublicLabel() {
        this.isPublicLabel = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                AdminPortalElement.this.updateIsPublicLabel();
            }
        };
        this.isPublicLabel.setTextAlign(TextAnchor.MiddleCenter);
        this.isPublicLabel.setPivot(Pivot.MiddleCenter);
        this.isPublicLabel.setVisible(true);
        this.isPublicLabel.setClickable(true);
        this.isPublicLabel.setFontSize(22.0f);
        this.isPublicLabel.setBorder(1.0f);
        this.isPublicLabel.setBorderEdgeRadius(12.0f, false);
        this.isPublicLabel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.isPublicLabel.setSize(15.0f, 20.0f, true);
        this.isPublicLabel.setPosition(50.0f, 80.0f, true);
        this.portalUi.addChild((UIElement)this.isPublicLabel);
        this.initIsPublic();
    }

    public void initIsPublic() {
        if (this.isPublicPortal == 0) {
            this.isPublicLabel.setText("Private");
            this.isPublicLabel.setFontColor(1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            this.isPublicLabel.setText("Public");
            this.isPublicLabel.setFontColor(0.0f, 1.0f, 0.0f, 1.0f);
        }
    }

    public void updateIsPublicLabel() {
        if (this.isPublicPortal == 1) {
            this.isPublicLabel.setText("Private");
            this.isPublicLabel.setFontColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.portalController.portalUI.publicLabel.setText("Private");
            this.portalController.portalUI.publicLabel.setFontColor(1.0f, 1.0f, 1.0f, 1.0f);
            this.portalController.isPublic = 0;
            this.isPublicPortal = 0;
        } else {
            this.isPublicLabel.setText("Public");
            this.isPublicLabel.setFontColor(0.0f, 1.0f, 0.0f, 1.0f);
            this.portalController.portalUI.publicLabel.setText("Public");
            this.portalController.portalUI.publicLabel.setFontColor(0.0f, 1.0f, 0.0f, 1.0f);
            this.portalController.isPublic = 1;
            this.isPublicPortal = 1;
        }
        this.portalController.updateArea3D();
    }

    private void removeLabel() {
        UILabel removeLabel = new UILabel("REMOVE"){

            public void onClick(PlayerUIElementClickEvent event) {
                Player player = event.getPlayer();
                player.showMessageBox(MessageBoxButtons.Yes_No, "Remove Portal", "Are your sure you want to REMOVE this Portal?", 15, response -> {
                    if (response == 0) {
                        this.getParent().getParent().removeChild(AdminPortalElement.this.portalUi);
                        Portals.portalsMain.removePortal(Server.getArea((long)AdminPortalElement.this.areaID));
                    }
                });
            }
        };
        removeLabel.setTextAlign(TextAnchor.MiddleCenter);
        removeLabel.setPivot(Pivot.MiddleCenter);
        removeLabel.setVisible(true);
        removeLabel.setClickable(true);
        removeLabel.setFontSize(22.0f);
        removeLabel.setBorder(1.0f);
        removeLabel.setFontColor(1.0f, 0.0f, 0.0f, 1.0f);
        removeLabel.setBorderEdgeRadius(12.0f, false);
        removeLabel.setBorderColor(1.0f, 0.0f, 0.0f, 1.0f);
        removeLabel.setSize(15.0f, 20.0f, true);
        removeLabel.setPosition(75.0f, 80.0f, true);
        this.portalUi.addChild((UIElement)removeLabel);
    }
}

