/*
 * Decompiled with CFR 0.152.
 */
package main;

import main.PlayerPortalMenu;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.MessageBoxButtons;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.ui.style.TextAnchor;

public class AdminPlayerElement {
    private Plugin plugin;
    public String playerId;
    public String playerName;
    public Long homePortalId;
    public int placedPortals;
    public int maxPortals;
    public int disabled;
    public UILabel maxLabel;
    public UILabel homeLabel;
    public UILabel disableLabel;
    public UIElement playerUi;

    public AdminPlayerElement(Plugin plugin, String playerId, String playerName, Long homePortalId, Integer placedPortals, Integer maxPortals, Integer disabled) {
        this.plugin = plugin;
        this.playerId = playerId;
        this.playerName = playerName;
        this.homePortalId = homePortalId;
        this.placedPortals = placedPortals;
        this.maxPortals = maxPortals;
        this.disabled = disabled;
        this.buildUi();
    }

    public void buildUi() {
        this.playerUi = new UIElement();
        this.playerUi.setBorder(1.0f);
        this.playerUi.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.playerUi.style.height.set(100.0f);
        this.playerUi.style.marginTop.set(4.0f);
        this.playerUi.style.marginLeft.set(10.0f);
        this.playerUi.style.marginRight.set(10.0f);
        this.playerUi.setBorderEdgeRadius(10.0f, false);
        this.playerUi.setVisible(true);
        this.playerUi.setClickable(true);
        this.nameLabel();
        this.placedLabel();
        this.maxLabel();
        this.plusLabel();
        this.minusLabel();
        this.homeLabel();
        this.disableLabel();
    }

    private void nameLabel() {
        UILabel nameLabel = new UILabel(this.playerName);
        nameLabel.setTextAlign(TextAnchor.MiddleCenter);
        nameLabel.setPivot(Pivot.MiddleCenter);
        nameLabel.setVisible(true);
        nameLabel.setClickable(false);
        nameLabel.setFontSize(22.0f);
        nameLabel.setSize(50.0f, 35.0f, true);
        nameLabel.setPosition(26.0f, 25.0f, true);
        this.playerUi.addChild((UIElement)nameLabel);
    }

    private void placedLabel() {
        UILabel placedLabel = new UILabel("Placed: " + String.valueOf(this.placedPortals));
        placedLabel.setTextAlign(TextAnchor.MiddleCenter);
        placedLabel.setPivot(Pivot.MiddleCenter);
        placedLabel.setVisible(true);
        placedLabel.setClickable(false);
        placedLabel.setFontSize(22.0f);
        placedLabel.setSize(10.0f, 35.0f, true);
        placedLabel.setPosition(10.0f, 75.0f, true);
        this.playerUi.addChild((UIElement)placedLabel);
    }

    private void maxLabel() {
        this.maxLabel = new UILabel("Max: " + String.valueOf(this.maxPortals));
        this.maxLabel.setTextAlign(TextAnchor.MiddleCenter);
        this.maxLabel.setPivot(Pivot.MiddleCenter);
        this.maxLabel.setVisible(true);
        this.maxLabel.setClickable(false);
        this.maxLabel.setFontSize(22.0f);
        this.maxLabel.setSize(10.0f, 35.0f, true);
        this.maxLabel.setPosition(30.0f, 75.0f, true);
        this.playerUi.addChild((UIElement)this.maxLabel);
    }

    private void plusLabel() {
        UILabel plusLabel = new UILabel("+"){

            public void onClick(PlayerUIElementClickEvent event) {
                ++AdminPlayerElement.this.maxPortals;
                Portals.dbHandler.updateMaxPortals(AdminPlayerElement.this.maxPortals, AdminPlayerElement.this.playerId);
                AdminPlayerElement.this.maxLabel.setText("Max: " + String.valueOf(AdminPlayerElement.this.maxPortals));
            }
        };
        plusLabel.setTextAlign(TextAnchor.MiddleCenter);
        plusLabel.setPivot(Pivot.MiddleCenter);
        plusLabel.setVisible(true);
        plusLabel.setClickable(true);
        plusLabel.setFontSize(22.0f);
        plusLabel.setBorder(1.0f);
        plusLabel.setBorderEdgeRadius(22.0f, true);
        plusLabel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        plusLabel.setSize(4.5f, 20.0f, true);
        plusLabel.setPosition(45.0f, 75.0f, true);
        this.playerUi.addChild((UIElement)plusLabel);
    }

    private void minusLabel() {
        UILabel minusLabel = new UILabel("-"){

            public void onClick(PlayerUIElementClickEvent event) {
                --AdminPlayerElement.this.maxPortals;
                Portals.dbHandler.updateMaxPortals(AdminPlayerElement.this.maxPortals, AdminPlayerElement.this.playerId);
                AdminPlayerElement.this.maxLabel.setText("Max: " + String.valueOf(AdminPlayerElement.this.maxPortals));
            }
        };
        minusLabel.setTextAlign(TextAnchor.MiddleCenter);
        minusLabel.setPivot(Pivot.MiddleCenter);
        minusLabel.setVisible(true);
        minusLabel.setClickable(true);
        minusLabel.setFontSize(22.0f);
        minusLabel.setBorder(1.0f);
        minusLabel.setBorderEdgeRadius(22.0f, true);
        minusLabel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        minusLabel.setSize(4.5f, 20.0f, true);
        minusLabel.setPosition(50.0f, 75.0f, true);
        this.playerUi.addChild((UIElement)minusLabel);
    }

    private void homeLabel() {
        this.homeLabel = new UILabel("Home: " + String.valueOf(this.homePortalId)){

            public void onClick(PlayerUIElementClickEvent event) {
                Player admin = event.getPlayer();
                admin.showMessageBox(MessageBoxButtons.Yes_No, "Reset", "Reset Player Home Portal?", 15, response -> {
                    if (response == 0) {
                        Portals.dbHandler.updateHomePortal(AdminPlayerElement.this.playerId, 0L);
                        Player playerEl = Server.getPlayerByUID((String)AdminPlayerElement.this.playerId);
                        if (playerEl != null) {
                            PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)playerEl.getAttribute("PlayerPortalMenu");
                            playerPortalMenu.homePortalId = 0L;
                            AdminPlayerElement.this.homeLabel.setText("Home: 0");
                        }
                    }
                    if (response == 1 || response == 2) {
                        admin.showStatusMessage("Place Portal Canceled", 5);
                    }
                });
            }
        };
        this.homeLabel.setTextAlign(TextAnchor.MiddleCenter);
        this.homeLabel.setPivot(Pivot.MiddleCenter);
        this.homeLabel.setVisible(true);
        this.homeLabel.setClickable(true);
        this.homeLabel.setFontSize(22.0f);
        this.homeLabel.setBorder(1.0f);
        this.homeLabel.setBorderEdgeRadius(12.0f, false);
        this.homeLabel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.homeLabel.setSize(35.0f, 35.0f, true);
        this.homeLabel.setPosition(75.0f, 25.0f, true);
        this.playerUi.addChild((UIElement)this.homeLabel);
    }

    private void disableLabel() {
        this.disableLabel = new UILabel(){

            public void onClick(PlayerUIElementClickEvent event) {
                AdminPlayerElement.this.disableClick();
            }
        };
        this.disableLabel.setTextAlign(TextAnchor.MiddleCenter);
        this.disableLabel.setPivot(Pivot.MiddleCenter);
        this.disableLabel.setVisible(true);
        this.disableLabel.setClickable(true);
        this.disableLabel.setFontSize(22.0f);
        this.disableLabel.setBorder(1.0f);
        this.disableLabel.setBorderEdgeRadius(12.0f, false);
        this.disableLabel.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.disableLabel.setSize(35.0f, 35.0f, true);
        this.disableLabel.setPosition(75.0f, 75.0f, true);
        this.playerUi.addChild((UIElement)this.disableLabel);
        this.updateDisableLabel();
    }

    public void disableClick() {
        if (this.disabled == 0) {
            this.disabled = 1;
            Portals.dbHandler.updateDisabled(this.playerId, 1);
        } else {
            this.disabled = 0;
            Portals.dbHandler.updateDisabled(this.playerId, 0);
        }
        this.updateDisableLabel();
    }

    public void updateDisableLabel() {
        if (this.disabled == 0) {
            this.disableLabel.setText("Disable");
            this.disableLabel.setFontColor(0.0f, 1.0f, 0.0f, 1.0f);
        } else {
            this.disableLabel.setText("Enable");
            this.disableLabel.setFontColor(1.0f, 0.0f, 0.0f, 1.0f);
        }
        if (Server.getPlayerByUID((String)this.playerId) != null) {
            PlayerPortalMenu playerPortalMenu = (PlayerPortalMenu)Server.getPlayerByUID((String)this.playerId).getAttribute("PlayerPortalMenu");
            playerPortalMenu.disabled = this.disabled;
        }
    }
}

