/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.util.ArrayList;
import java.util.Map;
import main.AdminPlayerElement;
import main.AdminPortalElement;
import main.Portals;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.Player;
import net.risingworld.api.ui.UIElement;
import net.risingworld.api.ui.UILabel;
import net.risingworld.api.ui.UIScrollView;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.worldelements.Area3D;
import net.risingworld.api.worldelements.GameObject;

public class AdminMenu {
    private Plugin plugin;
    public UIElement adminUI;
    private Player player;
    public UIScrollView playerScroll;
    public UIScrollView portalScroll;
    public UILabel showButton;
    public ArrayList<Area3D> allArea3Ds;

    public AdminMenu(Plugin plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.allArea3Ds = new ArrayList();
        this.createUi();
    }

    private void createUi() {
        this.adminUI = new UIElement();
        this.adminUI.setSize(90.0f, 90.0f, true);
        this.adminUI.setPosition(50.0f, 50.0f, true);
        this.adminUI.setPivot(Pivot.MiddleCenter);
        this.adminUI.setVisible(false);
        this.adminUI.style.backgroundImage.set(Portals.assets.background);
        this.adminUI.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.adminUI.setBorder(1.0f);
        this.adminUI.setBorderEdgeRadius(10.0f, false);
        this.player.addUIElement(this.adminUI);
        this.exitButton();
        this.playersScroll();
        this.portalsScroll();
        this.adminLabel();
        this.placedPortalsLabel();
        this.publicPortalsLabel();
        this.showButton();
    }

    private void adminLabel() {
        UILabel adminLabel = new UILabel("Admin Panel");
        adminLabel.setFontSize(50.0f);
        adminLabel.setPivot(Pivot.MiddleCenter);
        adminLabel.setPosition(50.0f, 5.0f, true);
        this.adminUI.addChild((UIElement)adminLabel);
    }

    private void placedPortalsLabel() {
        UILabel placedPortalsLabel = new UILabel("Total Portals: " + String.valueOf(Portals.dbHandler.loadedPortals));
        placedPortalsLabel.setFontSize(20.0f);
        placedPortalsLabel.setPivot(Pivot.MiddleCenter);
        placedPortalsLabel.setPosition(25.0f, 90.0f, true);
        this.adminUI.addChild((UIElement)placedPortalsLabel);
    }

    private void publicPortalsLabel() {
        UILabel publicPortalsLabel = new UILabel("Public Portals: " + String.valueOf(Portals.dbHandler.publicPortals));
        publicPortalsLabel.setFontSize(20.0f);
        publicPortalsLabel.setPivot(Pivot.MiddleCenter);
        publicPortalsLabel.setPosition(25.0f, 95.0f, true);
        this.adminUI.addChild((UIElement)publicPortalsLabel);
    }

    public void initAdminArea3Ds() {
        for (Area3D area3D : this.allArea3Ds) {
            this.player.removeGameObject((GameObject)area3D);
        }
        this.allArea3Ds.clear();
        this.showButton.setText("Show");
        for (Map.Entry entry : Portals.portalControllers.entrySet()) {
            Area area = (Area)entry.getKey();
            Area3D area3D = new Area3D(area);
            area3D.setAlwaysVisible(true);
            area3D.setFrameVisible(true);
            area3D.setColor(0.0f, 0.0f, 1.0f, 1.0f);
            area3D.setFrameColor(0.0f, 0.0f, 1.0f, 1.0f);
            this.allArea3Ds.add(area3D);
        }
    }

    private void showButton() {
        this.showButton = new UILabel("Show"){

            public void onClick(PlayerUIElementClickEvent event) {
                if (AdminMenu.this.showButton.getText().equalsIgnoreCase("Show")) {
                    AdminMenu.this.showButton.setText("Hide");
                    for (Area3D area3D : AdminMenu.this.allArea3Ds) {
                        AdminMenu.this.player.addGameObject((GameObject)area3D);
                    }
                } else {
                    AdminMenu.this.showButton.setText("Show");
                    for (Area3D area3D : AdminMenu.this.allArea3Ds) {
                        AdminMenu.this.player.removeGameObject((GameObject)area3D);
                    }
                }
            }
        };
        this.showButton.setPivot(Pivot.MiddleCenter);
        this.showButton.setBorderEdgeRadius(10.0f, false);
        this.showButton.setBorder(1.0f);
        this.showButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.showButton.setVisible(true);
        this.showButton.setClickable(true);
        this.showButton.setFontSize(22.0f);
        this.showButton.setSize(10.0f, 5.0f, true);
        this.showButton.setPosition(15.0f, 94.0f, true);
        this.adminUI.addChild((UIElement)this.showButton);
    }

    private void exitButton() {
        UILabel exitButton = new UILabel("Close"){

            public void onClick(PlayerUIElementClickEvent event) {
                AdminMenu.this.playerScroll.removeAllChilds();
                AdminMenu.this.portalScroll.removeAllChilds();
                AdminMenu.this.adminUI.setVisible(false);
                AdminMenu.this.player.setMouseCursorVisible(false);
            }
        };
        exitButton.setPivot(Pivot.MiddleCenter);
        exitButton.setBorderEdgeRadius(10.0f, false);
        exitButton.setBorder(1.0f);
        exitButton.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        exitButton.setVisible(true);
        exitButton.setClickable(true);
        exitButton.setFontSize(22.0f);
        exitButton.setSize(10.0f, 5.0f, true);
        exitButton.setPosition(50.0f, 94.0f, true);
        this.adminUI.addChild((UIElement)exitButton);
    }

    public void playersScroll() {
        this.playerScroll = new UIScrollView(UIScrollView.ScrollViewMode.Vertical);
        this.playerScroll.setVerticalScrollerVisibility(UIScrollView.ScrollerVisibility.Hidden);
        this.playerScroll.setPivot(Pivot.MiddleCenter);
        this.playerScroll.setSize(40.0f, 70.0f, true);
        this.playerScroll.setPosition(25.0f, 50.0f, true);
        this.playerScroll.style.paddingTop.set(1.0f);
        this.playerScroll.style.paddingBottom.set(1.0f);
        this.playerScroll.setBorder(2.0f);
        this.playerScroll.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.playerScroll.setBorderEdgeRadius(10.0f, false);
        this.playerScroll.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.75f);
        this.playerScroll.setPivot(Pivot.MiddleCenter);
        this.playerScroll.setVisible(true);
        this.adminUI.addChild((UIElement)this.playerScroll);
    }

    public void portalsScroll() {
        this.portalScroll = new UIScrollView(UIScrollView.ScrollViewMode.Vertical);
        this.portalScroll.setVerticalScrollerVisibility(UIScrollView.ScrollerVisibility.Hidden);
        this.portalScroll.setPivot(Pivot.MiddleCenter);
        this.portalScroll.setSize(40.0f, 70.0f, true);
        this.portalScroll.setPosition(75.0f, 50.0f, true);
        this.portalScroll.style.paddingTop.set(1.0f);
        this.portalScroll.style.paddingBottom.set(1.0f);
        this.portalScroll.setBorder(2.0f);
        this.portalScroll.setBorderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.portalScroll.setBorderEdgeRadius(10.0f, false);
        this.portalScroll.setBackgroundColor(0.0f, 0.0f, 0.0f, 0.75f);
        this.portalScroll.setPivot(Pivot.MiddleCenter);
        this.portalScroll.setVisible(true);
        this.adminUI.addChild((UIElement)this.portalScroll);
    }

    public void buildPlayers() {
        ArrayList<AdminPlayerElement> playerElements = Portals.dbHandler.buildAdminPlayers();
        for (AdminPlayerElement element : playerElements) {
            this.playerScroll.addChild(element.playerUi);
        }
    }

    public void buildPortals() {
        ArrayList<AdminPortalElement> portalElements = Portals.dbHandler.buildAdminPortals();
        for (AdminPortalElement element : portalElements) {
            this.portalScroll.addChild(element.portalUi);
        }
    }
}

