/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.risingworld.api.objects.visuals.PostProcessing;

public final class PluginVisualsManager {
    public static final ArrayList<Field> EffectFields = new ArrayList(64);

    public static native void updatePostProcessingProfile(PostProcessing var0, int var1, int var2, boolean var3);

    private static void initialize() {
        System.out.println("Initialize plugin visuals manager");
        try {
            Field[] fields;
            EffectFields.clear();
            int totalBytes = 4;
            Class<?> effectClass = Class.forName("net.risingworld.api.objects.visuals.Effect");
            for (Field f : fields = PostProcessing.class.getFields()) {
                int modifiers = f.getModifiers();
                if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || Modifier.isTransient(modifiers)) continue;
                Class<?> c = f.getType();
                totalBytes += 2;
                if (effectClass.isAssignableFrom(c)) {
                    Field[] innerFields;
                    for (Field fi : innerFields = c.getDeclaredFields()) {
                        int innerModifiers = fi.getModifiers();
                        if (Modifier.isStatic(innerModifiers) || Modifier.isTransient(innerModifiers)) continue;
                        Class<?> ci = fi.getType();
                        if (ci == Float.TYPE) {
                            totalBytes += 4;
                            continue;
                        }
                        if (ci == Integer.TYPE) {
                            totalBytes += 4;
                            continue;
                        }
                        if (ci == Boolean.TYPE) {
                            ++totalBytes;
                            continue;
                        }
                        if (ci == Byte.TYPE) {
                            ++totalBytes;
                            continue;
                        }
                        if (ci == Short.TYPE) {
                            totalBytes += 2;
                            continue;
                        }
                        if (ci.isEnum()) {
                            totalBytes += 4;
                            continue;
                        }
                        throw new ExceptionInInitializerError("Unknown inner field type: " + String.valueOf(ci) + " (" + fi.getName() + ")");
                    }
                }
                EffectFields.add(f);
            }
            Field bytesField = PostProcessing.class.getDeclaredField("BYTES");
            bytesField.setAccessible(true);
            bytesField.setInt(null, totalBytes);
            bytesField.setAccessible(false);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Unable to initialize visuals manager: " + e.toString());
        }
    }
}

