/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import net.jiw.unity.runtime.JavaPlugin;
import net.jiw.unity.runtime.PluginEventHandler;
import net.jiw.unity.runtime.PluginLoader;
import net.jiw.unity.runtime.PluginTimerManager;
import net.jiw.unity.runtime.database.MySQLDatabase;
import net.jiw.unity.runtime.database.SQLiteDatabase;
import net.jiw.unity.runtime.database.WorldDatabase;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.events.Event;
import net.risingworld.api.events.general.LateUpdateEvent;
import net.risingworld.api.events.general.UpdateEvent;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class PluginManager {
    public static final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
    public static final Cleaner cleaner = Cleaner.create();
    private static final ConcurrentHashMap<Integer, JavaPlugin> plugins = new ConcurrentHashMap(5, 0.9f, 1);
    public static final ConcurrentHashMap<WorldDatabase.Target, net.risingworld.api.database.WorldDatabase> cachedWorldDatabases = new ConcurrentHashMap(16, 0.9f, 1);
    public static final ConcurrentHashMap<String, Database> cachedSQLDatabases = new ConcurrentHashMap(16, 0.9f, 1);
    protected static boolean active = false;

    public static void initialize() {
        if (active) {
            PluginManager.reset();
        }
        PluginEventHandler.initialize();
        System.out.println("PluginManager initialized! JDK " + System.getProperty("java.version"));
        active = true;
    }

    protected static void addPlugin(JavaPlugin plugin) {
        System.out.println("ADD PLUGIN: " + plugin.name + " " + plugin.id);
        if (!plugins.contains(plugin)) {
            plugins.put(plugin.id, plugin);
        }
    }

    public static JavaPlugin getPlugin(int id) {
        return plugins.get(id);
    }

    public static JavaPlugin getPluginFromContext() {
        try {
            StackTraceElement[] st;
            for (StackTraceElement s : st = Thread.currentThread().getStackTrace()) {
                if (!PluginLoader.pluginClasses.containsKey(s.getClassName())) continue;
                JavaPlugin plugin = PluginLoader.pluginClasses.get(s.getClassName());
                if (plugin != null) {
                    return plugin;
                }
                System.err.println("Found plugin for " + s.getClassName() + " but it's null!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getPluginIDFromContext() {
        try {
            StackTraceElement[] st;
            for (StackTraceElement s : st = Thread.currentThread().getStackTrace()) {
                if (!PluginLoader.pluginClasses.containsKey(s.getClassName())) continue;
                JavaPlugin plugin = PluginLoader.pluginClasses.get(s.getClassName());
                if (plugin != null) {
                    return plugin.id;
                }
                System.err.println("Found plugin for " + s.getClassName() + " but it's null!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return -1;
    }

    public static Collection<JavaPlugin> getAllPlugins() {
        return plugins.values();
    }

    public static int getPluginCount() {
        return plugins.size();
    }

    protected static void removePlugin(JavaPlugin plugin) {
        System.out.println("REMOVE PLUGIN: " + plugin.id);
        plugins.remove(plugin.id);
    }

    public static boolean isActive() {
        return active;
    }

    public static native String getGameVersion();

    public static native int getGameBuild();

    public static native boolean isMainThread();

    public static native boolean isPaused();

    public static native void setPaused(boolean var0);

    public static native float getRunningTime();

    public static native int getFrame();

    public static native int getPluginErrorThreshold();

    public static native void sendAdminMessage(int var0, String var1);

    public static net.risingworld.api.database.WorldDatabase getWorldDatabase(WorldDatabase.Target target) {
        net.risingworld.api.database.WorldDatabase db = cachedWorldDatabases.get(target);
        if (db == null) {
            db = new WorldDatabase(target);
            cachedWorldDatabases.put(target, db);
        }
        return db;
    }

    public static Database getSQLiteConnection(int pluginID, String database) {
        try {
            File file;
            Class.forName("org.sqlite.JDBC").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            System.out.println("SQLite: " + database);
            if (database != null && !(file = new File(database)).exists()) {
                file.getParentFile().mkdirs();
            }
            String identifier = SQLiteDatabase.getIdentifier(pluginID, database);
            SQLiteDatabase db = new SQLiteDatabase(pluginID, database);
            cachedSQLDatabases.put(identifier, db);
            return db;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Database getMySQLConnection(int pluginID, String database, String ip, int port, String username, String password) {
        try {
            Class.forName("org.mariadb.jdbc.Driver").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            System.out.println("MySQL: " + database);
            String identifier = MySQLDatabase.getIdentifier(pluginID, database, ip, port);
            MySQLDatabase db = new MySQLDatabase(pluginID, database, ip, port, username, password);
            cachedSQLDatabases.put(identifier, db);
            return db;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static native void handleError(String var0);

    public static String sendHttpRequest(String url) {
        try {
            return InternalUtils.HttpUtils.sendPost(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String sendHttpRequest(String url, HashMap<String, String> postData) {
        try {
            return InternalUtils.HttpUtils.sendPost(url, postData);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getPluginPath(int pluginID) {
        JavaPlugin plugin = plugins.get(pluginID);
        if (plugin != null) {
            return plugin.folder.getPath();
        }
        return null;
    }

    public static Plugin getPluginByName(String name) {
        for (JavaPlugin plugin : plugins.values()) {
            if (!plugin.name.equals(name)) continue;
            return plugin.plugin;
        }
        return null;
    }

    public static String getResourceMd5(int pluginID, String resource) {
        String string;
        block8: {
            InputStream is = PluginManager.getResourceAsStream(pluginID, resource);
            try {
                string = InternalUtils.FileUtils.getMd5(is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    public static InputStream getResourceAsStream(int pluginID, String resource) throws IOException {
        JavaPlugin plugin = PluginManager.getPlugin(pluginID);
        if (plugin != null && resource != null) {
            Object obj = plugin.resources.get(resource);
            if (obj != null) {
                if (obj instanceof JarEntry && plugin.jarFile != null) {
                    return plugin.jarFile.getInputStream((JarEntry)obj);
                }
                if (obj instanceof File) {
                    return new FileInputStream((File)obj);
                }
                throw new UnsupportedOperationException("Unknown resource type: " + String.valueOf(obj) + " (" + resource + ")");
            }
            System.err.println("Cannot get resource as stream: " + resource + " (plugin: " + pluginID + ")");
        } else {
            System.err.println("Cannot get resource as stream: Plugin or path is null (" + pluginID + ", " + String.valueOf(plugin) + ", " + resource + ")");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getResource(int pluginID, String resource) {
        try (InputStream is = PluginManager.getResourceAsStream(pluginID, resource);){
            if (is == null) {
                System.err.println("Cannot get resource: Stream is null (" + pluginID + ", " + resource + ")");
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = InternalUtils.FileUtils.readBytesFromResource(is);
            return byArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDefinition(int pluginID, String definition) {
        JavaPlugin plugin = plugins.get(pluginID);
        if (plugin != null) {
            return switch (definition) {
                case "name" -> plugin.name;
                case "version" -> plugin.version;
                case "author" -> plugin.author;
                case "team" -> plugin.team;
                case "description" -> plugin.description;
                case "main" -> plugin.main;
                case "license" -> plugin.license;
                case "website" -> plugin.website;
                case "contact" -> plugin.contact;
                case "git" -> plugin.git;
                case "all" -> plugin.toString();
                default -> "N/A";
            };
        }
        return null;
    }

    public static void enqueue(int pluginID, Runnable runnable) {
        Timer t = new Timer(0.0f, 0.0f, 0, runnable);
        t.start();
    }

    public static void reset() {
        active = false;
        PluginEventHandler.reset();
        PluginTimerManager.reset();
        try {
            for (JavaPlugin jp : plugins.values()) {
                if (jp == null || jp.plugin == null) continue;
                jp.plugin.onDisable();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (Database db : cachedSQLDatabases.values()) {
                db.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        plugins.clear();
        cachedSQLDatabases.clear();
        PluginLoader.reset();
    }

    private static void onUpdate(float tpf) {
        if (!active) {
            return;
        }
        PluginTimerManager.update(tpf);
        PluginEventHandler.triggerEvent((Event)new UpdateEvent(tpf));
    }

    private static void onLateUpdate(float tpf) {
        if (!active) {
            return;
        }
        PluginEventHandler.triggerEvent((Event)new LateUpdateEvent(tpf));
    }
}

