/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.jiw.unity.Loader;
import net.jiw.unity.runtime.JavaPlugin;
import net.jiw.unity.runtime.PluginCompiler;
import net.jiw.unity.runtime.PluginEventHandler;
import net.jiw.unity.runtime.PluginManager;
import net.jiw.unity.runtime.exceptions.PluginException;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.Plugin;
import net.risingworld.api.utils.Utils;

public final class PluginLoader {
    protected static PluginClassLoader pluginClassLoader = null;
    protected static HashMap<String, JavaPlugin> pluginClasses = new HashMap(16);
    private static final int JAVA_VERSION = 64;

    protected static int loadPlugins(boolean reload) {
        File pluginFolder = new File(InternalUtils.PLUGINS_FOLDER);
        if (pluginFolder.exists() && pluginFolder.isDirectory()) {
            File[] subfolders = pluginFolder.listFiles();
            System.out.println("Load " + subfolders.length + " possible plugins from " + String.valueOf(pluginFolder));
            Arrays.sort(subfolders, PluginFileComparator.Instance);
            block0: for (File subfolder : subfolders) {
                File[] pluginFiles;
                if (!subfolder.isDirectory()) continue;
                for (File pluginFile : pluginFiles = subfolder.listFiles()) {
                    String name = pluginFile.getName();
                    if (name.endsWith(".jar")) {
                        System.out.println("LOAD PLUGIN FROM JAR: " + name);
                        if (!PluginLoader.loadPluginFromJar(pluginFile, reload)) continue;
                        continue block0;
                    }
                    if (name.equalsIgnoreCase("classinfo.txt")) {
                        System.out.println("LOAD PLUGIN FROM CLASS FILES");
                        if (!PluginLoader.loadPluginFromClasses(subfolder, pluginFile, reload)) continue;
                        continue block0;
                    }
                    if (!name.equalsIgnoreCase("projectinfo.txt")) continue;
                    System.out.println("LOAD PLUGIN FROM PROJECT");
                    if (PluginLoader.loadPluginFromProject(subfolder, pluginFile, reload)) continue block0;
                }
            }
            for (JavaPlugin plugin : PluginManager.getAllPlugins()) {
                if (plugin.plugin == null) continue;
                plugin.plugin.onEnable();
            }
        } else {
            System.err.println("Cannot find plugin folder: " + String.valueOf(pluginFolder));
        }
        return PluginManager.getPluginCount();
    }

    protected static boolean loadPluginFromClasses(File rootDir, File classinfo, boolean reload) {
        try {
            String pluginName = PluginLoader.getNameFromInfoFile(classinfo);
            if (!pluginName.isEmpty()) {
                File definitions = new File(rootDir.getPath(), "resources/plugin.yml");
                if (definitions.exists()) {
                    return PluginLoader.loadPlugin(rootDir, null, InternalUtils.FileUtils.readFromFile(definitions), reload);
                }
                throw new PluginException("No 'plugin.yml' definition file found for plugin \"" + pluginName + "\"! \nIf you are the creator of this plugin, you have to put a proper 'plugin.yml' file into the \"resources\" subfolder");
            }
            throw new PluginException("Invalid name for plugin in \"classinfo.txt\" file!");
        }
        catch (IOException io) {
            throw new PluginException("Exception occurred while loading plugin \"" + rootDir.getName() + "\"!", io);
        }
    }

    private static void clearContent(File directory, File exception) {
        if (directory.isDirectory()) {
            File[] files;
            for (File f : files = directory.listFiles()) {
                PluginLoader.clearContent(f, exception);
            }
        }
        if (!directory.equals(exception)) {
            directory.delete();
        }
    }

    private static String getNameFromInfoFile(File infoFile) {
        String[] lines;
        String pluginInfo = InternalUtils.FileUtils.readFromFile(infoFile);
        for (String line : lines = pluginInfo.split("\\r?\\n")) {
            if (line.startsWith("name: ")) {
                return line.substring(6);
            }
            if (!line.startsWith("name:")) continue;
            return line.substring(5);
        }
        return "";
    }

    private static String getPathFromInfoFile(File infoFile) {
        String[] lines;
        String pluginInfo = InternalUtils.FileUtils.readFromFile(infoFile);
        for (String line : lines = pluginInfo.split("\\r?\\n")) {
            if (line.startsWith("path: ")) {
                return line.substring(6).replaceAll("\"", "");
            }
            if (!line.startsWith("path:")) continue;
            return line.substring(5).replaceAll("\"", "");
        }
        return "";
    }

    private static String getAssetPathFromInfoFile(File infoFile) {
        String[] lines;
        String pluginInfo = InternalUtils.FileUtils.readFromFile(infoFile);
        for (String line : lines = pluginInfo.split("\\r?\\n")) {
            if (line.startsWith("assets: ")) {
                return line.substring(8);
            }
            if (!line.startsWith("assets:")) continue;
            return line.substring(7);
        }
        return "";
    }

    private static String getLibPathFromInfoFile(File infoFile) {
        String[] lines;
        String pluginInfo = InternalUtils.FileUtils.readFromFile(infoFile);
        for (String line : lines = pluginInfo.split("\\r?\\n")) {
            if (line.startsWith("lib:")) {
                return Utils.StringUtils.removeAllLeadingWhitespaces((String)line.substring(4));
            }
            if (!line.startsWith("libs:")) continue;
            return Utils.StringUtils.removeAllLeadingWhitespaces((String)line.substring(5));
        }
        return "";
    }

    private static int getLoadOrderFromInfoFile(File infoFile) {
        String[] lines;
        String pluginInfo = InternalUtils.FileUtils.readFromFile(infoFile);
        for (String line : lines = pluginInfo.split("\\r?\\n")) {
            if (line.startsWith("loadorder:")) {
                return Utils.StringUtils.parseInteger((String)Utils.StringUtils.removeAllLeadingWhitespaces((String)line.substring(10)), (int)0);
            }
            if (!line.startsWith("order:")) continue;
            return Utils.StringUtils.parseInteger((String)Utils.StringUtils.removeAllLeadingWhitespaces((String)line.substring(6)), (int)0);
        }
        return 0;
    }

    protected static boolean loadPluginFromProject(File rootDir, File projectinfo, boolean reload) {
        block9: {
            try {
                String pluginName = PluginLoader.getNameFromInfoFile(projectinfo);
                String path = PluginLoader.getPathFromInfoFile(projectinfo);
                String assetPath = PluginLoader.getAssetPathFromInfoFile(projectinfo);
                String libPaths = PluginLoader.getLibPathFromInfoFile(projectinfo);
                if (!pluginName.isEmpty() && !path.isEmpty()) {
                    File projectPath = new File(path);
                    if (projectPath.exists() && projectPath.isDirectory()) {
                        File definitions = new File(projectPath, "resources/plugin.yml");
                        if (definitions.exists()) {
                            File assets;
                            if (!assetPath.isEmpty() && (assets = new File(assetPath)).exists()) {
                                System.out.println("Copy assets...");
                                InternalUtils.FileUtils.copy(assets, rootDir);
                            }
                            if (!libPaths.isEmpty()) {
                                String[] libs;
                                System.out.println("Copy libs...");
                                for (String libPath : libs = libPaths.split(";")) {
                                    File lib = new File(libPath);
                                    if (!lib.exists()) continue;
                                    File libDir = new File(rootDir.getAbsolutePath() + "/lib");
                                    libDir.mkdir();
                                    InternalUtils.FileUtils.copy(lib, libDir);
                                }
                            }
                            if (PluginCompiler.compileProject(projectPath, rootDir)) {
                                return PluginLoader.loadPlugin(rootDir, null, InternalUtils.FileUtils.readFromFile(definitions), reload);
                            }
                            throw new PluginException("Unable to compile project: " + projectPath.getPath() + "!");
                        }
                        throw new PluginException("No 'plugin.yml' definition file found for plugin \"" + pluginName + "\"! \nMake sure you provided the correct 'path' in the \"projectinfo.txt\" file! \nPath: " + definitions.getPath());
                    }
                    break block9;
                }
                throw new PluginException("Invalid name for plugin in \"classinfo.txt\" file!");
            }
            catch (IOException io) {
                throw new PluginException("Exception occurred while loading plugin \"" + rootDir.getName() + "\"!", io);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean loadPluginFromJar(File pluginFile, boolean reload) {
        boolean bl;
        if (!pluginFile.getName().endsWith(".jar")) return false;
        JarFile jar = new JarFile(pluginFile);
        JarEntry entry = jar.getJarEntry("resources/plugin.yml");
        if (entry == null) throw new PluginException("No 'plugin.yml' definition file found for plugin \"" + pluginFile.getName() + "\"! \nIf you are the creator of this plugin, you have to put a proper 'plugin.yml' file into the \"resources\" package");
        InputStream inputStream = jar.getInputStream(entry);
        try {
            bl = PluginLoader.loadPlugin(pluginFile, jar, InternalUtils.StringUtils.readString(inputStream), reload);
            if (inputStream == null) return bl;
        }
        catch (Throwable throwable) {
            try {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException io) {
                io.printStackTrace();
                throw new PluginException("Exception occurred while loading plugin \"" + pluginFile.getName() + "\"!", io);
            }
        }
        inputStream.close();
        return bl;
    }

    private static boolean loadPlugin(File pluginFile, JarFile jarFile, String definitions, boolean reload) throws IOException {
        JavaPlugin plugin = new JavaPlugin();
        plugin.folder = jarFile != null ? pluginFile.getParentFile() : pluginFile;
        plugin.file = pluginFile;
        plugin.jarFile = jarFile;
        File libs = new File(plugin.folder, "lib");
        if (libs.exists() && libs.isDirectory()) {
            for (File lib : libs.listFiles()) {
                String name = lib.getName();
                if (!lib.isFile() || !name.endsWith(".jar") && !name.endsWith(".class")) continue;
                if (plugin.dependencies == null) {
                    plugin.dependencies = new ArrayList();
                }
                plugin.dependencies.add(lib);
            }
        }
        if (PluginLoader.parseDefinition(plugin, definitions)) {
            Class<Plugin> pluginClass;
            Class<?> mainClass;
            if (pluginClassLoader == null) {
                Loader.RuntimeClassLoader cl = Loader.classloader;
                pluginClassLoader = new PluginClassLoader(plugin.id, pluginFile, (ClassLoader)cl);
                if (cl instanceof URLClassLoader) {
                    for (URL url : ((URLClassLoader)cl).getURLs()) {
                        pluginClassLoader.addURL(url);
                    }
                }
            } else {
                pluginClassLoader.addURL(pluginFile.toURI().toURL());
            }
            if (plugin.dependencies != null) {
                for (File lib : plugin.dependencies) {
                    pluginClassLoader.addURL(lib.toURI().toURL());
                }
            }
            if (plugin.jarFile != null) {
                PluginLoader.loadResourcesFromJar(plugin);
            } else {
                PluginLoader.loadResourcesFromFiles(plugin, plugin.folder);
            }
            int javaVersion = 0;
            try (InputStream stream = null;){
                if (plugin.jarFile == null) {
                    File f = new File(String.valueOf(plugin.folder) + "/" + plugin.main.replace('.', '/') + ".class");
                    stream = new FileInputStream(f);
                    System.out.println("Trying to read main class: " + f.getAbsolutePath() + " (" + plugin.main + ")");
                } else {
                    stream = plugin.jarFile.getInputStream(plugin.jarFile.getJarEntry(plugin.main.replace('.', '/') + ".class"));
                }
                stream.skip(6L);
                int b1 = stream.read();
                int b2 = stream.read();
                javaVersion = b1 << 8 | b2 << 0;
            }
            if (javaVersion != 64) {
                throw new PluginException(plugin.name, "Plugin compiled with wrong Java version (expected 64, but found " + javaVersion + ")");
            }
            try {
                mainClass = Class.forName(plugin.main, true, pluginClassLoader);
                System.out.println("Plugin " + plugin.main + " (" + plugin.id + ") main class: " + String.valueOf(mainClass));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new PluginException(plugin.name, "Unable to find main class: \"" + plugin.main + "\"");
            }
            try {
                pluginClass = mainClass.asSubclass(Plugin.class);
                System.out.println("Plugin " + plugin.main + " class: " + String.valueOf(pluginClass));
            }
            catch (Exception e) {
                throw new PluginException(plugin.name, "Main class does not extend 'Plugin': \"" + plugin.main + "\"");
            }
            ArrayList<String> classes = plugin.jarFile != null ? PluginLoader.getClassesFromJar(plugin) : PluginLoader.getClassesFromFiles(plugin, plugin.folder);
            for (String clazz : classes) {
                if (pluginClasses.containsKey(clazz)) {
                    System.err.println("Plugin class " + clazz + " already registered for plugin " + PluginLoader.pluginClasses.get((Object)clazz).name + "!");
                }
                pluginClasses.put(clazz, plugin);
            }
            System.out.println("///////////////////////////////////////////////\n" + plugin.toString() + "\n");
            try {
                plugin.plugin = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new PluginException(plugin.name, "Cannot instantiate plugin main class: \"" + plugin.main + "\"");
            }
            try {
                Field field = Plugin.class.getDeclaredField("id");
                field.setAccessible(true);
                field.set(plugin.plugin, plugin.id);
            }
            catch (Exception e) {
                throw new PluginException(plugin.name, "Unable to assign ID (" + plugin.id + ") to plugin");
            }
            PluginManager.addPlugin(plugin);
            plugin.plugin.onLoad();
            return true;
        }
        return false;
    }

    public static boolean unloadPlugins() {
        try {
            PluginManager.reset();
            PluginManager.active = true;
            PluginEventHandler.initialize();
            if (pluginClassLoader != null) {
                pluginClassLoader.close();
            }
            pluginClassLoader = null;
            System.gc();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean reloadPlugins() {
        try {
            boolean success = PluginLoader.unloadPlugins();
            if (success) {
                PluginLoader.loadPlugins(true);
                Thread.sleep(1000L);
                PluginLoader.invokeFakeConnectAndSpawnEvents();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void reset() {
        try {
            if (pluginClassLoader != null) {
                pluginClassLoader.close();
            }
            pluginClassLoader = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pluginClasses.clear();
    }

    private static boolean parseDefinition(JavaPlugin plugin, String definition) {
        if (definition == null || definition.isEmpty()) {
            return false;
        }
        LinkedHashMap definitions = (LinkedHashMap)PluginManager.yaml.load(definition);
        for (String s : definitions.keySet()) {
            Object o = definitions.get(s);
            if ((s = s.toLowerCase()).equals("name")) {
                plugin.name = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("main")) {
                plugin.main = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("author")) {
                plugin.author = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("team")) {
                plugin.team = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("version")) {
                plugin.version = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("description")) {
                plugin.description = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("loadorder")) {
                plugin.loadorder = PluginLoader.parseInteger(o);
                continue;
            }
            if (s.equals("license")) {
                plugin.license = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("website")) {
                plugin.website = PluginLoader.parseString(o);
                continue;
            }
            if (s.equals("contact")) {
                plugin.contact = PluginLoader.parseString(o);
                continue;
            }
            if (!s.equals("git")) continue;
            plugin.git = PluginLoader.parseString(o);
        }
        return plugin.name != null && plugin.main != null && plugin.author != null;
    }

    private static int parseLoadOrder(String definition) {
        if (definition == null || definition.isEmpty()) {
            return 0;
        }
        LinkedHashMap definitions = (LinkedHashMap)PluginManager.yaml.load(definition);
        Object v = definitions.get("loadorder");
        if (v instanceof Integer) {
            Integer i = (Integer)v;
            return i;
        }
        return 0;
    }

    private static List<String> parseDependencies(String definition) {
        if (definition == null || definition.isEmpty()) {
            return null;
        }
        LinkedHashMap definitions = (LinkedHashMap)PluginManager.yaml.load(definition);
        return (List)definitions.get("dependencies");
    }

    private static String parseString(Object o) {
        if (o != null && o instanceof String) {
            String s = (String)o;
            return s;
        }
        return "";
    }

    private static int parseInteger(Object o) {
        if (o != null && o instanceof Integer) {
            Integer i = (Integer)o;
            return i;
        }
        return 0;
    }

    private static void loadResourcesFromJar(JavaPlugin plugin) {
        Enumeration<JarEntry> entries = plugin.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            Object path = entry.getName();
            if (entry.isDirectory() || ((String)path).endsWith(".class")) continue;
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            System.out.println(" - " + (String)path);
            plugin.resources.put((String)path, entry);
        }
    }

    private static void loadResourcesFromFiles(JavaPlugin plugin, File file) {
        String name;
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                PluginLoader.loadResourcesFromFiles(plugin, f);
            }
        } else if (!file.getParentFile().equals(plugin.folder) && !(name = file.getName()).endsWith(".class")) {
            String parentPath = plugin.folder.getPath();
            Object path = file.getPath().substring(parentPath.length()).replace("\\", "/");
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            System.out.println(" - FILE - " + (String)path);
            plugin.resources.put((String)path, file);
        }
    }

    private static ArrayList<String> getClassesFromJar(JavaPlugin plugin) {
        ArrayList<String> classes = new ArrayList<String>();
        Enumeration<JarEntry> entries = plugin.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            if (!path.endsWith(".class")) continue;
            path = path.substring((path = path.replace("\\", "/").replace("/", ".")).startsWith(".") ? 1 : 0, path.length() - 6);
            classes.add(path);
            System.out.println("Found class: " + path);
        }
        return classes;
    }

    private static ArrayList<String> getClassesFromFiles(JavaPlugin plugin, File file) {
        String name;
        ArrayList<String> classes = new ArrayList<String>();
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                classes.addAll(PluginLoader.getClassesFromFiles(plugin, f));
            }
        } else if (!file.getParentFile().equals(plugin.folder) && (name = file.getName()).endsWith(".class")) {
            String path;
            String parentPath = plugin.folder.getPath();
            path = path.substring((path = file.getPath().substring(parentPath.length()).replace("\\", "/").replace("/", ".")).startsWith(".") ? 1 : 0, path.length() - 6);
            classes.add(path);
            System.out.println("Found class: " + path);
        }
        return classes;
    }

    private static native void invokeFakeConnectAndSpawnEvents();

    private static class PluginFileComparator
    implements Comparator<File> {
        public static final PluginFileComparator Instance = new PluginFileComparator();

        private PluginFileComparator() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int getLoadOrder(File pluginFolder) {
            File[] pluginFiles = pluginFolder.listFiles();
            if (pluginFiles == null) return 0;
            if (pluginFiles.length == 0) {
                return 0;
            }
            File[] fileArray = pluginFiles;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File pluginFile = fileArray[n2];
                try {
                    String name = pluginFile.getName().toLowerCase();
                    if (name.endsWith(".jar")) {
                        JarFile jar = new JarFile(pluginFile);
                        JarEntry entry = jar.getJarEntry("resources/plugin.yml");
                        if (entry == null) return 0;
                        try (InputStream inputStream = jar.getInputStream(entry);){
                            String definition = InternalUtils.StringUtils.readString(inputStream);
                            int n3 = PluginLoader.parseLoadOrder(definition);
                            return n3;
                        }
                    }
                    if (name.equals("classinfo.txt")) {
                        File definitions = new File(pluginFolder.getPath(), "resources/plugin.yml");
                        if (!definitions.exists()) return 0;
                        return PluginLoader.parseLoadOrder(InternalUtils.FileUtils.readFromFile(definitions));
                    }
                    if (name.equals("projectinfo.txt")) {
                        return PluginLoader.getLoadOrderFromInfoFile(pluginFile);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            return 0;
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 == f2) {
                return 0;
            }
            if (f1 == null || !f1.isDirectory()) {
                if (f2 == null || !f2.isDirectory()) {
                    return 0;
                }
                return -1;
            }
            if (f2 == null || !f2.isDirectory()) {
                return 1;
            }
            int lo1 = this.getLoadOrder(f1);
            int lo2 = this.getLoadOrder(f2);
            return Integer.compare(lo1, lo2);
        }
    }

    public static class PluginClassLoader
    extends URLClassLoader {
        private int pluginID = -1;
        public static final String NAME = "PLUGIN_CLASS_LOADER";

        public PluginClassLoader(int pluginID, File plugin, ClassLoader parent) throws MalformedURLException {
            super(NAME, new URL[]{plugin.toURI().toURL()}, parent);
            this.pluginID = pluginID;
        }

        @Override
        protected void addURL(URL url) {
            super.addURL(url);
        }

        public String toString() {
            return NAME;
        }

        public int getPluginID() {
            return this.pluginID;
        }
    }
}

