/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.io.File;
import java.util.ArrayList;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import net.jiw.unity.Loader;
import net.jiw.unity.runtime.exceptions.PluginException;
import net.jiw.unity.runtime.utils.InternalUtils;

public final class PluginCompiler {
    public static boolean compileProject(File projectPath, File targetDir) {
        String api_path;
        String jdk_path;
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        if (Loader.EDITOR) {
            jdk_path = InternalUtils.ROOT_DIR + "/JDK";
            api_path = InternalUtils.ROOT_DIR + "/JavaProjects/PluginAPI/dist/PluginAPI.jar";
            runtime_path = InternalUtils.ROOT_DIR + "/JavaProjects/Runtime/dist/Runtime.jar";
        } else {
            jdk_path = InternalUtils.ROOT_DIR + "/Data/Java/JDK";
            api_path = InternalUtils.ROOT_DIR + "/Data/Java/PluginAPI.jar";
            runtime_path = InternalUtils.ROOT_DIR + "/Data/Java/Runtime.jar";
        }
        if (projectPath.exists() && projectPath.isDirectory()) {
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<File> miscFiles = new ArrayList<File>();
            PluginCompiler.getFiles(projectPath, files, miscFiles);
            String home = System.getProperty("java.home");
            System.out.println("JDK PATH: \"" + jdk_path + "\"");
            System.out.println("HOME PATH: \"" + home + "\"");
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new PluginException("No Java compiler was found!");
            }
            File libs = new File(targetDir, "lib");
            String sc = InternalUtils.SystemUtils.isWindowsOS() ? ";" : ":";
            Object classpath = api_path.replace("\\", "/");
            String directory = targetDir.getPath().replace("\\", "/");
            if (libs.exists() && libs.isDirectory()) {
                for (File lib : libs.listFiles()) {
                    String name = lib.getName();
                    if (!lib.isFile() || !name.endsWith(".jar") && !name.endsWith(".class")) continue;
                    if (classpath == null) {
                        classpath = ".";
                    }
                    classpath = (String)classpath + sc + lib.getAbsolutePath().replace("\\", "/");
                }
            }
            String[] fileArray = new String[files.size() + 4];
            fileArray[0] = "-d";
            fileArray[1] = directory;
            fileArray[2] = "-classpath";
            fileArray[3] = classpath;
            System.out.println("   -classpath " + fileArray[3]);
            System.out.println("   -d " + fileArray[1]);
            for (int i = 0; i < files.size(); ++i) {
                fileArray[i + 4] = files.get(i).getPath();
            }
            int result = compiler.run(null, null, null, fileArray);
            if (result == 0) {
                System.out.println("Compiler result: " + result);
            } else {
                System.err.println("Compiler result: " + result);
            }
            if (result != 0) {
                return false;
            }
            System.setProperty("java.home", home);
            if (!miscFiles.isEmpty()) {
                String projectFolder = projectPath.getPath();
                for (File f : miscFiles) {
                    try {
                        File newFile = new File(targetDir, f.getPath().substring(projectFolder.length()));
                        InternalUtils.FileUtils.copy(f, newFile);
                        System.out.println("create new file " + newFile.getPath());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return true;
        }
        return false;
    }

    private static void getFiles(File parent, ArrayList<File> javaFiles, ArrayList<File> miscFiles) {
        if (parent.isDirectory()) {
            File[] files;
            for (File f : files = parent.listFiles()) {
                PluginCompiler.getFiles(f, javaFiles, miscFiles);
            }
        } else if (parent.getName().endsWith(".java")) {
            javaFiles.add(parent);
        } else if (miscFiles != null) {
            miscFiles.add(parent);
        }
    }
}

