/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.jiw.unity.runtime.PluginManager;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.DatabaseType;

public final class MySQLDatabase
implements Database {
    private int pluginID;
    private String database;
    private String ip;
    private int port;
    private Connection connection;
    private Statement statement;

    public MySQLDatabase(int pluginID, String database, String ip, int port, String user, String password) throws SQLException {
        this.connection = DriverManager.getConnection("jdbc:mariadb://" + ip + ":" + port + "/" + database, user, password);
        this.statement = this.connection.createStatement();
        this.pluginID = pluginID;
        this.database = database;
        this.ip = ip;
        this.port = port;
    }

    public DatabaseType getType() {
        return DatabaseType.SQLite;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void execute(String sql) {
        try {
            this.statement.execute(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void executeUpdate(String sql) {
        try {
            this.statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.statement.executeQuery(sql);
    }

    public void close() {
        try {
            this.statement.close();
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        PluginManager.cachedSQLDatabases.remove(MySQLDatabase.getIdentifier(this.pluginID, this.database, this.ip, this.port));
    }

    public static String getIdentifier(int pluginID, String database, String ip, int port) {
        return pluginID + "::" + database + "::" + ip + "::" + port;
    }
}

