/*
 * Decompiled with CFR 0.152.
 */
package net.jiw.unity.runtime;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jiw.unity.runtime.exceptions.PluginException;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.assets.Asset;
import net.risingworld.api.assets.MeshAsset;
import net.risingworld.api.assets.ModelAsset;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.utils.ColorRGBA;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector2f;
import net.risingworld.api.utils.Vector2i;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.utils.Vector4f;
import net.risingworld.api.worldelements.GameObject;
import net.risingworld.api.worldelements.Prefab;

public final class PluginGameObjectManager {
    private static final Map<Integer, LinkedHashSet<ComponentKey>> componentUpdateHistory = new HashMap<Integer, LinkedHashSet<ComponentKey>>(16);
    private static final Map<Integer, Map<PrefabKey, PrefabEntry>> prefabUpdateHistory = new HashMap<Integer, Map<PrefabKey, PrefabEntry>>(16);

    public static synchronized boolean registerGameObjectForPlayer(GameObject element, int playerDbID, boolean sendPacket) {
        List childs;
        LinkedHashSet<ComponentKey> hashSet;
        boolean result = PluginGameObjectManager.registerGameObjectForPlayer(element, element.getID(), element.getParent() == null ? -1 : element.getParent().getID(), playerDbID, sendPacket);
        if (!componentUpdateHistory.isEmpty() && (hashSet = componentUpdateHistory.get(element.getID())) != null) {
            for (ComponentKey componentKey : hashSet) {
                System.out.println("Sync component method invokation " + element.getID() + ": " + componentKey.component + "." + componentKey.method);
                if (componentKey.type == ComponentKey.UpdateType.InvokeMethod) {
                    PluginGameObjectManager.invokeComponentMethod(element, element.getID(), componentKey.path, componentKey.component, componentKey.method, componentKey.isProperty, componentKey.parameters);
                    continue;
                }
                if (componentKey.type == ComponentKey.UpdateType.AddComponent) {
                    PluginGameObjectManager.addOrRemoveComponent(true, element, element.getID(), componentKey.path, componentKey.component, componentKey.isProperty);
                    continue;
                }
                if (componentKey.type == ComponentKey.UpdateType.RemoveComponent) {
                    PluginGameObjectManager.addOrRemoveComponent(false, element, element.getID(), componentKey.path, componentKey.component, componentKey.isProperty);
                    continue;
                }
                if (componentKey.type != ComponentKey.UpdateType.EnableDisableComponent) continue;
                PluginGameObjectManager.setComponentEnabled(element, element.getID(), componentKey.path, componentKey.component, componentKey.isProperty);
            }
        }
        if (!prefabUpdateHistory.isEmpty() && element instanceof Prefab) {
            System.out.println("Checking " + prefabUpdateHistory.size() + " previous prefab actions...");
            Map<PrefabKey, PrefabEntry> map = prefabUpdateHistory.get(element.getID());
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    PrefabKey key = (PrefabKey)entry.getKey();
                    PrefabEntry value = (PrefabEntry)entry.getValue();
                    System.out.println("Sync prefab action " + element.getID() + ": " + String.valueOf((Object)key.type) + ", " + key.path + ", " + key.parameter);
                    PluginGameObjectManager.updatePrefab(element, element.getID(), key.type.ordinal(), key.path, key.parameter, value.i1, value.i2, value.i3, value.i4);
                }
            }
        }
        if (element.isAttached()) {
            try {
                Method updateAttachTarget = GameObject.class.getDeclaredMethod("updateAttachTarget", new Class[0]);
                updateAttachTarget.setAccessible(true);
                updateAttachTarget.invoke((Object)element, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((childs = element.getChilds()) != null) {
            for (GameObject gameObject : childs) {
                PluginGameObjectManager.registerGameObjectForPlayer(gameObject, playerDbID, sendPacket);
            }
        }
        return result;
    }

    private static native boolean registerGameObjectForPlayer(GameObject var0, int var1, int var2, int var3, boolean var4);

    public static boolean unregisterGameObjectForPlayer(GameObject element, int playerDbID, boolean sendPacket) {
        List childs = element.getChilds();
        if (childs != null) {
            for (GameObject child : childs) {
                PluginGameObjectManager.unregisterGameObjectForPlayer(child, playerDbID, sendPacket);
            }
        }
        return PluginGameObjectManager.unregisterGameObjectForPlayer(element.getID(), playerDbID, sendPacket);
    }

    private static native boolean unregisterGameObjectForPlayer(int var0, int var1, boolean var2);

    public static void unregisterGameObjectForAllPlayers(GameObject element, boolean sendPacket) {
        List childs = element.getChilds();
        if (childs != null) {
            for (GameObject child : childs) {
                PluginGameObjectManager.unregisterGameObjectForAllPlayers(child, sendPacket);
            }
        }
        PluginGameObjectManager.unregisterGameObjectForAllPlayers(element.getID(), sendPacket);
    }

    private static native void unregisterGameObjectForAllPlayers(int var0, boolean var1);

    public static native GameObject[] getAllGameObjectsOfPlayer(int var0, boolean var1);

    public static void updateHierarchy(GameObject parent, GameObject newChild) {
        PluginGameObjectManager.updateHierarchy(parent, parent.getID(), newChild, newChild.getID());
        List childs = newChild.getChilds();
        if (childs != null) {
            for (GameObject child : childs) {
                PluginGameObjectManager.updateHierarchy(newChild, child);
            }
        }
    }

    private static native void updateHierarchy(GameObject var0, int var1, GameObject var2, int var3);

    public static native void updateTransform(GameObject var0, int var1, Vector3f var2, boolean var3, Quaternion var4, boolean var5, Vector3f var6, boolean var7, boolean var8, float var9);

    public static native void updateAttachTarget(GameObject var0, int var1, int var2, long var3);

    public static native void updateObject(GameObject var0, int var1, boolean var2);

    public static native void readPosition(GameObject var0, int var1, int var2, boolean var3, String var4, Callback<Vector3f> var5);

    public static native void readRotation(GameObject var0, int var1, int var2, boolean var3, String var4, Callback<Quaternion> var5);

    public static native void readScale(GameObject var0, int var1, int var2, boolean var3, String var4, Callback<Quaternion> var5);

    public static void clearPrefabUpdateHistory(Prefab prefab) {
        prefabUpdateHistory.remove(prefab.getID());
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter) {
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, -1, -1, -1, -1);
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, boolean boolValue) {
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, boolValue ? 1 : 0, -1, -1, -1);
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, float floatValue) {
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, Float.floatToIntBits(floatValue), -1, -1, -1);
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, int intValue) {
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, intValue, -1, -1, -1);
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, Vector2f vector) {
        if (vector == null) {
            vector = Vector2f.ZERO;
        }
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, Float.floatToIntBits(vector.x), Float.floatToIntBits(vector.y), -1, -1);
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, Vector3f vector) {
        if (vector == null) {
            vector = Vector3f.ZERO;
        }
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, Float.floatToIntBits(vector.x), Float.floatToIntBits(vector.y), Float.floatToIntBits(vector.z), -1);
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, Vector4f vector) {
        if (vector == null) {
            vector = Vector4f.ZERO;
        }
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, Float.floatToIntBits(vector.x), Float.floatToIntBits(vector.y), Float.floatToIntBits(vector.z), Float.floatToIntBits(vector.w));
    }

    public static void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, Quaternion quaternion) {
        if (quaternion == null) {
            quaternion = Quaternion.ZERO;
        }
        PluginGameObjectManager.updatePrefab(prefab, type, path, parameter, Float.floatToIntBits(quaternion.x), Float.floatToIntBits(quaternion.y), Float.floatToIntBits(quaternion.z), Float.floatToIntBits(quaternion.w));
    }

    public static synchronized void updatePrefab(Prefab prefab, PrefabUpdateType type, String path, String parameter, int i1, int i2, int i3, int i4) {
        Map<PrefabKey, PrefabEntry> map = prefabUpdateHistory.get(prefab.getID());
        if (map == null) {
            map = new HashMap<PrefabKey, PrefabEntry>(8);
            prefabUpdateHistory.put(prefab.getID(), map);
        }
        map.put(new PrefabKey(prefab.getID(), type, path, parameter), new PrefabEntry(i1, i2, i3, i4));
        PluginGameObjectManager.updatePrefab((GameObject)prefab, prefab.getID(), type.ordinal(), path, parameter, i1, i2, i3, i4);
    }

    private static native void updatePrefab(GameObject var0, int var1, int var2, String var3, String var4, int var5, int var6, int var7, int var8);

    public static synchronized void addOrRemoveComponent(boolean add, GameObject gameObject, String path, String component, boolean enabled) {
        LinkedHashSet<ComponentKey> hashSet = componentUpdateHistory.get(gameObject.getID());
        if (hashSet == null) {
            hashSet = new LinkedHashSet(8);
            componentUpdateHistory.put(gameObject.getID(), hashSet);
        }
        ComponentKey key = new ComponentKey(add ? ComponentKey.UpdateType.AddComponent : ComponentKey.UpdateType.RemoveComponent, gameObject.getID(), path, component, null, enabled, null);
        hashSet.remove(key);
        hashSet.add(key);
        PluginGameObjectManager.addOrRemoveComponent(true, gameObject, gameObject.getID(), path, component, enabled);
    }

    private static native void addOrRemoveComponent(boolean var0, GameObject var1, int var2, String var3, String var4, boolean var5);

    public static synchronized void setComponentEnabled(GameObject gameObject, String path, String component, boolean enabled) {
        LinkedHashSet<ComponentKey> hashSet = componentUpdateHistory.get(gameObject.getID());
        if (hashSet == null) {
            hashSet = new LinkedHashSet(8);
            componentUpdateHistory.put(gameObject.getID(), hashSet);
        }
        ComponentKey key = new ComponentKey(ComponentKey.UpdateType.EnableDisableComponent, gameObject.getID(), path, component, null, enabled, null);
        hashSet.remove(key);
        hashSet.add(key);
        PluginGameObjectManager.setComponentEnabled(gameObject, gameObject.getID(), path, component, enabled);
    }

    private static native void setComponentEnabled(GameObject var0, int var1, String var2, String var3, boolean var4);

    public static synchronized void invokeComponentMethod(GameObject gameObject, String path, String component, String method, boolean isProperty, Object ... parameters) {
        byte[] data = PluginGameObjectManager.serializeParameters(parameters);
        LinkedHashSet<ComponentKey> hashSet = componentUpdateHistory.get(gameObject.getID());
        if (hashSet == null) {
            hashSet = new LinkedHashSet(8);
            componentUpdateHistory.put(gameObject.getID(), hashSet);
        }
        ComponentKey key = new ComponentKey(ComponentKey.UpdateType.InvokeMethod, gameObject.getID(), path, component, method, isProperty, data);
        hashSet.remove(key);
        hashSet.add(key);
        PluginGameObjectManager.invokeComponentMethod(gameObject, gameObject.getID(), path, component, method, isProperty, data);
    }

    public static byte[] serializeParameters(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return null;
        }
        int requiredBytes = 4;
        for (Object o : parameters) {
            ++requiredBytes;
            if (o instanceof Boolean || o instanceof Byte) {
                ++requiredBytes;
                continue;
            }
            if (o instanceof Short) {
                requiredBytes += 2;
                continue;
            }
            if (o instanceof Long || o instanceof Double) {
                requiredBytes += 8;
                continue;
            }
            if (o instanceof Number) {
                requiredBytes += 4;
                continue;
            }
            if (o instanceof Vector2f || o instanceof Vector2i) {
                requiredBytes += 8;
                continue;
            }
            if (o instanceof Vector3f || o instanceof Vector3i) {
                requiredBytes += 12;
                continue;
            }
            if (o instanceof Vector4f || o instanceof Quaternion || o instanceof ColorRGBA) {
                requiredBytes += 16;
                continue;
            }
            if (o instanceof String) {
                String s = (String)o;
                requiredBytes += 2 + (s == null ? 0 : s.length() * 2);
                continue;
            }
            requiredBytes += 4;
        }
        ByteBuffer bb = ByteBuffer.allocate(requiredBytes);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putInt(parameters.length);
        for (Object o : parameters) {
            if (o instanceof Boolean) {
                bb.put((byte)1);
                bb.put((byte)((Boolean)o != false ? 1 : 0));
                continue;
            }
            if (o instanceof Byte) {
                bb.put((byte)2);
                bb.put((Byte)o);
                continue;
            }
            if (o instanceof Short) {
                bb.put((byte)3);
                bb.putShort((Short)o);
                continue;
            }
            if (o instanceof Integer) {
                bb.put((byte)4);
                bb.putInt((Integer)o);
                continue;
            }
            if (o instanceof Float) {
                bb.put((byte)5);
                bb.putFloat(((Float)o).floatValue());
                continue;
            }
            if (o instanceof Long) {
                bb.put((byte)6);
                bb.putLong((Long)o);
                continue;
            }
            if (o instanceof Double) {
                bb.put((byte)7);
                bb.putDouble((Double)o);
                continue;
            }
            if (o instanceof Vector2f) {
                bb.put((byte)8);
                InternalUtils.ByteBufferUtils.putVector2f(bb, (Vector2f)o);
                continue;
            }
            if (o instanceof Vector3f) {
                bb.put((byte)9);
                InternalUtils.ByteBufferUtils.putVector3f(bb, (Vector3f)o);
                continue;
            }
            if (o instanceof Vector4f) {
                bb.put((byte)10);
                InternalUtils.ByteBufferUtils.putVector4f(bb, (Vector4f)o);
                continue;
            }
            if (o instanceof Quaternion) {
                bb.put((byte)11);
                InternalUtils.ByteBufferUtils.putQuaternion(bb, (Quaternion)o);
                continue;
            }
            if (o instanceof ColorRGBA) {
                bb.put((byte)12);
                InternalUtils.ByteBufferUtils.putColorRGBA(bb, (ColorRGBA)o);
                continue;
            }
            if (o instanceof TextureAsset) {
                bb.put((byte)13);
                bb.putInt(((Asset)o).getHandle());
                continue;
            }
            if (o instanceof MeshAsset) {
                bb.put((byte)14);
                bb.putInt(((Asset)o).getHandle());
                continue;
            }
            if (o instanceof ModelAsset) {
                bb.put((byte)15);
                bb.putInt(((Asset)o).getHandle());
                continue;
            }
            if (o instanceof GameObject) {
                bb.put((byte)16);
                bb.putInt(((GameObject)o).getID());
                continue;
            }
            if (o instanceof String) {
                String s = (String)o;
                bb.put((byte)17);
                InternalUtils.ByteBufferUtils.putString(bb, s);
                continue;
            }
            throw new PluginException("Unsupported parameter type: " + String.valueOf(o) + " (" + String.valueOf(o == null ? "null" : o.getClass()) + ")");
        }
        return bb.array();
    }

    private static native void invokeComponentMethod(GameObject var0, int var1, String var2, String var3, String var4, boolean var5, byte[] var6);

    private static void initialize() {
        System.out.println("Initialize plugin game object manager");
        prefabUpdateHistory.clear();
        componentUpdateHistory.clear();
    }

    private static class ComponentKey
    implements Comparable<ComponentKey> {
        int gameObject;
        UpdateType type;
        String path;
        String component;
        String method;
        boolean isProperty;
        byte[] parameters;

        public ComponentKey(UpdateType updateType, int gameObject, String path, String component, String method, boolean isProperty, byte[] parameters) {
            this.type = updateType;
            this.gameObject = gameObject;
            this.path = path;
            this.component = component;
            this.method = method;
            this.isProperty = isProperty;
            this.parameters = parameters;
        }

        @Override
        public int compareTo(ComponentKey key) {
            if (this.type != key.type) {
                return Integer.compare(this.type.ordinal(), key.type.ordinal());
            }
            if (this.gameObject != key.gameObject) {
                return Integer.compare(this.gameObject, key.gameObject);
            }
            if (!Objects.equals(this.path, key.path)) {
                return Objects.compare(this.path, key.path, String.CASE_INSENSITIVE_ORDER);
            }
            if (!Objects.equals(this.component, key.component)) {
                return Objects.compare(this.component, key.component, String.CASE_INSENSITIVE_ORDER);
            }
            if (!Objects.equals(this.method, key.method)) {
                return Objects.compare(this.method, key.method, String.CASE_INSENSITIVE_ORDER);
            }
            if (this.isProperty != key.isProperty) {
                return Boolean.compare(this.isProperty, key.isProperty);
            }
            return Arrays.compare(this.parameters, key.parameters);
        }

        public boolean equals(Object o) {
            if (!(o instanceof ComponentKey)) {
                return false;
            }
            ComponentKey key = (ComponentKey)o;
            return this.type == key.type && this.gameObject == key.gameObject && Objects.equals(this.path, key.path) && Objects.equals(this.component, key.component) && Objects.equals(this.method, key.method) && this.isProperty == key.isProperty && Arrays.equals(this.parameters, key.parameters);
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + this.gameObject;
            hash = 17 * hash + Objects.hashCode((Object)this.type);
            hash = 17 * hash + Objects.hashCode(this.path);
            hash = 17 * hash + Objects.hashCode(this.component);
            hash = 17 * hash + Objects.hashCode(this.method);
            hash = 17 * hash + (this.isProperty ? 1 : 0);
            hash = 17 * hash + Arrays.hashCode(this.parameters);
            return hash;
        }

        public static enum UpdateType {
            AddComponent,
            RemoveComponent,
            EnableDisableComponent,
            InvokeMethod;

        }
    }

    private static class PrefabKey
    implements Comparable<PrefabKey> {
        int prefab;
        PrefabUpdateType type;
        String path;
        String parameter;

        public PrefabKey(int prefab, PrefabUpdateType type, String path, String parameter) {
            this.prefab = prefab;
            this.type = type;
            this.path = path;
            this.parameter = parameter;
        }

        @Override
        public int compareTo(PrefabKey key) {
            if (this.prefab != key.prefab) {
                return Integer.compare(this.prefab, key.prefab);
            }
            if (this.type.ordinal() != key.type.ordinal()) {
                return Integer.compare(this.type.ordinal(), key.type.ordinal());
            }
            if (!Objects.equals(this.path, key.path)) {
                return Objects.compare(this.path, key.path, String.CASE_INSENSITIVE_ORDER);
            }
            return Objects.compare(this.parameter, key.parameter, String.CASE_INSENSITIVE_ORDER);
        }

        public boolean equals(Object o) {
            if (!(o instanceof PrefabKey)) {
                return false;
            }
            PrefabKey key = (PrefabKey)o;
            return this.prefab == key.prefab && this.type == key.type && Objects.equals(this.path, key.path) && Objects.equals(this.parameter, key.parameter);
        }

        public int hashCode() {
            int hash = 7;
            hash = 53 * hash + Objects.hashCode(this.prefab);
            hash = 53 * hash + Objects.hashCode((Object)this.type);
            hash = 53 * hash + Objects.hashCode(this.path);
            hash = 53 * hash + Objects.hashCode(this.parameter);
            return hash;
        }
    }

    private static class PrefabEntry {
        int i1;
        int i2;
        int i3;
        int i4;

        public PrefabEntry(int i1, int i2, int i3, int i4) {
            this.i1 = i1;
            this.i2 = i2;
            this.i3 = i3;
            this.i4 = i4;
        }
    }

    public static enum PrefabUpdateType {
        Active,
        Layer,
        LocalPosition,
        LocalRotation,
        LocalScale,
        ComponentAddOrRemove,
        ComponentEnabled,
        AnimatorParameterFloat,
        AnimatorParameterInt,
        AnimatorParameterBool,
        AnimatorTrigger,
        AnimatorResetTrigger,
        AnimatorPlaybackStart,
        AnimatorPlaybackStop,
        AnimatorPlayState,
        AnimatorRebind,
        MaterialParameterFloat,
        MaterialParameterVector2,
        MaterialParameterVector3,
        MaterialParameterVector4,
        MaterialParameterTexture,
        Material,
        ClearMaterialPropertyBlock,
        VFXPlay,
        VFXStop,
        VFXPlayRate,
        VFXReinit,
        VFXPaused,
        VFXParameterFloat,
        VFXParameterInt,
        VFXParameterBool,
        VFXParameterVector2,
        VFXParameterVector3,
        VFXParameterVector4,
        VFXParameterTexture,
        RigidbodyKinematic,
        RigidbodyMass;

    }

    public static enum AttachTarget {
        None,
        Player,
        PlayerHead,
        PlayerLeftHand,
        PlayerRightHand,
        Npc,
        NpcHead,
        NpcLeftHand,
        NpcRightHand,
        Vehicle,
        Item,
        APIGameObject;

    }
}

