/*
 * Decompiled with CFR 0.152.
 */
package backpack;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.risingworld.api.Internals;
import net.risingworld.api.Plugin;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Storage;

public class Backpack
extends Plugin
implements Listener {
    public Integer slotCount;
    public String worldName;
    public Database backpackDb;

    public void onEnable() {
        try {
            this.loadSettings();
        }
        catch (IOException ex) {
            Logger.getLogger(Backpack.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.worldName = World.getName();
        this.backpackDb = this.getSQLiteConnection(this.getPath() + "/" + this.worldName + "/Backpacks.db");
        this.backpackDb.execute("CREATE TABLE IF NOT EXISTS `Backpacks` (`playerid` VARCHAR(255),`storageid` BIGINT)");
        this.registerEventListener(this);
    }

    public void onDisable() {
    }

    public void loadSettings() throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        FileInputStream bp = new FileInputStream(this.getPath() + "/Backpack.properties");
        properties.load(bp);
        this.slotCount = Integer.valueOf(properties.getProperty("slotCount"));
        if (this.slotCount > 56) {
            this.slotCount = 56;
        }
        Internals.println((String)("slot Count = " + String.valueOf(this.slotCount)), (int)9);
        ((InputStream)bp).close();
    }

    @EventMethod
    public void onCommand(PlayerCommandEvent event) throws SQLException {
        Player player = event.getPlayer();
        String[] cmd = event.getCommand().split(" ");
        if (cmd[0].equalsIgnoreCase("/Backpack")) {
            long backpackId = (Long)player.getAttribute("backpackId");
            player.showStorage(backpackId);
        }
    }

    @EventMethod
    public void connect(PlayerConnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        String playerId = player.getUID();
        ResultSet result = this.backpackDb.executeQuery("SELECT * FROM `Backpacks` WHERE `playerid` = '" + playerId + "'");
        if (result.next()) {
            long storageId = result.getLong("storageid");
            Storage storage = World.getStorage((long)storageId);
            if (storage != null) {
                player.setAttribute("backpackId", (Object)storageId);
                return;
            }
            if (storage == null) {
                this.createStorage(player, "Update");
                Internals.println((String)("A backpack was broken, creating new backpack. id: " + String.valueOf(storageId)), (int)9);
            }
            return;
        }
        if (!result.next()) {
            this.createStorage(player, "New");
        }
    }

    public void saveNew(String playerId, Long storageId) {
        this.backpackDb.execute("INSERT INTO `Backpacks`(playerid, storageid) Values ('" + playerId + "', '" + storageId + "')");
    }

    public void update(String playerId, Long storageId) {
        this.backpackDb.executeUpdate("UPDATE Backpacks SET `storageid` = '" + storageId + "' WHERE playerid = '" + playerId + "'");
    }

    public void createStorage(Player player, String type) {
        String playerId = player.getUID();
        Storage storage = World.createStorage((int)this.slotCount, (boolean)false);
        long storageId = storage.getID();
        if (type.equalsIgnoreCase("New")) {
            this.saveNew(playerId, storageId);
        }
        if (type.equalsIgnoreCase("Update")) {
            this.update(playerId, storageId);
        }
        player.setAttribute("backpackId", (Object)storageId);
    }
}

