/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.world.batch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class ConstructionPlaceBatch {
    private static final int SIZE_PER_ENTRY = 96;
    private ArrayList<Entry> entries;

    public ConstructionPlaceBatch() {
        this(32);
    }

    public ConstructionPlaceBatch(int initialCapacity) {
        this.entries = new ArrayList(initialCapacity);
    }

    public void add(int shape, int texture, float textureScale, int color, Vector3f worldPosition, Quaternion rotation, Vector3f scale, Vector3f surfaceOffset, Vector3f surfaceScale) {
        int cx = Utils.ChunkUtils.getChunkPositionX(worldPosition.x);
        int cy = Utils.ChunkUtils.getChunkPositionY(worldPosition.y);
        int cz = Utils.ChunkUtils.getChunkPositionZ(worldPosition.z);
        float posx = Utils.ChunkUtils.getRelativePositionX(worldPosition.x, cx);
        float posy = Utils.ChunkUtils.getRelativePositionY(worldPosition.y, cy);
        float posz = Utils.ChunkUtils.getRelativePositionZ(worldPosition.z, cz);
        this.entries.add(new Entry(shape, cx, cy, cz, texture, textureScale, color, new Vector3f(posx, posy, posz), rotation.copy(), scale, surfaceOffset, surfaceScale, 0));
    }

    public int count() {
        return this.entries.size();
    }

    public void clear() {
        this.entries.clear();
    }

    private byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(4 + this.entries.size() * 96);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(this.entries.size());
        int len = this.entries.size();
        for (int i = 0; i < len; ++i) {
            Entry e = this.entries.get(i);
            buffer.putInt(e.shape);
            buffer.putInt(e.cx);
            buffer.putInt(e.cy);
            buffer.putInt(e.cz);
            buffer.putInt(e.texture);
            buffer.putFloat(e.textureScale);
            buffer.putInt(e.color);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)e.pos);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)e.rot);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)e.scale);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)e.surfaceOffset);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)e.surfaceScale);
            buffer.putInt(e.flags);
        }
        return buffer.array();
    }

    record Entry(int shape, int cx, int cy, int cz, int texture, float textureScale, int color, Vector3f pos, Quaternion rot, Vector3f scale, Vector3f surfaceOffset, Vector3f surfaceScale, int flags) {
    }
}

