/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.io.Serializable;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class Quaternion
implements Serializable {
    public static final Quaternion IDENTITY = new Quaternion(0.0f, 0.0f, 0.0f, 1.0f, true);
    public static final Quaternion ZERO = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f, true);
    public float x;
    public float y;
    public float z;
    public float w;
    private boolean immutable = false;

    public Quaternion() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
    }

    public Quaternion(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    private Quaternion(float x, float y, float z, float w, boolean immutable) {
        this.immutable = immutable;
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Quaternion(Quaternion copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
        this.w = copy.w;
    }

    protected boolean isImmutable() {
        return this.immutable;
    }

    public Quaternion copy() {
        return new Quaternion(this.x, this.y, this.z, this.w);
    }

    public Quaternion set(Quaternion quaternion) {
        return this.set(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
        return this;
    }

    public Quaternion setX(float x) {
        this.x = x;
        return this;
    }

    public Quaternion setY(float y) {
        this.y = y;
        return this;
    }

    public Quaternion setZ(float z) {
        this.z = z;
        return this;
    }

    public Quaternion setW(float w) {
        this.w = w;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public float getW() {
        return this.w;
    }

    public float getPitch() {
        return InternalUtils.MathUtils.quaternionToAngle((float)this.x, (float)this.y, (float)this.z, (float)this.w, (int)0);
    }

    public float getYaw() {
        return InternalUtils.MathUtils.quaternionToAngle((float)this.x, (float)this.y, (float)this.z, (float)this.w, (int)1);
    }

    public float getRoll() {
        return InternalUtils.MathUtils.quaternionToAngle((float)this.x, (float)this.y, (float)this.z, (float)this.w, (int)2);
    }

    public Quaternion loadIdentity() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.w = 1.0f;
        return this;
    }

    public Quaternion fromAngles(float[] angles) {
        return this.fromAngles(angles[0], angles[1], angles[2]);
    }

    public Quaternion fromAngles(float pitch, float yaw, float roll) {
        InternalUtils.MathUtils.quaternionFromAngles((Quaternion)this, (float)pitch, (float)yaw, (float)roll);
        return this;
    }

    public float[] toAngles() {
        return this.toAngles(null);
    }

    public float[] toAngles(float[] storeTo) {
        return InternalUtils.MathUtils.quaternionToAngles((float)this.x, (float)this.y, (float)this.z, (float)this.w);
    }

    public float angle(Quaternion quaternion) {
        return InternalUtils.MathUtils.angleBetweenQuaternions((float)this.x, (float)this.y, (float)this.z, (float)this.w, (float)quaternion.x, (float)quaternion.y, (float)quaternion.z, (float)quaternion.w);
    }

    public Quaternion multLocal(Quaternion quaternion) {
        return this.multLocal(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    public Quaternion multLocal(float qx, float qy, float qz, float qw) {
        float nx = this.x * qw + this.y * qz - this.z * qy + this.w * qx;
        float ny = -this.x * qz + this.y * qw + this.z * qx + this.w * qy;
        float nz = this.x * qy - this.y * qx + this.z * qw + this.w * qz;
        float nw = -this.x * qx - this.y * qy - this.z * qz + this.w * qw;
        this.x = nx;
        this.y = ny;
        this.z = nz;
        this.w = nw;
        return this;
    }

    public Quaternion multLocal(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
        this.w *= scalar;
        return this;
    }

    public Vector3f multLocal(Vector3f vector) {
        if (vector.isImmutable()) {
            return this.mult(vector);
        }
        float vx = vector.x;
        float vy = vector.y;
        float vz = vector.z;
        float tmp1 = 2.0f * (vx * this.x + vy * this.y + vz * this.z);
        float tmp2 = this.w * this.w - (this.x * this.x + this.y * this.y + this.z * this.z);
        vector.set(this.x, this.y, this.z).crossLocal(vx, vy, vz).multLocal(2.0f * this.w);
        vector.addLocal(vx * tmp2, vy * tmp2, vz * tmp2);
        vector.addLocal(this.x * tmp1, this.y * tmp1, this.z * tmp1);
        return vector;
    }

    public Vector3f mult(Vector3f vector) {
        float vx = vector.x;
        float vy = vector.y;
        float vz = vector.z;
        float tmp1 = 2.0f * (vx * this.x + vy * this.y + vz * this.z);
        float tmp2 = this.w * this.w - (this.x * this.x + this.y * this.y + this.z * this.z);
        Vector3f result = new Vector3f(this.x, this.y, this.z);
        result.crossLocal(vx, vy, vz).multLocal(2.0f * this.w);
        result.addLocal(vx * tmp2, vy * tmp2, vz * tmp2);
        result.addLocal(this.x * tmp1, this.y * tmp1, this.z * tmp1);
        return result;
    }

    public Quaternion negateLocal() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Quaternion inverse() {
        float norm = this.norm();
        if (norm > 0.0f) {
            float normInv = 1.0f / norm;
            return new Quaternion(-this.x * normInv, -this.y * normInv, -this.z * normInv, this.w * normInv);
        }
        return null;
    }

    public Quaternion inverseLocal() {
        float norm = this.norm();
        if ((double)norm > 0.0) {
            float invNorm = 1.0f / norm;
            this.x *= -invNorm;
            this.y *= -invNorm;
            this.z *= -invNorm;
            this.w *= invNorm;
        }
        return this;
    }

    public Quaternion normalize() {
        float n = (float)(1.0 / Math.sqrt(this.norm()));
        return new Quaternion(this.x * n, this.y * n, this.z * n, this.w * n);
    }

    public Quaternion normalizeLocal() {
        float n = (float)(1.0 / Math.sqrt(this.norm()));
        this.x *= n;
        this.y *= n;
        this.z *= n;
        this.w *= n;
        return this;
    }

    public float dot(Quaternion quaternion) {
        return this.x * quaternion.x + this.y * quaternion.y + this.z * quaternion.z + this.w * quaternion.w;
    }

    public float norm() {
        return this.dot(this);
    }

    public Quaternion lookAt(Vector3f direction) {
        return this.lookAt(direction, Vector3f.UP);
    }

    public Quaternion lookAt(float directionx, float directiony, float directionz) {
        return this.lookAt(directionx, directiony, directionz, Vector3f.UP);
    }

    public Quaternion lookAt(Vector3f direction, Vector3f up) {
        return this.lookAt(direction.x, direction.y, direction.z, up);
    }

    private Quaternion lookAt(float dirx, float diry, float dirz, Vector3f up) {
        return InternalUtils.MathUtils.quaternionLookRotation((float)dirx, (float)diry, (float)dirz, (float)up.x, (float)up.y, (float)up.z);
    }

    public boolean isNaN() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z) || Float.isNaN(this.w);
    }

    public boolean equals(float x, float y, float z, float w) {
        return this.x == x && this.y == y && this.z == z && this.w == w;
    }

    public boolean equals(Object o) {
        if (o instanceof Quaternion) {
            Quaternion compare = (Quaternion)o;
            return this.x == compare.x && this.y == compare.y && this.z == compare.z && this.w == compare.w;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Float.floatToIntBits(this.x);
        hash = 89 * hash + Float.floatToIntBits(this.y);
        hash = 89 * hash + Float.floatToIntBits(this.z);
        hash = 89 * hash + Float.floatToIntBits(this.w);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ", " + this.w + ")";
    }

    public Quaternion fromString(String input) {
        if (input == null || input.isEmpty()) {
            return this;
        }
        this.loadIdentity();
        String[] values = input.replaceAll("[()\\[\\]\\s]+", "").split(",");
        if (values.length >= 4) {
            if (Utils.StringUtils.isNumeric(values[0])) {
                this.x = Float.parseFloat(values[0]);
            }
            if (Utils.StringUtils.isNumeric(values[1])) {
                this.y = Float.parseFloat(values[1]);
            }
            if (Utils.StringUtils.isNumeric(values[2])) {
                this.z = Float.parseFloat(values[2]);
            }
            if (Utils.StringUtils.isNumeric(values[3])) {
                this.w = Float.parseFloat(values[3]);
            }
        }
        return this;
    }
}

