/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects.world;

import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.World;
import net.risingworld.api.objects.world.ChunkPart;
import net.risingworld.api.objects.world.ConstructionElement;
import net.risingworld.api.objects.world.ObjectElement;
import net.risingworld.api.objects.world.Plant;
import net.risingworld.api.utils.Utils;

public class Chunk {
    public static final int SIZE_X = Utils.ChunkUtils.CHUNK_SIZE_X;
    public static final int SIZE_Z = Utils.ChunkUtils.CHUNK_SIZE_Z;
    static final int LOD_LAYERS = (Integer)InternalUtils.getCommon((String)"LOD_TERRAIN_LAYERS");
    final int cx;
    final int cz;

    private Chunk(int cx, int cz) {
        this.cx = cx;
        this.cz = cz;
    }

    public boolean isValid() {
        return this.isValid(this.cx, this.cz);
    }

    private native boolean isValid(int var1, int var2);

    public int getChunkPositionX() {
        return this.cx;
    }

    public int getChunkPositionZ() {
        return this.cz;
    }

    public ChunkPart getChunkPart(int cy) {
        return World.getChunkPart(this.cx, cy, this.cz);
    }

    public boolean isLoadedFromDB() {
        return this.isLoadedFromDB(this.cx, this.cz);
    }

    private native boolean isLoadedFromDB(int var1, int var2);

    public boolean containsWater() {
        return this.containsWater(this.cx, this.cz);
    }

    private native boolean containsWater(int var1, int var2);

    public float[] getLODTerrain() {
        return this.getLODTerrain(this.cx, this.cz);
    }

    private native float[] getLODTerrain(int var1, int var2);

    public byte[] getRawLODTerrain() {
        return this.getRawLODTerrain(this.cx, this.cz, false);
    }

    public byte[] getRawCompressedLODTerrain() {
        return this.getRawLODTerrain(this.cx, this.cz, true);
    }

    private native byte[] getRawLODTerrain(int var1, int var2, boolean var3);

    public float getLODSurfaceLevel(int x, int z, boolean includeWater) {
        if (x < 0 || z < 0 || x >= SIZE_X || z >= SIZE_Z) {
            throw new IndexOutOfBoundsException("Invalid x or z index (x: " + x + ", z: " + z + ")!");
        }
        return this.getLODSurfaceLevel(this.cx, this.cz, x, z, includeWater);
    }

    private native float getLODSurfaceLevel(int var1, int var2, int var3, int var4, boolean var5);

    public byte getLODSurfaceTexture(int x, int z) {
        if (x < 0 || z < 0 || x >= SIZE_X || z >= SIZE_Z) {
            throw new IndexOutOfBoundsException("Invalid x or z index (x: " + x + ", z: " + z + ")!");
        }
        return this.getLODSurfaceTexture(this.cx, this.cz, x, z);
    }

    private native byte getLODSurfaceTexture(int var1, int var2, int var3, int var4);

    public ObjectElement[] getAllObjects() {
        return this.getAllObjects(this.cx, this.cz);
    }

    private native ObjectElement[] getAllObjects(int var1, int var2);

    public ConstructionElement[] getAllConstructionElements() {
        return this.getAllConstructionElements(this.cx, this.cz);
    }

    private native ConstructionElement[] getAllConstructionElements(int var1, int var2);

    public Plant[] getAllPlants() {
        return this.getAllPlants(this.cx, this.cz);
    }

    private native Plant[] getAllPlants(int var1, int var2);

    public static int getTerrainIndex(int x, int z) {
        return x + z * SIZE_X;
    }

    public static int getRawTerrainIndex(int layer, int x, int z) {
        return layer + x * LOD_LAYERS + z * (LOD_LAYERS * (SIZE_X + 4));
    }

    public boolean equals(Object o) {
        if (o instanceof Chunk) {
            Chunk c = (Chunk)o;
            return c.cx == this.cx && c.cz == this.cz;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.cx;
        hash = 83 * hash + this.cz;
        return hash;
    }
}

