/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.world;

import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.Event;
import net.risingworld.api.utils.Vector3f;

public final class ProjectileHitEvent
extends Event
implements Cancellable {
    private ProjectileHitEvent(long pointer) {
        super(pointer);
    }

    public Vector3f getHitPosition() {
        this.CheckIsValid();
        return this.getHitPosition(this.pointer);
    }

    public Vector3f getHitNormal() {
        this.CheckIsValid();
        return this.getHitNormal(this.pointer);
    }

    public Vector3f getHitVelocity() {
        this.CheckIsValid();
        return this.getHitVelocity(this.pointer);
    }

    public Items.ProjectileDefinition getProjectileDefinition() {
        return Definitions.getProjectileDefinition(this.getProjectileID(this.pointer));
    }

    public Target getHitTarget() {
        this.CheckIsValid();
        return Target.get(this.getTarget(this.pointer));
    }

    public Object getHitObject() {
        this.CheckIsValid();
        return this.getHitObject(this.pointer);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    private native Vector3f getHitPosition(long var1);

    private native Vector3f getHitNormal(long var1);

    private native Vector3f getHitVelocity(long var1);

    private native float getTotalDistance(long var1);

    private native int getProjectileID(long var1);

    private native byte getTarget(long var1);

    private native Object getHitObject(long var1);

    public static enum Target {
        Undefined,
        Player,
        Npc,
        Corpse,
        Plant,
        Object,
        Construction,
        Item,
        Vehicle,
        Water,
        World,
        Terrain;

        private static Target[] values;

        private static Target get(int ordinal) {
            if (values == null) {
                values = Target.values();
            }
            return values[ordinal];
        }
    }
}

