/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;

public final class Vehicles {
    private Vehicles() {
    }

    public static enum Size {
        None(0),
        Tiny(1),
        SmallLight(2),
        Small(3),
        Medium(4),
        MediumLarge(5),
        Large(6),
        Huge(7);

        public final int value;
        private static Size[] values;

        private Size(int i) {
            this.value = i;
        }

        public static Size get(int value) {
            if (values == null) {
                values = Size.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Size.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public final class VehicleAssembly {
        public short id;
        public VehicleDefinition vehicle;
        public VehicleComponent component;
        public int stage;
        public int requiredstage;
        public String assetpath;
        public boolean additive;

        private VehicleAssembly(Vehicles this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            int vehicle_id = buffer.getInt();
            this.vehicle = vehicle_id == -1 ? null : Definitions.getVehicleDefinition(vehicle_id);
            int component_id = buffer.getInt();
            this.component = component_id == -1 ? null : Definitions.getVehicleComponent(component_id);
            this.stage = buffer.getInt();
            this.requiredstage = buffer.getInt();
            this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.additive = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            if (this.vehicle == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.vehicle.id);
            }
            if (this.component == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.component.id);
            }
            buffer.putInt(this.stage);
            buffer.putInt(this.requiredstage);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.additive);
        }

        private int getSize() {
            int size = 21;
            size += 2;
            if (this.assetpath != null) {
                size += this.assetpath.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeVehicleAssembly(this.serialize());
            if (this.vehicle != null && !synchronizedObjects.contains(this.vehicle)) {
                this.vehicle.synchronize(synchronizedObjects);
            }
            if (this.component != null && !synchronizedObjects.contains(this.component)) {
                this.component.synchronize(synchronizedObjects);
            }
        }
    }

    public final class VehicleComponent {
        public short id;
        public String name;
        public Component type;
        public boolean optional;
        public Items.ItemDefinition relateditem;
        public VehicleDefinition[] compatiblevehicles;

        private VehicleComponent(Vehicles this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Component.get(buffer.getInt());
            this.optional = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            int relateditem_id = buffer.getInt();
            this.relateditem = relateditem_id == -1 ? null : Definitions.getItemDefinition(relateditem_id);
            int icompatiblevehicles = buffer.getInt();
            if (icompatiblevehicles == -1) {
                this.compatiblevehicles = null;
            } else if (icompatiblevehicles >= 0) {
                this.compatiblevehicles = new VehicleDefinition[icompatiblevehicles];
                for (int i = 0; i < icompatiblevehicles; ++i) {
                    int compatiblevehicles_id = buffer.getInt();
                    this.compatiblevehicles[i] = compatiblevehicles_id == -1 ? null : Definitions.getVehicleDefinition(compatiblevehicles_id);
                }
            }
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.optional);
            if (this.relateditem == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.relateditem.id);
            }
            if (this.compatiblevehicles == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.compatiblevehicles.length);
                for (int i = 0; i < this.compatiblevehicles.length; ++i) {
                    if (this.compatiblevehicles[i] == null) {
                        buffer.putInt(-1);
                        continue;
                    }
                    buffer.putInt(this.compatiblevehicles[i].id);
                }
            }
        }

        private int getSize() {
            int size = 13;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 4;
            if (this.compatiblevehicles != null) {
                size += this.compatiblevehicles.length * 4;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeVehicleComponent(this.serialize());
            if (this.relateditem != null && !synchronizedObjects.contains(this.relateditem)) {
                this.relateditem.synchronize(synchronizedObjects);
            }
            if (this.compatiblevehicles != null) {
                for (int i = 0; i < this.compatiblevehicles.length; ++i) {
                    VehicleDefinition obj = this.compatiblevehicles[i];
                    if (obj == null || synchronizedObjects.contains(obj)) continue;
                    obj.synchronize(synchronizedObjects);
                }
            }
        }
    }

    public final class VehicleDefinition {
        public short id;
        public String name;
        public Type type;
        public Category category;
        public Size extent;
        public Material material;
        public short strength;
        public short wreckstrength;
        public int seats;
        public Hand driverhand;
        public boolean hasengine;
        public boolean requiresfuel;
        public float fuelconsumption;
        public int gears;
        public boolean hasreversegear;
        public boolean hasneutralgear;
        public boolean canswim;
        public float mincolorrange;
        public float maxcolorrange;
        public String assetpath;
        public String wreckassetpath;
        public String debrisassetpath;
        public String wreckdebrisassetpath;
        public Component[] requiredcomponents;
        public int constructionstages;

        private VehicleDefinition(Vehicles this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Type.get(buffer.getInt());
            this.category = Category.get(buffer.getInt());
            this.extent = Size.get(buffer.getInt());
            this.material = Material.get(buffer.getInt());
            this.strength = buffer.getShort();
            this.wreckstrength = buffer.getShort();
            this.seats = buffer.getInt();
            this.driverhand = Hand.get(buffer.getInt());
            this.hasengine = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.requiresfuel = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.fuelconsumption = buffer.getFloat();
            this.gears = buffer.getInt();
            this.hasreversegear = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.hasneutralgear = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.canswim = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.mincolorrange = buffer.getFloat();
            this.maxcolorrange = buffer.getFloat();
            this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.wreckassetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.debrisassetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.wreckdebrisassetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            int irequiredcomponents = buffer.getInt();
            if (irequiredcomponents == -1) {
                this.requiredcomponents = null;
            } else if (irequiredcomponents >= 0) {
                this.requiredcomponents = new Component[irequiredcomponents];
                for (int i = 0; i < irequiredcomponents; ++i) {
                    this.requiredcomponents[i] = Component.get(buffer.getInt());
                }
            }
            this.constructionstages = buffer.getInt();
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            if (this.category == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.category.value);
            if (this.extent == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.extent.value);
            if (this.material == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.material.value);
            buffer.putShort(this.strength);
            buffer.putShort(this.wreckstrength);
            buffer.putInt(this.seats);
            if (this.driverhand == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.driverhand.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hasengine);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.requiresfuel);
            buffer.putFloat(this.fuelconsumption);
            buffer.putInt(this.gears);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hasreversegear);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hasneutralgear);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.canswim);
            buffer.putFloat(this.mincolorrange);
            buffer.putFloat(this.maxcolorrange);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.wreckassetpath);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.debrisassetpath);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.wreckdebrisassetpath);
            if (this.requiredcomponents == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.requiredcomponents.length);
                for (int i = 0; i < this.requiredcomponents.length; ++i) {
                    if (this.requiredcomponents[i] == null) {
                        throw new IllegalArgumentException("Enumeration must not be null!");
                    }
                    buffer.putInt(this.requiredcomponents[i].value);
                }
            }
            buffer.putInt(this.constructionstages);
        }

        private int getSize() {
            int size = 57;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 2;
            if (this.assetpath != null) {
                size += this.assetpath.length() * 2;
            }
            size += 2;
            if (this.wreckassetpath != null) {
                size += this.wreckassetpath.length() * 2;
            }
            size += 2;
            if (this.debrisassetpath != null) {
                size += this.debrisassetpath.length() * 2;
            }
            size += 2;
            if (this.wreckdebrisassetpath != null) {
                size += this.wreckdebrisassetpath.length() * 2;
            }
            size += 4;
            if (this.requiredcomponents != null) {
                size += this.requiredcomponents.length * 4;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeVehicleDefinition(this.serialize());
        }
    }

    public static enum Material {
        Null(0),
        Wood(1),
        Metal(2),
        Glass(3),
        Fabric(4),
        FabricRough(5),
        Leather(6),
        Plastic(7),
        Paper(8),
        Misc(9);

        public final int value;
        private static Material[] values;

        private Material(int i) {
            this.value = i;
        }

        public static Material get(int value) {
            if (values == null) {
                values = Material.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Material.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Hand {
        None(0),
        Left(1),
        Right(2),
        Both(3);

        public final int value;
        private static Hand[] values;

        private Hand(int i) {
            this.value = i;
        }

        public static Hand get(int value) {
            if (values == null) {
                values = Hand.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Hand.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Stage {
        Ready(0),
        Building(1),
        Wrecked(2);

        public final int value;
        private static Stage[] values;

        private Stage(int i) {
            this.value = i;
        }

        public static Stage get(int value) {
            if (values == null) {
                values = Stage.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Stage.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Transmission {
        None(0),
        Manual(1),
        Automatic(2);

        public final int value;
        private static Transmission[] values;

        private Transmission(int i) {
            this.value = i;
        }

        public static Transmission get(int value) {
            if (values == null) {
                values = Transmission.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Transmission.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Component {
        Undefined(0),
        BodyI(1),
        BodyII(2),
        BodyIII(3),
        BodyIV(4),
        BodyV(5),
        BodyVI(6),
        BodyVII(7),
        BodyVIII(8),
        BodyIX(9),
        BodyX(10),
        Paddle(11),
        Sail(12),
        Engine(13),
        Transmission(14),
        Light(15),
        Storage(16);

        public final int value;
        private static Component[] values;

        private Component(int i) {
            this.value = i;
        }

        public static Component get(int value) {
            if (values == null) {
                values = Component.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Component.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Category {
        Rowboat(0),
        Sailboat(1),
        Motorboat(2);

        public final int value;
        private static Category[] values;

        private Category(int i) {
            this.value = i;
        }

        public static Category get(int value) {
            if (values == null) {
                values = Category.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Category.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Type {
        Undefined(0),
        Boat(1),
        Train(2),
        Car(3);

        public final int value;
        private static Type[] values;

        private Type(int i) {
            this.value = i;
        }

        public static Type get(int value) {
            if (values == null) {
                values = Type.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Type.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

