/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.DefinitionMethod;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public final class Objects {
    private Objects() {
    }

    public static enum StorageType {
        Undefined(0),
        Inventory(1),
        Chest(2),
        Vehicle(3),
        Npc(4),
        API(5);

        public final int value;
        private static StorageType[] values;

        private StorageType(int i) {
            this.value = i;
        }

        public static StorageType get(int value) {
            if (values == null) {
                values = StorageType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (StorageType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Axis {
        None(0),
        X(4),
        Y(2),
        Z(1),
        XY(6),
        XZ(5),
        YZ(3),
        XYZ(7);

        public final int value;
        private static Axis[] values;

        private Axis(int i) {
            this.value = i;
        }

        public static Axis get(int value) {
            if (values == null) {
                values = Axis.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Axis.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Size {
        None(0),
        Tiny(1),
        SmallLight(2),
        Small(3),
        Medium(4),
        MediumLarge(5),
        Large(6),
        Huge(7);

        public final int value;
        private static Size[] values;

        private Size(int i) {
            this.value = i;
        }

        public static Size get(int value) {
            if (values == null) {
                values = Size.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Size.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public final class StorageDefinition {
        public byte id;
        public String name;
        public StorageType type;
        public int slots;

        private StorageDefinition(Objects this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (byte)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = StorageType.get(buffer.getInt());
            this.slots = buffer.getInt();
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            buffer.putInt(this.slots);
        }

        private int getSize() {
            int size = 12;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeStorageDefinition(this.serialize());
        }
    }

    public final class ObjectInfoDefinition {
        public byte id;
        public String name;
        public Type type;
        public Items.ItemInfoType processingtype;
        public boolean showitems;
        public boolean requiresfuel;
        public int fuelconsumption;
        public int maxfuellevel;
        public int primarystatus;
        public int secondarystatus;
        public boolean alwaysactive;
        public boolean requiresupdateloop;

        private ObjectInfoDefinition(Objects this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (byte)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Type.get(buffer.getInt());
            this.processingtype = Items.ItemInfoType.get(buffer.getInt());
            this.showitems = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.requiresfuel = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.fuelconsumption = buffer.getInt();
            this.maxfuellevel = buffer.getInt();
            this.primarystatus = buffer.getInt();
            this.secondarystatus = buffer.getInt();
            this.alwaysactive = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.requiresupdateloop = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            if (this.processingtype == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.processingtype.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.showitems);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.requiresfuel);
            buffer.putInt(this.fuelconsumption);
            buffer.putInt(this.maxfuellevel);
            buffer.putInt(this.primarystatus);
            buffer.putInt(this.secondarystatus);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.alwaysactive);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.requiresupdateloop);
        }

        private int getSize() {
            int size = 32;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeObjectInfoDefinition(this.serialize());
        }
    }

    public final class ObjectDefinition {
        public short id;
        public String name;
        public Type type;
        public int variations;
        public short strength;
        public String relateditem;
        public Size extent;
        public Material material;
        public String hitsound;
        public String breaksound;
        public String placesound;
        public float placetime;
        public boolean placeableunderwater;
        public boolean selectable;
        public boolean pickupable;
        public boolean iscraftingstation;
        public byte defaultstatus;
        public byte maxstatus;
        public boolean paintable;
        public float mincolorrange;
        public float maxcolorrange;
        public int defaultcolor;
        public Axis invertibleaxes;
        public Vector3f minscale;
        public Vector3f maxscale;
        public Axis scaleaxisx;
        public Axis scaleaxisy;
        public Axis scaleaxisz;
        public Vector3f resizefactor;
        public boolean isplacetarget;
        public boolean freeplacement;
        public boolean placeanywhere;
        public Quaternion rotationoffset;
        public String selectorhelper;
        public Vector3f selectorhelperoffset;
        public Quaternion selectorhelperrotation;
        public float selectorhelperscale;
        public boolean ignorebounds;
        public Vector3f boundscale;
        public float adapttonormal;
        public Pedestal pedestal;
        public String pivotasset;
        public PivotSnapping pivotsnapping;
        public Vector3f renderoffset;
        public Vector3f rendertransform;
        public Quaternion renderrotation;
        public float renderlightintensity;
        public float renderscale;
        public Variant[] variants;

        private ObjectDefinition(Objects this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Type.get(buffer.getInt());
            this.variations = buffer.getInt();
            this.strength = buffer.getShort();
            this.relateditem = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.extent = Size.get(buffer.getInt());
            this.material = Material.get(buffer.getInt());
            this.hitsound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.breaksound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.placesound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.placetime = buffer.getFloat();
            this.placeableunderwater = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.selectable = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.pickupable = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.iscraftingstation = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.defaultstatus = buffer.get();
            this.maxstatus = buffer.get();
            this.paintable = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.mincolorrange = buffer.getFloat();
            this.maxcolorrange = buffer.getFloat();
            this.defaultcolor = buffer.getInt();
            this.invertibleaxes = Axis.get(buffer.getInt());
            this.minscale = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.maxscale = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.scaleaxisx = Axis.get(buffer.getInt());
            this.scaleaxisy = Axis.get(buffer.getInt());
            this.scaleaxisz = Axis.get(buffer.getInt());
            this.resizefactor = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.isplacetarget = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.freeplacement = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.placeanywhere = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.rotationoffset = InternalUtils.ByteBufferUtils.getQuaternion((ByteBuffer)buffer);
            this.selectorhelper = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.selectorhelperoffset = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.selectorhelperrotation = InternalUtils.ByteBufferUtils.getQuaternion((ByteBuffer)buffer);
            this.selectorhelperscale = buffer.getFloat();
            this.ignorebounds = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.boundscale = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.adapttonormal = buffer.getFloat();
            this.pedestal = Pedestal.get(buffer.getInt());
            this.pivotasset = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.pivotsnapping = PivotSnapping.get(buffer.getInt());
            this.renderoffset = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.rendertransform = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.renderrotation = InternalUtils.ByteBufferUtils.getQuaternion((ByteBuffer)buffer);
            this.renderlightintensity = buffer.getFloat();
            this.renderscale = buffer.getFloat();
            int ivariants = buffer.getInt();
            if (ivariants == -1) {
                this.variants = null;
            } else if (ivariants >= 0) {
                this.variants = new Variant[ivariants];
                for (int i = 0; i < ivariants; ++i) {
                    this.variants[i] = new Variant(this);
                    this.variants[i].deserialize(buffer);
                }
            }
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            buffer.putInt(this.variations);
            buffer.putShort(this.strength);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.relateditem);
            if (this.extent == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.extent.value);
            if (this.material == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.material.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.hitsound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.breaksound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.placesound);
            buffer.putFloat(this.placetime);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.placeableunderwater);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.selectable);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.pickupable);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.iscraftingstation);
            buffer.put(this.defaultstatus);
            buffer.put(this.maxstatus);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.paintable);
            buffer.putFloat(this.mincolorrange);
            buffer.putFloat(this.maxcolorrange);
            buffer.putInt(this.defaultcolor);
            if (this.invertibleaxes == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.invertibleaxes.value);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.minscale);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.maxscale);
            if (this.scaleaxisx == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.scaleaxisx.value);
            if (this.scaleaxisy == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.scaleaxisy.value);
            if (this.scaleaxisz == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.scaleaxisz.value);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.resizefactor);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.isplacetarget);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.freeplacement);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.placeanywhere);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)this.rotationoffset);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.selectorhelper);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.selectorhelperoffset);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)this.selectorhelperrotation);
            buffer.putFloat(this.selectorhelperscale);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.ignorebounds);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.boundscale);
            buffer.putFloat(this.adapttonormal);
            if (this.pedestal == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.pedestal.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.pivotasset);
            if (this.pivotsnapping == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.pivotsnapping.value);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.renderoffset);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.rendertransform);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)this.renderrotation);
            buffer.putFloat(this.renderlightintensity);
            buffer.putFloat(this.renderscale);
            if (this.variants == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.variants.length);
                for (int i = 0; i < this.variants.length; ++i) {
                    this.variants[i].serialize(buffer);
                }
            }
        }

        private int getSize() {
            int size = 221;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 2;
            if (this.relateditem != null) {
                size += this.relateditem.length() * 2;
            }
            size += 2;
            if (this.hitsound != null) {
                size += this.hitsound.length() * 2;
            }
            size += 2;
            if (this.breaksound != null) {
                size += this.breaksound.length() * 2;
            }
            size += 2;
            if (this.placesound != null) {
                size += this.placesound.length() * 2;
            }
            size += 2;
            if (this.selectorhelper != null) {
                size += this.selectorhelper.length() * 2;
            }
            size += 2;
            if (this.pivotasset != null) {
                size += this.pivotasset.length() * 2;
            }
            size += 4;
            if (this.variants != null) {
                for (int i = 0; i < this.variants.length; ++i) {
                    size += this.variants[i].getSize();
                }
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeObjectDefinition(this.serialize());
        }

        @DefinitionMethod
        public Variant getVariant(int variant) {
            return this.variants[Utils.MathUtils.clamp(0, this.variants.length - 1, variant)];
        }

        @DefinitionMethod
        public TextureAsset getIcon(int variant) {
            return TextureAsset.loadFromGame("#ITEM#" + this.name + "_" + variant);
        }

        public final class Variant {
            public ObjectDefinition objectDef;
            public int variant;
            public String name;
            public String assetpath;
            public String debris;

            private Variant(ObjectDefinition this$1) {
            }

            private void deserialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int objectDef_id = buffer.getInt();
                this.objectDef = objectDef_id == -1 ? null : Definitions.getObjectDefinition(objectDef_id);
                this.variant = buffer.getInt();
                this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.debris = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            }

            private ByteBuffer serialize() {
                ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
                this.serialize(buffer);
                return buffer;
            }

            private void serialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                if (this.objectDef == null) {
                    buffer.putInt(-1);
                } else {
                    buffer.putInt(this.objectDef.id);
                }
                buffer.putInt(this.variant);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.debris);
            }

            private int getSize() {
                int size = 8;
                size += 2;
                if (this.name != null) {
                    size += this.name.length() * 2;
                }
                size += 2;
                if (this.assetpath != null) {
                    size += this.assetpath.length() * 2;
                }
                size += 2;
                if (this.debris != null) {
                    size += this.debris.length() * 2;
                }
                return size;
            }
        }
    }

    public static enum SelectorHelperMode {
        Default(0),
        KeepSize(1),
        ResizeProportionalX(2),
        ResizeProportionalY(3),
        ResizeProportionalZ(4);

        public final int value;
        private static SelectorHelperMode[] values;

        private SelectorHelperMode(int i) {
            this.value = i;
        }

        public static SelectorHelperMode get(int value) {
            if (values == null) {
                values = SelectorHelperMode.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (SelectorHelperMode.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum PivotSnapping {
        None(0),
        Other(1),
        Self(2),
        SameType(4),
        PlaceTargets(8),
        Constructions(16),
        AllObjects(15),
        All(255);

        public final int value;
        private static PivotSnapping[] values;

        private PivotSnapping(int i) {
            this.value = i;
        }

        public static PivotSnapping get(int value) {
            if (values == null) {
                values = PivotSnapping.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (PivotSnapping.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Pedestal {
        All(-1),
        Ground(0),
        Ceiling(1),
        Walls(2);

        public final int value;
        private static Pedestal[] values;

        private Pedestal(int i) {
            this.value = i;
        }

        public static Pedestal get(int value) {
            if (values == null) {
                values = Pedestal.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Pedestal.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Material {
        Null(0),
        Wood(1),
        Metal(2),
        Stone(3),
        Glass(4),
        Fruit(5),
        Plant(6),
        Grass(7),
        Fabric(8),
        FabricRough(9),
        Leather(10),
        Plastic(11),
        Paper(12),
        Bone(13),
        Misc(14);

        public final int value;
        private static Material[] values;

        private Material(int i) {
            this.value = i;
        }

        public static Material get(int value) {
            if (values == null) {
                values = Material.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Material.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Type {
        None(0),
        Default(1),
        Workbench(2),
        Furnace(3),
        Grill(4),
        Oven(5),
        TanningRack(6),
        DryingRack(7),
        PaperPress(8),
        JuicePress(9),
        SpinningWheel(10),
        Grinder(11),
        Grindstone(12),
        Storage(13),
        MusicPlayer(14),
        Piano(15),
        Door(16),
        Sign(17),
        Bed(18),
        Seating(19),
        Ladder(20),
        Torch(21),
        Lamp(22),
        Campfire(23),
        Fire(24),
        Clock(25),
        Trashcan(26),
        Scaffolding(27),
        ShootingTarget(28),
        Poster(29),
        Technical(30),
        API(31);

        public final int value;
        private static Type[] values;

        private Type(int i) {
            this.value = i;
        }

        public static Type get(int value) {
            if (values == null) {
                values = Type.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Type.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

