/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import java.io.Serializable;

public class Vector2f
implements Serializable {
    public static final Vector2f ZERO = new Vector2f(0.0f, 0.0f, true);
    public static final Vector2f ONE = new Vector2f(1.0f, 1.0f, true);
    public float x;
    public float y;
    private boolean immutable = false;

    public Vector2f() {
        this.y = 0.0f;
        this.x = 0.0f;
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(Vector2f copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    private Vector2f(float x, float y, boolean immutable) {
        this.immutable = immutable;
        this.x = x;
        this.y = y;
    }

    protected boolean isImmutable() {
        return this.immutable;
    }

    public Vector2f copy() {
        return new Vector2f(this.x, this.y);
    }

    public Vector2f set(Vector2f vector) {
        return this.set(vector.x, vector.y);
    }

    public Vector2f set(float x, float y) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x = x;
        this.y = y;
        return this;
    }

    public Vector2f setX(float x) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x = x;
        return this;
    }

    public Vector2f setY(float y) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.y = y;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float dot(Vector2f other) {
        return this.dot(other.x, other.y);
    }

    public float dot(float x, float y) {
        return this.x * x + this.y * y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distance(Vector2f other) {
        return (float)Math.sqrt(this.distanceSquared(other.x, other.y));
    }

    public float distance(float x, float y) {
        return (float)Math.sqrt(this.distanceSquared(x, y));
    }

    public float distanceSquared(Vector2f other) {
        return this.distanceSquared(other.x, other.y);
    }

    public float distanceSquared(float x, float y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return (float)(dx * dx + dy * dy);
    }

    public Vector2f addLocal(Vector2f other) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x += other.x;
        this.y += other.y;
        return this;
    }

    public Vector2f addLocal(float addX, float addY) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x += addX;
        this.y += addY;
        return this;
    }

    public Vector2f subtractLocal(Vector2f other) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public Vector2f subtractLocal(float subtractX, float subtractY) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x -= subtractX;
        this.y -= subtractY;
        return this;
    }

    public Vector2f multLocal(float scalar) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x *= scalar;
        this.y *= scalar;
        return this;
    }

    public Vector2f multLocal(Vector2f other) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x *= other.x;
        this.y *= other.y;
        return this;
    }

    public Vector2f multLocal(float multX, float multY) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x *= multX;
        this.y *= multY;
        return this;
    }

    public Vector2f divideLocal(float scalar) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        float s = 1.0f / scalar;
        this.x *= s;
        this.y *= s;
        return this;
    }

    public Vector2f divideLocal(Vector2f other) {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x /= other.x;
        this.y /= other.y;
        return this;
    }

    public Vector2f negateLocal() {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Vector2f normalizeLocal() {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        float l = this.length();
        this.x /= l;
        this.y /= l;
        return this;
    }

    public float angleBetween(Vector2f other) {
        float dot = this.dot(other);
        return (float)Math.acos(dot) * 57.295776f;
    }

    public Vector2f zero() {
        if (this.immutable) {
            throw new IllegalStateException("Do not modify immutable vectors!");
        }
        this.y = 0.0f;
        this.x = 0.0f;
        return this;
    }

    public boolean isUnitVector() {
        float len = this.length();
        return len >= 0.99f && len <= 1.01f;
    }

    public boolean isOrthogonal(Vector2f other) {
        return this.isOrthogonal(other.x, other.y);
    }

    public boolean isOrthogonal(float x, float y) {
        float dot = this.dot(x, y);
        return dot >= 0.99f && dot <= 1.01f;
    }

    public boolean equals(Object o) {
        if (o instanceof Vector2f) {
            Vector2f v = (Vector2f)o;
            return this.equals(v.x, v.y);
        }
        return false;
    }

    public boolean equals(float x, float y) {
        return this.x == x && this.y == y;
    }

    public int hashCode() {
        int hash = 3;
        hash = 47 * hash + Float.floatToIntBits(this.x);
        hash = 47 * hash + Float.floatToIntBits(this.y);
        return hash;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

