/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.utils;

import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;

public final class RaycastResult {
    private final Vector3f collisionPoint;
    private final Vector3f collisionNormal;
    private final float distance;
    private final int layer;
    private final int instanceID;
    private final int triangleIndex;
    private final boolean isTrigger;
    private long hitObjectID;
    private Vector3f hitObjectPosition;
    private Vector3i hitObjectChunkPosition;

    private RaycastResult(int layer, float distance, Vector3f collisionPoint, Vector3f collisionNormal, int instanceID, int triangleIndex, boolean isTrigger, long hitObjectID, Vector3f hitObjectPosition, Vector3i hitObjectChunkPosition) {
        this.layer = layer;
        this.distance = distance;
        this.collisionPoint = collisionPoint;
        this.collisionNormal = collisionNormal;
        this.instanceID = instanceID;
        this.triangleIndex = triangleIndex;
        this.isTrigger = isTrigger;
        this.hitObjectID = hitObjectID;
        this.hitObjectPosition = hitObjectPosition;
        this.hitObjectChunkPosition = hitObjectChunkPosition;
    }

    public boolean hasCollision() {
        return this.collisionPoint != null;
    }

    public float getDistance() {
        return this.distance;
    }

    public int getLayer() {
        return this.layer;
    }

    public Vector3f getCollisionPoint() {
        return this.collisionPoint;
    }

    public Vector3f getCollisionNormal() {
        return this.collisionNormal;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public boolean isTrigger() {
        return this.isTrigger;
    }

    public int getTriangleIndex() {
        return this.triangleIndex;
    }

    public long getObjectGlobalID() {
        return this.hitObjectID;
    }

    public Vector3f getObjectPosition() {
        return this.hitObjectPosition;
    }

    public Vector3i getObjectChunkPosition() {
        return this.hitObjectChunkPosition;
    }

    public String toString() {
        if (this.collisionPoint == null) {
            return "N/A";
        }
        return "(Layer: " + this.layer + ", Point: " + String.valueOf(this.collisionPoint) + " (dist: " + this.distance + "), Normal: " + String.valueOf(this.collisionNormal) + ")";
    }
}

