/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects;

import java.util.concurrent.ConcurrentHashMap;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.objects.MetaObject;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class WorldItem {
    final long handle;
    ConcurrentHashMap<String, Object> attributes = null;

    private WorldItem(long handle) {
        this.handle = handle;
    }

    public long getGlobalID() {
        return this.handle;
    }

    public boolean isValid() {
        return this.isValid(this.handle);
    }

    private native boolean isValid(long var1);

    public Items.ItemDefinition getDefinition() {
        short typeID = this.getTypeID();
        return Definitions.getItemDefinition(this.getTypeID());
    }

    public String getName() {
        return this.getName(this.handle);
    }

    private native String getName(long var1);

    public short getTypeID() {
        return this.getTypeID(this.handle);
    }

    private native short getTypeID(long var1);

    public int getVariant() {
        return this.getVariant(this.handle);
    }

    private native int getVariant(long var1);

    public long getCreationDate() {
        return this.getCreationDate(this.handle);
    }

    private native long getCreationDate(long var1);

    public int getStack() {
        return this.getStack(this.handle);
    }

    private native int getStack(long var1);

    public int getMaxStackSize() {
        return this.getMaxStackSize(this.handle);
    }

    private native int getMaxStackSize(long var1);

    public float getValue() {
        return this.getValue(this.handle);
    }

    private native float getValue(long var1);

    public short getStatus() {
        return this.getStatus(this.handle);
    }

    private native short getStatus(long var1);

    public void setStatus(short status) {
        this.setStatus(this.handle, status);
    }

    private native void setStatus(long var1, short var3);

    public Items.Modifier getModifier() {
        return Items.Modifier.get(this.getModifier(this.handle));
    }

    private native int getModifier(long var1);

    public int getDurability() {
        return this.getDurability(this.handle);
    }

    private native int getDurability(long var1);

    public Player getRelatedPlayer() {
        return this.getRelatedPlayer(this.handle);
    }

    private native Player getRelatedPlayer(long var1);

    public WorldItemType getWorldItemType() {
        return WorldItemType.get(this.getWorldItemType(this.handle));
    }

    private native int getWorldItemType(long var1);

    public void setWorldItemType(WorldItemType type) {
        this.setWorldItemType(this.handle, type.ordinal());
    }

    private native void setWorldItemType(long var1, int var3);

    public MetaObject getRelatedMetaObject() {
        return this.getRelatedMetaObject(this.handle);
    }

    private native MetaObject getRelatedMetaObject(long var1);

    public Items.ItemInfo getInfoDefinition() {
        MetaObject metaObject = this.getRelatedMetaObject(this.handle);
        if (metaObject != null) {
            Objects.ObjectInfoDefinition infoDef = metaObject.getObjectInfoDefinition();
            return Definitions.getItemInfo(this.getDefinition(), infoDef.processingtype);
        }
        return null;
    }

    public float getProgress() {
        return this.getProgress(this.handle);
    }

    private native float getProgress(long var1);

    public void setProgress(float progress) {
        this.setProgress(this.handle, progress);
    }

    private native void setProgress(long var1, float var3);

    public void setDespawnTimer(float despawnTime) {
        this.setDespawnTimer(this.handle, despawnTime);
    }

    private native void setDespawnTimer(long var1, float var3);

    public void destroy(boolean silent) {
        this.destroy(this.handle, silent);
    }

    private native void destroy(long var1, boolean var3);

    public Vector3f getPosition() {
        return this.getPosition(this.handle);
    }

    private native Vector3f getPosition(long var1);

    public void setPosition(Vector3f position) {
        this.setPosition(position.x, position.y, position.z);
    }

    public void setPosition(float x, float y, float z) {
        this.setPosition(this.handle, x, y, z);
    }

    private native void setPosition(long var1, float var3, float var4, float var5);

    public Quaternion getRotation() {
        return this.getRotation(this.handle);
    }

    private native Quaternion getRotation(long var1);

    public void setRotation(Quaternion rotation) {
        this.setRotation(this.handle, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    private native void setRotation(long var1, float var3, float var4, float var5, float var6);

    public void setPositionAndRotation(Vector3f position, Quaternion rotation) {
        this.setPositionAndRotation(this.handle, position.x, position.y, position.z, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    private native void setPositionAndRotation(long var1, float var3, float var4, float var5, float var6, float var7, float var8, float var9);

    public void applyPhysicalImpulse(Vector3f impulse) {
        this.applyPhysicalImpulse(this.handle, 0.0f, 0.0f, 0.0f, impulse.x, impulse.y, impulse.z);
    }

    public void applyPhysicalImpulse(Vector3f offset, Vector3f impulse) {
        this.applyPhysicalImpulse(this.handle, 0.0f, 0.0f, 0.0f, impulse.x, impulse.y, impulse.z);
    }

    private native void applyPhysicalImpulse(long var1, float var3, float var4, float var5, float var6, float var7, float var8);

    public static enum WorldItemType {
        Default,
        Static,
        PersistentStatic,
        PersistentDynamic,
        Attached,
        MetaObject;

        private static WorldItemType[] values;

        public static WorldItemType get(int ordinal) {
            if (values == null) {
                values = WorldItemType.values();
            }
            return values[ordinal];
        }
    }
}

