/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.DefinitionMethod;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Objects;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public final class Items {
    private Items() {
    }

    public static enum Size {
        None(0),
        Tiny(1),
        SmallLight(2),
        Small(3),
        Medium(4),
        MediumLarge(5),
        Large(6),
        Huge(7);

        public final int value;
        private static Size[] values;

        private Size(int i) {
            this.value = i;
        }

        public static Size get(int value) {
            if (values == null) {
                values = Size.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Size.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public final class ProjectileDefinition {
        public byte id;
        public String name;
        public ProjectileType type;
        public String itemname;
        public String assetpath;
        public int damage;
        public int damagenpcs;
        public int damageobjects;
        public int damageconstructions;
        public float penetration;
        public float maxrange;
        public float accurancy;
        public float speed;
        public float lifetime;
        public float mass;
        public boolean explosive;
        public float explosionrange;
        public int splashdamage;
        public float impactimpulse;
        public float tipoffset;
        public String sound;
        public int hitsound;
        public int cracksound;
        public boolean visible;
        public boolean ricochet;
        public boolean destroyonhit;
        public boolean pickupable;

        private ProjectileDefinition(Items this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (byte)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = ProjectileType.get(buffer.getInt());
            this.itemname = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.damage = buffer.getInt();
            this.damagenpcs = buffer.getInt();
            this.damageobjects = buffer.getInt();
            this.damageconstructions = buffer.getInt();
            this.penetration = buffer.getFloat();
            this.maxrange = buffer.getFloat();
            this.accurancy = buffer.getFloat();
            this.speed = buffer.getFloat();
            this.lifetime = buffer.getFloat();
            this.mass = buffer.getFloat();
            this.explosive = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.explosionrange = buffer.getFloat();
            this.splashdamage = buffer.getInt();
            this.impactimpulse = buffer.getFloat();
            this.tipoffset = buffer.getFloat();
            this.sound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.hitsound = buffer.getInt();
            this.cracksound = buffer.getInt();
            this.visible = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.ricochet = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.destroyonhit = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.pickupable = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.itemname);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
            buffer.putInt(this.damage);
            buffer.putInt(this.damagenpcs);
            buffer.putInt(this.damageobjects);
            buffer.putInt(this.damageconstructions);
            buffer.putFloat(this.penetration);
            buffer.putFloat(this.maxrange);
            buffer.putFloat(this.accurancy);
            buffer.putFloat(this.speed);
            buffer.putFloat(this.lifetime);
            buffer.putFloat(this.mass);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.explosive);
            buffer.putFloat(this.explosionrange);
            buffer.putInt(this.splashdamage);
            buffer.putFloat(this.impactimpulse);
            buffer.putFloat(this.tipoffset);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.sound);
            buffer.putInt(this.hitsound);
            buffer.putInt(this.cracksound);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.visible);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.ricochet);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.destroyonhit);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.pickupable);
        }

        private int getSize() {
            int size = 77;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 2;
            if (this.itemname != null) {
                size += this.itemname.length() * 2;
            }
            size += 2;
            if (this.assetpath != null) {
                size += this.assetpath.length() * 2;
            }
            size += 2;
            if (this.sound != null) {
                size += this.sound.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeProjectileDefinition(this.serialize());
        }
    }

    public final class WeaponDefinition {
        public String itemname;
        public int itemstatus;
        public WeaponType type;
        public ProjectileDefinition[] projectiles;
        public boolean explosive;
        public int softsplashdamage;
        public int hardsplashdamage;
        public int innersplashradius;
        public int outersplashradius;
        public int explosionshockrange;
        public String explosionpath;
        public boolean scarenpcs;
        public float audiblerange;
        public boolean hasmuzzleflash;

        private WeaponDefinition(Items this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.itemname = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.itemstatus = buffer.getInt();
            this.type = WeaponType.get(buffer.getInt());
            int iprojectiles = buffer.getInt();
            if (iprojectiles == -1) {
                this.projectiles = null;
            } else if (iprojectiles >= 0) {
                this.projectiles = new ProjectileDefinition[iprojectiles];
                for (int i = 0; i < iprojectiles; ++i) {
                    int projectiles_id = buffer.getInt();
                    this.projectiles[i] = projectiles_id == -1 ? null : Definitions.getProjectileDefinition(projectiles_id);
                }
            }
            this.explosive = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.softsplashdamage = buffer.getInt();
            this.hardsplashdamage = buffer.getInt();
            this.innersplashradius = buffer.getInt();
            this.outersplashradius = buffer.getInt();
            this.explosionshockrange = buffer.getInt();
            this.explosionpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.scarenpcs = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.audiblerange = buffer.getFloat();
            this.hasmuzzleflash = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.itemname);
            buffer.putInt(this.itemstatus);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            if (this.projectiles == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.projectiles.length);
                for (int i = 0; i < this.projectiles.length; ++i) {
                    if (this.projectiles[i] == null) {
                        buffer.putInt(-1);
                        continue;
                    }
                    buffer.putInt(this.projectiles[i].id);
                }
            }
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.explosive);
            buffer.putInt(this.softsplashdamage);
            buffer.putInt(this.hardsplashdamage);
            buffer.putInt(this.innersplashradius);
            buffer.putInt(this.outersplashradius);
            buffer.putInt(this.explosionshockrange);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.explosionpath);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.scarenpcs);
            buffer.putFloat(this.audiblerange);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hasmuzzleflash);
        }

        private int getSize() {
            int size = 35;
            size += 2;
            if (this.itemname != null) {
                size += this.itemname.length() * 2;
            }
            size += 4;
            if (this.projectiles != null) {
                size += this.projectiles.length * 4;
            }
            size += 2;
            if (this.explosionpath != null) {
                size += this.explosionpath.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeWeaponDefinition(this.serialize());
            if (this.projectiles != null) {
                for (int i = 0; i < this.projectiles.length; ++i) {
                    ProjectileDefinition obj = this.projectiles[i];
                    if (obj == null || synchronizedObjects.contains(obj)) continue;
                    obj.synchronize(synchronizedObjects);
                }
            }
        }
    }

    public final class ConsumeInfo {
        public short id;
        public String itemname;
        public ConsumeType type;
        public int healthrestore;
        public int hungerrestore;
        public int thirstrestore;
        public boolean healbones;
        public boolean stopbleeding;
        public boolean remove;
        public float valuechange;
        public String disease;
        public float diseasechance;

        private ConsumeInfo(Items this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.itemname = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = ConsumeType.get(buffer.getInt());
            this.healthrestore = buffer.getInt();
            this.hungerrestore = buffer.getInt();
            this.thirstrestore = buffer.getInt();
            this.healbones = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.stopbleeding = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.remove = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.valuechange = buffer.getFloat();
            this.disease = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.diseasechance = buffer.getFloat();
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.itemname);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            buffer.putInt(this.healthrestore);
            buffer.putInt(this.hungerrestore);
            buffer.putInt(this.thirstrestore);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.healbones);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.stopbleeding);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.remove);
            buffer.putFloat(this.valuechange);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.disease);
            buffer.putFloat(this.diseasechance);
        }

        private int getSize() {
            int size = 31;
            size += 2;
            if (this.itemname != null) {
                size += this.itemname.length() * 2;
            }
            size += 2;
            if (this.disease != null) {
                size += this.disease.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeConsumeInfo(this.serialize());
        }
    }

    public final class ItemInfo {
        public short id;
        public ItemDefinition itemdefinition;
        public ItemInfoType type;
        public int itemtexture;
        public Objects.Type requiredobjecttype;
        public int duration;
        public int refuelvalue;
        public ItemDefinition targetitem;
        public int targettexture;
        public short targetstatus;
        public float targetvalue;
        public int targetcount;
        public Vector3f targetitemoffset;
        public Quaternion targetitemrotation;
        public float valuedecrement;
        public short finalstatus;

        private ItemInfo(Items this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            int itemdefinition_id = buffer.getInt();
            this.itemdefinition = itemdefinition_id == -1 ? null : Definitions.getItemDefinition(itemdefinition_id);
            this.type = ItemInfoType.get(buffer.getInt());
            this.itemtexture = buffer.getInt();
            this.requiredobjecttype = Objects.Type.get(buffer.getInt());
            this.duration = buffer.getInt();
            this.refuelvalue = buffer.getInt();
            int targetitem_id = buffer.getInt();
            this.targetitem = targetitem_id == -1 ? null : Definitions.getItemDefinition(targetitem_id);
            this.targettexture = buffer.getInt();
            this.targetstatus = buffer.getShort();
            this.targetvalue = buffer.getFloat();
            this.targetcount = buffer.getInt();
            this.targetitemoffset = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.targetitemrotation = InternalUtils.ByteBufferUtils.getQuaternion((ByteBuffer)buffer);
            this.valuedecrement = buffer.getFloat();
            this.finalstatus = buffer.getShort();
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            if (this.itemdefinition == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.itemdefinition.id);
            }
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            buffer.putInt(this.itemtexture);
            if (this.requiredobjecttype == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.requiredobjecttype.value);
            buffer.putInt(this.duration);
            buffer.putInt(this.refuelvalue);
            if (this.targetitem == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.targetitem.id);
            }
            buffer.putInt(this.targettexture);
            buffer.putShort(this.targetstatus);
            buffer.putFloat(this.targetvalue);
            buffer.putInt(this.targetcount);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.targetitemoffset);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)this.targetitemrotation);
            buffer.putFloat(this.valuedecrement);
            buffer.putShort(this.finalstatus);
        }

        private int getSize() {
            int size = 80;
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeItemInfo(this.serialize());
            if (this.itemdefinition != null && !synchronizedObjects.contains(this.itemdefinition)) {
                this.itemdefinition.synchronize(synchronizedObjects);
            }
            if (this.targetitem != null && !synchronizedObjects.contains(this.targetitem)) {
                this.targetitem.synchronize(synchronizedObjects);
            }
        }
    }

    public final class PickingInfo {
        public short id;
        public String itemname;
        public float range;
        public PickingType type;
        public short damagestone;
        public short damagewood;
        public short damagesoil;
        public short damagetrees;
        public short damageplants;
        public short damagemetal;
        public short damageglass;
        public short damageobjects;
        public short damagenpcs;
        public short damageplayers;
        public int toolsound;
        public float blockingfactor;
        public float hitnpccooldown;
        public short staminaprimary;
        public short staminasecondary;
        public boolean hitair;
        public float primarylength;
        public float secondarylength;

        private PickingInfo(Items this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.itemname = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.range = buffer.getFloat();
            this.type = PickingType.get(buffer.getInt());
            this.damagestone = buffer.getShort();
            this.damagewood = buffer.getShort();
            this.damagesoil = buffer.getShort();
            this.damagetrees = buffer.getShort();
            this.damageplants = buffer.getShort();
            this.damagemetal = buffer.getShort();
            this.damageglass = buffer.getShort();
            this.damageobjects = buffer.getShort();
            this.damagenpcs = buffer.getShort();
            this.damageplayers = buffer.getShort();
            this.toolsound = buffer.getInt();
            this.blockingfactor = buffer.getFloat();
            this.hitnpccooldown = buffer.getFloat();
            this.staminaprimary = buffer.getShort();
            this.staminasecondary = buffer.getShort();
            this.hitair = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.primarylength = buffer.getFloat();
            this.secondarylength = buffer.getFloat();
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.itemname);
            buffer.putFloat(this.range);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            buffer.putShort(this.damagestone);
            buffer.putShort(this.damagewood);
            buffer.putShort(this.damagesoil);
            buffer.putShort(this.damagetrees);
            buffer.putShort(this.damageplants);
            buffer.putShort(this.damagemetal);
            buffer.putShort(this.damageglass);
            buffer.putShort(this.damageobjects);
            buffer.putShort(this.damagenpcs);
            buffer.putShort(this.damageplayers);
            buffer.putInt(this.toolsound);
            buffer.putFloat(this.blockingfactor);
            buffer.putFloat(this.hitnpccooldown);
            buffer.putShort(this.staminaprimary);
            buffer.putShort(this.staminasecondary);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hitair);
            buffer.putFloat(this.primarylength);
            buffer.putFloat(this.secondarylength);
        }

        private int getSize() {
            int size = 57;
            size += 2;
            if (this.itemname != null) {
                size += this.itemname.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizePickingInfo(this.serialize());
        }
    }

    public final class ItemDefinition {
        public short id;
        public String name;
        public Type type;
        public Group group;
        public int variations;
        public Hand hand;
        public boolean twohanded;
        public Vector3f position;
        public Quaternion rotation;
        public String pickupitem;
        public float size;
        public short stacksize;
        public Material material;
        public Size extent;
        public Category category;
        public short strength;
        public int durability;
        public float mass;
        public float debrismass;
        public boolean collisionlistener;
        public boolean canhavemodifier;
        public boolean canswim;
        public boolean npcaction;
        public short defaultstatus;
        public float defaultvalue;
        public short maxstatus;
        public float maxvalue;
        public boolean resetstatusondrop;
        public boolean resetvalueondrop;
        public boolean destroyondrop;
        public boolean customicon;
        public Vector3f renderoffset;
        public Quaternion renderrotation;
        public String hitsound;
        public String breaksound;
        public String collidesound;
        public String placesound;
        public PickingInfo pickingInfo;
        public ItemInfo[] itemInfos;
        public ConsumeInfo consumeInfo;
        public Variant[] variants;

        private ItemDefinition(Items this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.type = Type.get(buffer.getInt());
            this.group = Group.get(buffer.getInt());
            this.variations = buffer.getInt();
            this.hand = Hand.get(buffer.getInt());
            this.twohanded = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.position = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.rotation = InternalUtils.ByteBufferUtils.getQuaternion((ByteBuffer)buffer);
            this.pickupitem = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.size = buffer.getFloat();
            this.stacksize = buffer.getShort();
            this.material = Material.get(buffer.getInt());
            this.extent = Size.get(buffer.getInt());
            this.category = Category.get(buffer.getInt());
            this.strength = buffer.getShort();
            this.durability = buffer.getInt();
            this.mass = buffer.getFloat();
            this.debrismass = buffer.getFloat();
            this.collisionlistener = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.canhavemodifier = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.canswim = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.npcaction = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.defaultstatus = buffer.getShort();
            this.defaultvalue = buffer.getFloat();
            this.maxstatus = buffer.getShort();
            this.maxvalue = buffer.getFloat();
            this.resetstatusondrop = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.resetvalueondrop = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.destroyondrop = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.customicon = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.renderoffset = InternalUtils.ByteBufferUtils.getVector3f((ByteBuffer)buffer);
            this.renderrotation = InternalUtils.ByteBufferUtils.getQuaternion((ByteBuffer)buffer);
            this.hitsound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.breaksound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.collidesound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.placesound = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            int pickingInfo_id = buffer.getInt();
            this.pickingInfo = pickingInfo_id == -1 ? null : Definitions.getPickingInfo(pickingInfo_id);
            int iitemInfos = buffer.getInt();
            if (iitemInfos == -1) {
                this.itemInfos = null;
            } else if (iitemInfos >= 0) {
                this.itemInfos = new ItemInfo[iitemInfos];
                for (int i = 0; i < iitemInfos; ++i) {
                    int itemInfos_id = buffer.getInt();
                    this.itemInfos[i] = itemInfos_id == -1 ? null : Definitions.getItemInfo(itemInfos_id);
                }
            }
            int consumeInfo_id = buffer.getInt();
            this.consumeInfo = consumeInfo_id == -1 ? null : Definitions.getConsumeInfo(consumeInfo_id);
            int ivariants = buffer.getInt();
            if (ivariants == -1) {
                this.variants = null;
            } else if (ivariants >= 0) {
                this.variants = new Variant[ivariants];
                for (int i = 0; i < ivariants; ++i) {
                    this.variants[i] = new Variant(this);
                    this.variants[i].deserialize(buffer);
                }
            }
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            int i;
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.type == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.type.value);
            if (this.group == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.group.value);
            buffer.putInt(this.variations);
            if (this.hand == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.hand.value);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.twohanded);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.position);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)this.rotation);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.pickupitem);
            buffer.putFloat(this.size);
            buffer.putShort(this.stacksize);
            if (this.material == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.material.value);
            if (this.extent == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.extent.value);
            if (this.category == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.category.value);
            buffer.putShort(this.strength);
            buffer.putInt(this.durability);
            buffer.putFloat(this.mass);
            buffer.putFloat(this.debrismass);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.collisionlistener);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.canhavemodifier);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.canswim);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.npcaction);
            buffer.putShort(this.defaultstatus);
            buffer.putFloat(this.defaultvalue);
            buffer.putShort(this.maxstatus);
            buffer.putFloat(this.maxvalue);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.resetstatusondrop);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.resetvalueondrop);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.destroyondrop);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.customicon);
            InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.renderoffset);
            InternalUtils.ByteBufferUtils.putQuaternion((ByteBuffer)buffer, (Quaternion)this.renderrotation);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.hitsound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.breaksound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.collidesound);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.placesound);
            if (this.pickingInfo == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.pickingInfo.id);
            }
            if (this.itemInfos == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.itemInfos.length);
                for (i = 0; i < this.itemInfos.length; ++i) {
                    if (this.itemInfos[i] == null) {
                        buffer.putInt(-1);
                        continue;
                    }
                    buffer.putInt(this.itemInfos[i].id);
                }
            }
            if (this.consumeInfo == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.consumeInfo.id);
            }
            if (this.variants == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.variants.length);
                for (i = 0; i < this.variants.length; ++i) {
                    this.variants[i].serialize(buffer);
                }
            }
        }

        private int getSize() {
            int size = 137;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 2;
            if (this.pickupitem != null) {
                size += this.pickupitem.length() * 2;
            }
            size += 2;
            if (this.hitsound != null) {
                size += this.hitsound.length() * 2;
            }
            size += 2;
            if (this.breaksound != null) {
                size += this.breaksound.length() * 2;
            }
            size += 2;
            if (this.collidesound != null) {
                size += this.collidesound.length() * 2;
            }
            size += 2;
            if (this.placesound != null) {
                size += this.placesound.length() * 2;
            }
            size += 4;
            if (this.itemInfos != null) {
                size += this.itemInfos.length * 4;
            }
            size += 4;
            if (this.variants != null) {
                for (int i = 0; i < this.variants.length; ++i) {
                    size += this.variants[i].getSize();
                }
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeItemDefinition(this.serialize());
            if (this.pickingInfo != null && !synchronizedObjects.contains(this.pickingInfo)) {
                this.pickingInfo.synchronize(synchronizedObjects);
            }
            if (this.itemInfos != null) {
                for (int i = 0; i < this.itemInfos.length; ++i) {
                    ItemInfo obj = this.itemInfos[i];
                    if (obj == null || synchronizedObjects.contains(obj)) continue;
                    obj.synchronize(synchronizedObjects);
                }
            }
            if (this.consumeInfo != null && !synchronizedObjects.contains(this.consumeInfo)) {
                this.consumeInfo.synchronize(synchronizedObjects);
            }
        }

        @DefinitionMethod
        public Variant getVariant(int variant) {
            return this.variants[Utils.MathUtils.clamp(0, this.variants.length - 1, variant)];
        }

        @DefinitionMethod
        public TextureAsset getIcon(int texture) {
            return TextureAsset.loadFromGame("#ITEM#" + this.name + "_" + texture);
        }

        public final class Variant {
            public ItemDefinition item;
            public int variant;
            public String name;
            public String assetpath;
            public String lod;
            public String debris;

            private Variant(ItemDefinition this$1) {
            }

            private void deserialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                int item_id = buffer.getInt();
                this.item = item_id == -1 ? null : Definitions.getItemDefinition(item_id);
                this.variant = buffer.getInt();
                this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.lod = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                this.debris = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            }

            private ByteBuffer serialize() {
                ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
                this.serialize(buffer);
                return buffer;
            }

            private void serialize(ByteBuffer buffer) {
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                if (this.item == null) {
                    buffer.putInt(-1);
                } else {
                    buffer.putInt(this.item.id);
                }
                buffer.putInt(this.variant);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.lod);
                InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.debris);
            }

            private int getSize() {
                int size = 8;
                size += 2;
                if (this.name != null) {
                    size += this.name.length() * 2;
                }
                size += 2;
                if (this.assetpath != null) {
                    size += this.assetpath.length() * 2;
                }
                size += 2;
                if (this.lod != null) {
                    size += this.lod.length() * 2;
                }
                size += 2;
                if (this.debris != null) {
                    size += this.debris.length() * 2;
                }
                return size;
            }
        }
    }

    public static enum ItemInfoType {
        Default(0),
        Smelt(1),
        Fuel(2),
        Crush(3),
        Press(4),
        Squeeze(5),
        Tan(6),
        Fill(7),
        Pour(8),
        Cut(9),
        Dry(10),
        Cook(11),
        Bake(12),
        Bag(13);

        public final int value;
        private static ItemInfoType[] values;

        private ItemInfoType(int i) {
            this.value = i;
        }

        public static ItemInfoType get(int value) {
            if (values == null) {
                values = ItemInfoType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (ItemInfoType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum ProjectileType {
        Arrow(0),
        Bullet(1),
        Spear(2);

        public final int value;
        private static ProjectileType[] values;

        private ProjectileType(int i) {
            this.value = i;
        }

        public static ProjectileType get(int value) {
            if (values == null) {
                values = ProjectileType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (ProjectileType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum WeaponType {
        Firearm(0),
        Bow(1),
        Spear(2),
        Throwable(3),
        Firework(4),
        Projectile(5);

        public final int value;
        private static WeaponType[] values;

        private WeaponType(int i) {
            this.value = i;
        }

        public static WeaponType get(int value) {
            if (values == null) {
                values = WeaponType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (WeaponType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum FoodCondition {
        Spoiled(0),
        Ruined(1),
        Edible(30),
        Fresh(100);

        public final int value;
        private static FoodCondition[] values;

        private FoodCondition(int i) {
            this.value = i;
        }

        public static FoodCondition get(int value) {
            if (values == null) {
                values = FoodCondition.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (FoodCondition.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Durability {
        Broken(0),
        BadlyDamaged(10),
        Damaged(30),
        Worn(80),
        Pristine(100);

        public final int value;
        private static Durability[] values;

        private Durability(int i) {
            this.value = i;
        }

        public static Durability get(int value) {
            if (values == null) {
                values = Durability.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Durability.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Modifier {
        Normal(0),
        Broken(1),
        Shoddy(2),
        Annoying(3),
        Shameful(4),
        Cringy(5),
        Cheesy(6),
        Miserable(7),
        Terrible(8),
        Crude(9),
        Weak(10),
        Boring(11),
        Questionable(12),
        Acceptable(13),
        Unspectacular(14),
        Ordinary(15),
        Nice(16),
        Improved(21),
        Robust(22),
        Strong(23),
        Amazing(24),
        Impressive(25),
        Superior(26),
        Appealing(27),
        Powerful(28),
        Merciless(31),
        Ruthless(32),
        Flawless(33),
        Epic(34),
        Legendary(35),
        Godly(36);

        public final int value;
        private static Modifier[] values;

        private Modifier(int i) {
            this.value = i;
        }

        public static Modifier get(int value) {
            if (values == null) {
                values = Modifier.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Modifier.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum PickingType {
        Default(0),
        Sickle(1),
        Scythe(2),
        Trimmer(3),
        Rake(4),
        Hoe(5),
        Sledgehammer(6),
        Knife(7),
        Spear(8),
        Sword(9);

        public final int value;
        private static PickingType[] values;

        private PickingType(int i) {
            this.value = i;
        }

        public static PickingType get(int value) {
            if (values == null) {
                values = PickingType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (PickingType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum ConsumeType {
        Food(0),
        Water(1),
        Medical(2);

        public final int value;
        private static ConsumeType[] values;

        private ConsumeType(int i) {
            this.value = i;
        }

        public static ConsumeType get(int value) {
            if (values == null) {
                values = ConsumeType.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (ConsumeType.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Hand {
        None(0),
        Right(1),
        Left(2);

        public final int value;
        private static Hand[] values;

        private Hand(int i) {
            this.value = i;
        }

        public static Hand get(int value) {
            if (values == null) {
                values = Hand.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Hand.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Material {
        Null(0),
        Wood(1),
        Metal(2),
        Stone(3),
        Glass(4),
        Fruit(5),
        Plant(6),
        Grass(7),
        Fabric(8),
        FabricRough(9),
        Leather(10),
        Plastic(11),
        Paper(12),
        Misc(13);

        public final int value;
        private static Material[] values;

        private Material(int i) {
            this.value = i;
        }

        public static Material get(int value) {
            if (values == null) {
                values = Material.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Material.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Group {
        None(0),
        Treelog(1),
        Sapling(2),
        Fibers(4),
        Cloth(8),
        Knife(16),
        Meat(32),
        Water(64),
        Arrow(128),
        Toolbelt(256),
        Hide(512),
        Pelt(1024),
        Leather(2048);

        public final int value;
        private static Group[] values;

        private Group(int i) {
            this.value = i;
        }

        public static Group get(int value) {
            if (values == null) {
                values = Group.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Group.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Category {
        Tool(0),
        Utility(1),
        Weapon(2),
        Ammo(3),
        Explosive(4),
        Medical(5),
        Food(6),
        Resource(7),
        Bag(8),
        Pelt(9),
        Treelog(10),
        Sapling(11),
        Seedling(12),
        Clothing(13),
        Construction(14),
        Object(15),
        Vehicle(16),
        Bait(17),
        Npc(18),
        Misc(19);

        public final int value;
        private static Category[] values;

        private Category(int i) {
            this.value = i;
        }

        public static Category get(int value) {
            if (values == null) {
                values = Category.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Category.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Type {
        None(0),
        Default(1),
        Equipment(2),
        Clothing(3),
        Bag(4),
        Treelog(5),
        Plant(6),
        Object(7),
        Construction(8),
        Blueprint(9),
        Poster(10),
        Claim(11),
        Vehicle(12),
        Light(13),
        Ore(14),
        Ingot(15),
        Food(16),
        Bottle(17),
        Ingredient(18),
        Powder(19),
        Fibers(20),
        Pelt(21),
        Bait(22),
        Npc(23),
        Firearm(24),
        Explosive(25),
        Ammo(26),
        Sickle(27),
        Knife(28),
        Paint(29),
        Dye(30),
        SheepShears(31),
        Bucket(32),
        Ball(33),
        MusicDisc(34),
        API(35);

        public final int value;
        private static Type[] values;

        private Type(int i) {
            this.value = i;
        }

        public static Type get(int value) {
            if (values == null) {
                values = Type.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Type.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

