/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api;

import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.WeatherDefs;
import net.risingworld.api.objects.Area;
import net.risingworld.api.objects.CustomImage;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Time;
import net.risingworld.api.utils.Platform;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class Server {
    private Server() {
    }

    public static Type getType() {
        return Type.get(Server.getTypeNative());
    }

    private static native int getTypeNative();

    public static Platform getPlatform() {
        return Platform.get(Server.getPlatformNative());
    }

    private static native int getPlatformNative();

    public static native long getServerUID();

    public static native String getName();

    public static native String getIP();

    public static native int getPort();

    public static native boolean isPassworded();

    public static native float getRunningTime();

    public static native String getOption(String var0);

    public static native String[] getAllPermissionGroups();

    public static native String getVersion();

    public static native int getBuild();

    public static native void saveAll();

    public static native void savePlayers();

    public static native void saveStorages();

    public static native void saveNpcs();

    public static native void sendInputCommand(String var0);

    public static native String getLogFilePath();

    public static native void shutdown();

    public static native void restart();

    public static void setDefaultSpawnPosition(Vector3f position) {
        Server.setDefaultSpawnPosition(position.x, position.y, position.z);
    }

    public static native void setDefaultSpawnPosition(float var0, float var1, float var2);

    public static native Vector3f getDefaultSpawnPosition();

    public static void setDefaultSpawnRotation(Quaternion quaternion) {
        float[] euler = quaternion.toAngles();
        Server.setDefaultSpawnRotation(euler[0], euler[1], euler[2]);
    }

    public static native void setDefaultSpawnRotation(float var0, float var1, float var2);

    public static native Quaternion getDefaultSpawnRotation();

    public static native void setDefaultSpawnInventory(Inventory var0);

    public static native Inventory getDefaultSpawnInventory();

    public static native void setGameTime(int var0, int var1);

    public static int getGameTime(Time.Unit unit) {
        return Server.getGameTime().getTime(unit);
    }

    public static native Time getGameTime();

    public static native void setGameTimeSpeed(float var0);

    public static native float getGameTimeSpeed();

    public static void setWeather(WeatherDefs.Weather newWeather, boolean instant) {
        Server.setWeather(newWeather.id, instant);
    }

    private static native void setWeather(int var0, boolean var1);

    public static WeatherDefs.Weather getCurrentWeather() {
        return Definitions.getWeather(Server.getCurrentWeatherNative());
    }

    private static native int getCurrentWeatherNative();

    public static WeatherDefs.Weather getNextWeather() {
        return Definitions.getWeather(Server.getNextWeatherNative());
    }

    private static native int getNextWeatherNative();

    public static native void setWeatherEnabled(boolean var0);

    public static native boolean isWeatherEnabled();

    public static native float getWeatherTransition();

    public static native int getPlayerCount();

    public static native int getMaxPlayerCount();

    public static native int getTotalPlayerCount();

    public static native boolean isPlayerConnected(int var0);

    public static native boolean isPlayerConnected(String var0);

    public static native Player getPlayer(int var0);

    public static native Player getPlayerByUID(String var0);

    public static native Player getPlayerByDbID(int var0);

    public static native Player getPlayerByName(String var0);

    public static native String getPlayerUID(int var0);

    public static native Player[] getAllPlayers();

    public static native boolean isPlayerBanned(String var0);

    public static native boolean isPlayerAdmin(String var0);

    public static native void banPlayer(String var0, String var1, int var2);

    public static native void unbanPlayer(String var0);

    public static Player findNearestPlayer(Vector3f position) {
        return Server.findNearestPlayer(position.x, position.y, position.z);
    }

    private static native Player findNearestPlayer(float var0, float var1, float var2);

    public static native String getLastKnownPlayerName(String var0);

    public static native String getLastKnownPlayerName(int var0);

    public static native String[] getLastKnownPlayerUIDs(String var0);

    public static void addArea(Area area) {
        Server.addArea(area, false);
    }

    public static native void addArea(Area var0, boolean var1);

    public static native void removeArea(Area var0);

    public static native Area getArea(long var0);

    public static native Area[] getAllAreas();

    public static native CustomImage getCustomImage(long var0);

    public static native void removeCustomImage(long var0, boolean var2);

    public static native CustomImage[] getAllCustomImages();

    public static native CustomImage[] getAllCustomImages(int var0);

    public static native void broadcastTextMessage(String var0);

    public static native void broadcastYellMessage(String var0, float var1, boolean var2);

    public static enum Type {
        Unknown,
        Singleplayer,
        Multiplayer,
        LAN,
        Dedicated,
        P2PHost,
        P2PClient;

        private static Type[] values;

        private static Type get(int ordinal) {
            if (values == null) {
                values = Type.values();
            }
            return values[ordinal];
        }
    }
}

