/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.nio.ByteBuffer;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleKeyword;

public final class StyleScale
extends StyleField {
    private float x;
    private float y;
    private StyleKeyword keyword;

    StyleScale() {
        this(StyleKeyword.Null);
    }

    StyleScale(float x, float y) {
        this.x = x;
        this.y = y;
        this.keyword = StyleKeyword.Undefined;
    }

    StyleScale(StyleKeyword keyword) {
        this.y = 0.0f;
        this.x = 0.0f;
        this.keyword = keyword;
    }

    public void refresh() {
        this.isDirty = true;
    }

    public void set(float x, float y) {
        if (this.x != x || this.y != y || this.keyword != StyleKeyword.Undefined) {
            this.isDirty = true;
            this.x = x;
            this.y = y;
            this.keyword = StyleKeyword.Undefined;
        }
    }

    public void set(StyleKeyword keyword) {
        this.isDirty = true;
        this.keyword = keyword;
    }

    @Override
    public void reset() {
        this.set(StyleKeyword.Null);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public StyleKeyword getKeyword() {
        return this.keyword;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put((byte)this.keyword.ordinal());
        buffer.putFloat(this.x);
        buffer.putFloat(this.y);
    }

    @Override
    void deserialize(ByteBuffer buffer) {
        this.keyword = StyleKeyword.get(buffer.get());
        this.x = buffer.getFloat();
        this.y = buffer.getFloat();
    }
}

