/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.nio.ByteBuffer;
import java.util.Objects;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleKeyword;

public final class StyleImage
extends StyleField {
    private TextureAsset image;
    private StyleKeyword keyword;

    StyleImage() {
        this.image = null;
        this.keyword = StyleKeyword.Null;
    }

    StyleImage(TextureAsset image) {
        this.image = image;
        this.keyword = StyleKeyword.Undefined;
    }

    StyleImage(StyleKeyword keyword) {
        this.image = null;
        this.keyword = keyword;
    }

    public void set(TextureAsset image) {
        if (!Objects.equals(this.image, image) || this.keyword != StyleKeyword.Undefined) {
            this.isDirty = true;
            this.image = image;
            this.keyword = StyleKeyword.Undefined;
        }
    }

    public void set(StyleKeyword keyword) {
        this.isDirty = true;
        this.keyword = keyword;
    }

    @Override
    public void reset() {
        this.set(StyleKeyword.Null);
    }

    public TextureAsset get() {
        return this.image;
    }

    public StyleKeyword getKeyword() {
        return this.keyword;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put((byte)this.keyword.ordinal());
        buffer.putInt(this.image == null ? -1 : this.image.getHandle());
    }

    @Override
    void deserialize(ByteBuffer buffer) {
        this.keyword = StyleKeyword.get(buffer.get());
        int imageAssetID = buffer.getInt();
        this.image = null;
    }
}

