/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.objects.visuals;

import java.nio.ByteBuffer;
import net.risingworld.api.objects.visuals.Effect;
import net.risingworld.api.utils.Utils;

public final class Vignette
extends Effect {
    private float intensity;
    private int color;
    private float smoothness = 1.0f;
    private float roundness = 1.0f;

    public void set(float intensity, float r, float g, float b, float smoothness, float roundness) {
        r = Utils.MathUtils.saturate(r);
        g = Utils.MathUtils.saturate(g);
        b = Utils.MathUtils.saturate(b);
        int c = Utils.GeneralUtils.colorRGBAToInt(r, g, b, 1.0f);
        this.set(intensity, c, smoothness, roundness);
    }

    public void set(float intensity, int color, float smoothness, float roundness) {
        if (!this.isOverridden || this.intensity != intensity || this.color != color || this.smoothness != smoothness || this.roundness != roundness) {
            this.intensity = intensity;
            this.color = color;
            this.smoothness = smoothness;
            this.roundness = roundness;
            this.isOverridden = true;
            this.isDirty = true;
        }
    }

    public float getIntensity() {
        return this.intensity;
    }

    public float getSmoothness() {
        return this.smoothness;
    }

    public float getRoundness() {
        return this.roundness;
    }

    @Override
    public void reset() {
        this.isOverridden = false;
        this.isDirty = true;
        this.intensity = 0.0f;
        this.color = 0;
        this.smoothness = 1.0f;
        this.roundness = 1.0f;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.putFloat(this.intensity);
        buffer.putInt(this.color);
        buffer.putFloat(this.smoothness);
        buffer.putFloat(this.roundness);
    }
}

