/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.events.player;

import net.risingworld.api.events.Cancellable;
import net.risingworld.api.events.player.PlayerEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public final class PlayerWeaponFireEvent
extends PlayerEvent
implements Cancellable {
    private PlayerWeaponFireEvent(long pointer) {
        super(pointer);
    }

    public Item getWeapon() {
        this.CheckIsValid();
        return this.getWeapon(this.pointer);
    }

    public int getAmmoSlot() {
        this.CheckIsValid();
        return this.getAmmoSlot(this.pointer);
    }

    public Inventory.SlotType getAmmoSlotType() {
        this.CheckIsValid();
        return Inventory.SlotType.get(this.getAmmoSlotType(this.pointer));
    }

    public Vector3f getFirePosition() {
        this.CheckIsValid();
        return this.getFirePosition(this.pointer);
    }

    public void setFirePosition(Vector3f position) {
        if (position == null) {
            return;
        }
        this.CheckIsValid();
        this.setFirePosition(this.pointer, position.x, position.y, position.z);
    }

    public Quaternion getFireRotation() {
        this.CheckIsValid();
        return this.getFireRotation(this.pointer);
    }

    public void setFireRotation(Quaternion rotation) {
        if (rotation == null) {
            return;
        }
        this.CheckIsValid();
        this.setFireRotation(this.pointer, rotation.x, rotation.y, rotation.z, rotation.w);
    }

    public float getFirePower() {
        this.CheckIsValid();
        return this.getFirePower(this.pointer);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    private native Item getWeapon(long var1);

    private native int getAmmoSlot(long var1);

    private native int getAmmoSlotType(long var1);

    private native Vector3f getFirePosition(long var1);

    private native void setFirePosition(long var1, float var3, float var4, float var5);

    private native Quaternion getFireRotation(long var1);

    private native void setFireRotation(long var1, float var3, float var4, float var5, float var6);

    private native float getFirePower(long var1);
}

