/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.assets;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.risingworld.api.assets.Asset;

public class ModelImportSettings
extends Asset {
    public float meshScaleFactor = 1.0f;
    public ModelPivot meshPivot = ModelPivot.Default;
    public float meshNormalSmoothingAngle = 60.0f;
    public int meshImportFlags;
    public AnimationType animationType = AnimationType.Legacy;
    public AnimationWrapMode animationWrapMode = AnimationWrapMode.Loop;
    public int animationImportFlags;
    public int maxTextureResolution = 0;
    public int materialFlags;
    private final int BYTES = 27;

    public static ModelImportSettings create(String name) {
        ModelImportSettings asset = new ModelImportSettings(name);
        asset.source = Asset.Source.Raw;
        asset.setupFileInfo(-1, -1, null, name, "modelimportsettings_" + name + "_" + System.currentTimeMillis(), "mat", String.valueOf(System.currentTimeMillis()));
        asset.setModelSettings(MeshImportFlags.UseFileScale, MeshImportFlags.SortHierarchyByName, MeshImportFlags.MergeVertices, MeshImportFlags.ImportNormals, MeshImportFlags.ImportColors, MeshImportFlags.GenerateTangents, MeshImportFlags.OptimizeMesh);
        asset.setAnimationSettings(AnimationImportFlags.AutoPlayLegacyAnimations, AnimationImportFlags.HumanoidEnforceTPose);
        asset.setMaterialSettings(MaterialImportFlags.ImportMaterials, MaterialImportFlags.EnableAlphaThreshold, MaterialImportFlags.EnableTransparency, MaterialImportFlags.ImportTextures, MaterialImportFlags.LoadTexturesAsSRGB, MaterialImportFlags.GenerateTextureMipMaps);
        return asset;
    }

    ModelImportSettings(String name) {
        super(Asset.Type.ModelImportSettings);
    }

    public void setModelSetting(MeshImportFlags flag, boolean set) {
        this.meshImportFlags = set ? (this.meshImportFlags |= 1 << flag.ordinal()) : (this.meshImportFlags &= ~(1 << flag.ordinal()));
    }

    public boolean getModelSetting(MeshImportFlags flag) {
        return (this.meshImportFlags & 1 << flag.ordinal()) != 0;
    }

    public void setModelSettings(MeshImportFlags ... flags) {
        this.meshImportFlags = 0;
        for (MeshImportFlags flag : flags) {
            this.meshImportFlags |= 1 << flag.ordinal();
        }
    }

    public void setAnimationSettings(AnimationImportFlags ... flags) {
        this.animationImportFlags = 0;
        for (AnimationImportFlags flag : flags) {
            this.animationImportFlags |= 1 << flag.ordinal();
        }
    }

    public void setAnimationSetting(AnimationImportFlags flag, boolean set) {
        this.animationImportFlags = set ? (this.animationImportFlags |= 1 << flag.ordinal()) : (this.animationImportFlags &= ~(1 << flag.ordinal()));
    }

    public boolean getAnimationSetting(AnimationImportFlags flag) {
        return (this.animationImportFlags & 1 << flag.ordinal()) != 0;
    }

    public void setMaterialSettings(MaterialImportFlags ... flags) {
        this.materialFlags = 0;
        for (MaterialImportFlags flag : flags) {
            this.materialFlags |= 1 << flag.ordinal();
        }
    }

    public void setMaterialSetting(MaterialImportFlags flag, boolean set) {
        this.materialFlags = set ? (this.materialFlags |= 1 << flag.ordinal()) : (this.materialFlags &= ~(1 << flag.ordinal()));
    }

    public boolean getMaterialSetting(MaterialImportFlags flag) {
        return (this.animationImportFlags & 1 << flag.ordinal()) != 0;
    }

    @Override
    synchronized byte[] loadData(boolean saveInCache) {
        byte[] data = this.serialize();
        if (saveInCache) {
            this.cachedData = data;
        }
        return data;
    }

    @Override
    void onInit() {
    }

    @Override
    boolean checkFileExtension(String name) {
        return true;
    }

    private byte[] serialize() {
        ByteBuffer bb = ByteBuffer.allocate(27);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.putFloat(this.meshScaleFactor);
        bb.put(this.meshPivot == null ? (byte)0 : (byte)this.meshPivot.ordinal());
        bb.putFloat(this.meshNormalSmoothingAngle);
        bb.putInt(this.meshImportFlags);
        bb.put(this.animationType == null ? (byte)0 : (byte)this.animationType.ordinal());
        bb.put(this.animationWrapMode == null ? (byte)0 : (byte)this.animationWrapMode.ordinal());
        bb.putInt(this.animationImportFlags);
        bb.putInt(this.maxTextureResolution);
        bb.putInt(this.materialFlags);
        byte[] data = new byte[bb.position()];
        bb.flip();
        bb.get(data);
        return data;
    }

    public static enum MeshImportFlags {
        UseFileScale,
        ImportLights,
        SortHierarchyByName,
        MergeToSingleObject,
        KeepMeshesReadable,
        MergeVertices,
        GenerateColliders,
        GenerateConvexColliders,
        ImportNormals,
        GenerateNormals,
        ImportColors,
        ImportTangents,
        GenerateTangents,
        OptimizeMesh,
        SwapUVs;

    }

    public static enum AnimationImportFlags {
        AutoPlayLegacyAnimations,
        EnforceAnimatorWithLegacyAnimations,
        HumanoidSampleBindPose,
        HumanoidEnforceTPose;

    }

    public static enum MaterialImportFlags {
        ImportMaterials,
        EnableAlphaThreshold,
        EnableTransparency,
        DoubleSidedMaterials,
        ImportTextures,
        LoadTexturesAsSRGB,
        GenerateTextureMipMaps;

    }

    public static enum ModelPivot {
        Default,
        Center,
        Bottom;

    }

    public static enum AnimationType {
        Legacy,
        Generic,
        Humanoid,
        None;

    }

    public static enum AnimationWrapMode {
        Default,
        Once,
        Loop;

    }
}

