/*
 * Decompiled with CFR 0.152.
 */
package nightspawn;

import java.sql.SQLException;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.Timer;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.definitions.Definitions;
import net.risingworld.api.definitions.Items;
import net.risingworld.api.definitions.Npcs;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.npc.NpcDeathEvent;
import net.risingworld.api.events.player.PlayerChangeBlockPositionEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;

public class NightSpawn
extends Plugin
implements Listener {
    public Timer timer;
    public Database NightSpawnDB;

    @Override
    public void onEnable() {
        this.registerEventListener(this);
        String WorldName = World.getName();
        System.out.println("-- NightSpawn PLUGIN ENABLED --");
        this.NightSpawnDB = this.getSQLiteConnection(this.getPath() + "/" + WorldName + "/NightSpawn.db");
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        Timer TickerTimer = new Timer(1.0f, 0.0f, -1, null);
        Runnable TickerTimerTask = () -> {
            block6: {
                Npc[] npcs;
                block5: {
                    int Hour = Server.getGameTime().getHours();
                    if (Hour < 22 && Hour >= 7) break block5;
                    player.setAttribute("NightTime", true);
                    int max = 20;
                    int max2 = 2;
                    int min = 1;
                    int range = max - min + 1;
                    int Flip = max2 - min + 1;
                    for (int i = 0; i < 1; ++i) {
                        int rand = (int)(Math.random() * (double)range) + min;
                        int distance = (int)(Math.random() * (double)range) + min;
                        int flipped = (int)(Math.random() * (double)Flip) + min;
                        if (flipped == 1) {
                            distance += 20;
                        } else if (flipped == 2) {
                            distance -= 40;
                        }
                        if (rand != 10) continue;
                        System.out.println("Spawn Npc");
                        Npcs.NpcDefinition ghoulDef = Definitions.getNpcDefinition("ghoul");
                        Vector3f position = Utils.VectorUtils.getXYZInFrontOfPlayer(player, distance);
                        Vector3f playerPos = player.getPosition();
                        Vector3f direction = playerPos.subtract(position).normalizeLocal();
                        Quaternion rotation = new Quaternion();
                        rotation.lookAt(direction);
                        World.spawnNpc(ghoulDef.id, 0, position, rotation, true);
                    }
                    break block6;
                }
                if (!Boolean.TRUE.equals(player.getAttribute("NightTime"))) break block6;
                Npcs.NpcDefinition ghoulDef = Definitions.getNpcDefinition("ghoul");
                for (Npc npc : npcs = World.getAllNpcs()) {
                    if (npc.getTypeID() != ghoulDef.id || !npc.isTransient()) continue;
                    npc.kill();
                    player.setAttribute("NightTime", false);
                }
            }
        };
        TickerTimer.setTask(TickerTimerTask);
        TickerTimer.start();
        player.setAttribute("TickerTimer", TickerTimer);
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) throws SQLException {
        Player player = event.getPlayer();
        Timer TickerTimer = (Timer)player.getAttribute("TickerTimer");
        if (TickerTimer != null) {
            TickerTimer.kill();
        }
    }

    @EventMethod
    public void onPlayerChangeBlockPositionEvent(PlayerChangeBlockPositionEvent event) throws SQLException {
        Npc AttackHumman;
        Player player = event.getPlayer();
        Vector3f playerPos = player.getPosition();
        Npcs.NpcDefinition ghoulDef = Definitions.getNpcDefinition("ghoul");
        if (Boolean.TRUE.equals(player.getAttribute("NightTime")) && (AttackHumman = World.findNearestNpc(ghoulDef.id, playerPos)) != null) {
            AttackHumman.setAlerted(true);
        }
    }

    @EventMethod
    public void onNpcDeathEvent(NpcDeathEvent event) {
        Npc DeadNPC = event.getNpc();
        Object ifkilledbyplayer = event.getKiller();
        if (ifkilledbyplayer != null) {
            Vector3f DeathPosition = event.getDeathPosition();
            int max = 20;
            int min = 1;
            int range = max - min + 1;
            for (int i = 0; i < 1; ++i) {
                Items.ItemDefinition getItemID;
                int rand = (int)(Math.random() * (double)range) + min;
                if (rand == 1) {
                    getItemID = Definitions.getItemDefinition("ammorepeater");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 2) {
                    getItemID = Definitions.getItemDefinition("goldingot");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 3) {
                    getItemID = Definitions.getItemDefinition("ironingot");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 4) {
                    getItemID = Definitions.getItemDefinition("aluminiumingot");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 5) {
                    getItemID = Definitions.getItemDefinition("stick");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 6) {
                    getItemID = Definitions.getItemDefinition("apple");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 7) {
                    getItemID = Definitions.getItemDefinition("carrot");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 8) {
                    getItemID = Definitions.getItemDefinition("tomato");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 9) {
                    getItemID = Definitions.getItemDefinition("bread");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 10) {
                    getItemID = Definitions.getItemDefinition("cookie");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 11) {
                    getItemID = Definitions.getItemDefinition("rubberduck");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 12) {
                    getItemID = Definitions.getItemDefinition("pickaxesteel");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 13) {
                    getItemID = Definitions.getItemDefinition("toolbelt");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 14) {
                    getItemID = Definitions.getItemDefinition("gunpowder");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 15) {
                    getItemID = Definitions.getItemDefinition("bottle");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 16) {
                    getItemID = Definitions.getItemDefinition("bandage");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 17) {
                    getItemID = Definitions.getItemDefinition("splint");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 18) {
                    getItemID = Definitions.getItemDefinition("medkit");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand == 19) {
                    getItemID = Definitions.getItemDefinition("rags");
                    World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
                }
                if (rand != 20) continue;
                getItemID = Definitions.getItemDefinition("combatknife");
                World.spawnItem(getItemID.id, 0, 0, DeathPosition, Quaternion.IDENTITY, true);
            }
        }
        Npcs.NpcDefinition ghoulDef = Definitions.getNpcDefinition("ghoul");
        Npcs.NpcDefinition dummyDef = Definitions.getNpcDefinition("dummy");
        if (DeadNPC.getTypeID() == ghoulDef.id) {
            DeadNPC.transform(dummyDef.id, 0);
        }
    }

    @Override
    public void onDisable() {
    }
}

