/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui.style;

import java.nio.ByteBuffer;
import net.risingworld.api.ui.style.StyleField;
import net.risingworld.api.ui.style.StyleKeyword;

public final class StyleFloat
extends StyleField {
    private float value;
    private StyleKeyword keyword;

    StyleFloat() {
        this.value = 0.0f;
        this.keyword = StyleKeyword.Null;
    }

    StyleFloat(float value) {
        this.value = value;
        this.keyword = StyleKeyword.Undefined;
    }

    StyleFloat(StyleKeyword keyword) {
        this.value = 0.0f;
        this.keyword = keyword;
    }

    public void set(float value) {
        if (this.value != value || this.keyword != StyleKeyword.Undefined) {
            this.isDirty = true;
            this.value = value;
            this.keyword = StyleKeyword.Undefined;
        }
    }

    public void set(StyleKeyword keyword) {
        this.isDirty = true;
        this.keyword = keyword;
    }

    @Override
    public void reset() {
        this.set(StyleKeyword.Null);
    }

    public float get() {
        return this.value;
    }

    public StyleKeyword getKeyword() {
        return this.keyword;
    }

    @Override
    void serialize(ByteBuffer buffer) {
        buffer.put((byte)this.keyword.ordinal());
        buffer.putFloat(this.value);
    }

    @Override
    void deserialize(ByteBuffer buffer) {
        this.keyword = StyleKeyword.get(buffer.get());
        this.value = buffer.getFloat();
    }
}

