/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.ui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.jiw.unity.runtime.PluginManager;
import net.jiw.unity.runtime.PluginUIManager;
import net.risingworld.api.assets.StyleSheetAsset;
import net.risingworld.api.events.player.ui.PlayerUIElementClickEvent;
import net.risingworld.api.ui.style.Pivot;
import net.risingworld.api.ui.style.Position;
import net.risingworld.api.ui.style.Style;
import net.risingworld.api.ui.style.Unit;
import net.risingworld.api.ui.style.Visibility;
import net.risingworld.api.utils.Utils;

public class UIElement
implements Serializable {
    final int id;
    final int pluginID;
    public final Style style;
    public final Style hoverStyle;
    UIElement parent = null;
    boolean clickable = false;
    boolean pickable = true;
    private int[] styleSheets = null;
    private String[] styleSheetClassList = null;
    private ArrayList<UIElement> childs = new ArrayList(4);
    private static final AtomicInteger id_counter = new AtomicInteger(1);
    private static final int TYPE = 0;

    public UIElement() {
        this.id = id_counter.getAndIncrement();
        this.pluginID = PluginManager.getPluginIDFromContext();
        this.style = new Style();
        this.hoverStyle = new Style();
    }

    public int getID() {
        return this.id;
    }

    public int getPluginID() {
        return this.pluginID;
    }

    public void updateStyle() {
        this.updateElement();
    }

    public void addStyleSheet(StyleSheetAsset styleSheetAsset) {
        if (this.styleSheets == null) {
            this.styleSheets = new int[1];
        }
        if (!Utils.ArrayUtils.contains(this.styleSheets, styleSheetAsset.getHandle())) {
            this.styleSheets = Utils.ArrayUtils.append(this.styleSheets, styleSheetAsset.getHandle());
            this.updateStyleSheets();
        }
    }

    public void removeStyleSheet(StyleSheetAsset styleSheetAsset) {
        this.styleSheets = Utils.ArrayUtils.removeEntries(this.styleSheets, styleSheetAsset.getHandle());
    }

    public void addToClassList(String className) {
        if (!Utils.ArrayUtils.contains(this.styleSheetClassList, className)) {
            this.styleSheetClassList = Utils.ArrayUtils.append(this.styleSheetClassList, className);
            this.updateStyleSheets();
        }
    }

    public void removeFromClassList(String className) {
        this.styleSheetClassList = Utils.ArrayUtils.removeEntries(this.styleSheetClassList, className);
    }

    public void setPosition(float x, float y, boolean percent) {
        Unit unit = percent ? Unit.Percent : Unit.Pixel;
        this.style.left.set(x, unit);
        this.style.top.set(y, unit);
        this.style.position.set(Position.Absolute);
        this.updateStyle();
    }

    public void setPivot(Pivot pivot) {
        this.style.transformOrigin.set(pivot);
        this.style.translate.set(pivot);
        this.updateStyle();
    }

    public void resetPosition() {
        this.style.left.reset();
        this.style.bottom.reset();
        this.style.top.reset();
        this.style.right.reset();
        this.style.position.reset();
        this.updateStyle();
    }

    public void resetPivot() {
        this.style.transformOrigin.reset();
        this.style.translate.reset();
        this.updateStyle();
    }

    public void setSize(float width, float height, boolean percent) {
        Unit unit;
        Unit unit2 = unit = percent ? Unit.Percent : Unit.Pixel;
        if (this.style.width.get() != width || this.style.height.get() != height || this.style.width.getUnit() != unit || this.style.height.getUnit() != unit) {
            this.style.width.set(width, unit);
            this.style.height.set(height, unit);
            this.updateStyle();
        }
    }

    public void setBorder(float thickness) {
        this.style.borderLeftWidth.set(thickness);
        this.style.borderRightWidth.set(thickness);
        this.style.borderTopWidth.set(thickness);
        this.style.borderBottomWidth.set(thickness);
        this.updateStyle();
    }

    public void setBorderColor(float r, float g, float b, float a) {
        this.setBorderColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setBorderColor(int rgba) {
        this.style.borderLeftColor.set(rgba);
        this.style.borderRightColor.set(rgba);
        this.style.borderTopColor.set(rgba);
        this.style.borderBottomColor.set(rgba);
        this.updateStyle();
    }

    public void setBorderEdgeRadius(float radius, boolean percent) {
        Unit unit = percent ? Unit.Percent : Unit.Pixel;
        this.style.borderTopLeftRadius.set(radius, unit);
        this.style.borderTopRightRadius.set(radius, unit);
        this.style.borderBottomLeftRadius.set(radius, unit);
        this.style.borderBottomRightRadius.set(radius, unit);
        this.updateStyle();
    }

    public void setBackgroundColor(float r, float g, float b, float a) {
        this.setBackgroundColor(Utils.GeneralUtils.colorRGBAToInt(r, g, b, a));
    }

    public void setBackgroundColor(int rgba) {
        if (this.style.backgroundColor.get() != rgba) {
            this.style.backgroundColor.set(rgba);
            this.updateStyle();
        }
    }

    public void setOpacity(float opacity) {
        if (this.style.opacity.get() != opacity) {
            this.style.opacity.set(opacity);
            this.updateStyle();
        }
    }

    public void setVisible(boolean visible) {
        Visibility vis;
        Visibility visibility = vis = visible ? Visibility.Visible : Visibility.Hidden;
        if (this.style.visibility.get() != vis) {
            this.style.visibility.set(vis);
            this.updateStyle();
        }
    }

    public void setClickable(boolean clickable) {
        if (this.clickable != clickable) {
            this.clickable = clickable;
            this.updateClickable();
        }
    }

    public boolean isClickable() {
        return this.clickable;
    }

    public void setPickable(boolean pickable) {
        if (this.pickable != this.pickable) {
            this.pickable = pickable;
            this.updatePickable();
        }
    }

    public void addChild(UIElement child) {
        if (child == null || this.childs.contains(child)) {
            return;
        }
        if (child == this) {
            throw new IllegalStateException("Cannot add UI element to itself");
        }
        if (child.parent != null) {
            child.removeFromParent();
        } else {
            PluginUIManager.unregisterUIElementForAllPlayers((UIElement)child, (boolean)true);
        }
        this.childs.add(child);
        child.parent = this;
        this.updateHierarchy(child);
    }

    public void removeChild(UIElement child) {
        if (child == null) {
            return;
        }
        if (this.childs.remove(child)) {
            child.parent = null;
            PluginUIManager.unregisterUIElementForAllPlayers((UIElement)child, (boolean)true);
        }
    }

    public void removeAllChilds() {
        for (UIElement child : this.childs) {
            child.parent = null;
            PluginUIManager.unregisterUIElementForAllPlayers((UIElement)child, (boolean)true);
        }
        this.childs.clear();
    }

    public UIElement getParent() {
        return this.parent;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public List<UIElement> getChilds() {
        if (this.childs == null) {
            return null;
        }
        return Collections.unmodifiableList(this.childs);
    }

    public int getChildCount() {
        return this.childs.size();
    }

    int getType() {
        return 0;
    }

    public void onClick(PlayerUIElementClickEvent event) {
    }

    private void updateElement() {
        PluginUIManager.updateUIElementStyle((UIElement)this, (int)this.id, (Style)this.style, (Style)this.hoverStyle);
    }

    private void updateStyleSheets() {
        PluginUIManager.updateUIElementStyleSheets((UIElement)this, (int)this.id);
    }

    private void updateHierarchy(UIElement newChild) {
        PluginUIManager.updateHierarchy((UIElement)this, (UIElement)newChild);
    }

    private void updateClickable() {
        PluginUIManager.updateUIElementClickable((UIElement)this, (int)this.id, (boolean)this.clickable);
    }

    private void updatePickable() {
        PluginUIManager.updateUIElementPickable((UIElement)this, (int)this.id, (boolean)this.pickable);
    }
}

