/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.definitions;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import net.jiw.unity.runtime.utils.DefinitionMethod;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.assets.TextureAsset;
import net.risingworld.api.definitions.Definitions;

public final class Clothing {
    private Clothing() {
    }

    public final class ClothingDefinition {
        public short id;
        public String name;
        public Type[] types;
        public Function function;
        public String requirement;
        public Race race;
        public Gender gender;
        public String assetpath;
        public String assetpathfemale;
        public String alphamask;
        public int hideunderwear;
        public String rootbone;
        public String[] bones;
        public String relateditem;
        public int protection;
        public int insulation;
        public int absorbency;
        public int heatprotection;
        public int radiationprotection;
        public int camouflage;
        public boolean isarmor;
        public boolean istool;
        public boolean isheadgear;
        public boolean isfootwear;
        public String specialasset;
        public boolean visiblefp;
        public boolean hidehair;
        public boolean hidebeard;
        public int walksound;

        private ClothingDefinition(Clothing this$0) {
        }

        private void deserialize(ByteBuffer buffer) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            this.id = (short)buffer.getInt();
            this.name = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            int itypes = buffer.getInt();
            if (itypes == -1) {
                this.types = null;
            } else if (itypes >= 0) {
                this.types = new Type[itypes];
                for (int i = 0; i < itypes; ++i) {
                    this.types[i] = Type.get(buffer.getInt());
                }
            }
            this.function = Function.get(buffer.getInt());
            this.requirement = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.race = Race.get(buffer.getInt());
            this.gender = Gender.get(buffer.getInt());
            this.assetpath = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.assetpathfemale = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.alphamask = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.hideunderwear = buffer.getInt();
            this.rootbone = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            int ibones = buffer.getInt();
            if (ibones == -1) {
                this.bones = null;
            } else if (ibones >= 0) {
                this.bones = new String[ibones];
                for (int i = 0; i < ibones; ++i) {
                    this.bones[i] = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
                }
            }
            this.relateditem = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.protection = buffer.getInt();
            this.insulation = buffer.getInt();
            this.absorbency = buffer.getInt();
            this.heatprotection = buffer.getInt();
            this.radiationprotection = buffer.getInt();
            this.camouflage = buffer.getInt();
            this.isarmor = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.istool = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.isheadgear = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.isfootwear = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.specialasset = InternalUtils.ByteBufferUtils.getString((ByteBuffer)buffer);
            this.visiblefp = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.hidehair = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.hidebeard = InternalUtils.ByteBufferUtils.getBoolean((ByteBuffer)buffer);
            this.walksound = buffer.getInt();
        }

        private ByteBuffer serialize() {
            ByteBuffer buffer = ByteBuffer.allocateDirect(this.getSize());
            this.serialize(buffer);
            return buffer;
        }

        private void serialize(ByteBuffer buffer) {
            int i;
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(this.id);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.name);
            if (this.types == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.types.length);
                for (i = 0; i < this.types.length; ++i) {
                    if (this.types[i] == null) {
                        throw new IllegalArgumentException("Enumeration must not be null!");
                    }
                    buffer.putInt(this.types[i].value);
                }
            }
            if (this.function == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.function.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.requirement);
            if (this.race == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.race.value);
            if (this.gender == null) {
                throw new IllegalArgumentException("Enumeration must not be null!");
            }
            buffer.putInt(this.gender.value);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpath);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.assetpathfemale);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.alphamask);
            buffer.putInt(this.hideunderwear);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.rootbone);
            if (this.bones == null) {
                buffer.putInt(-1);
            } else {
                buffer.putInt(this.bones.length);
                for (i = 0; i < this.bones.length; ++i) {
                    InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.bones[i]);
                }
            }
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.relateditem);
            buffer.putInt(this.protection);
            buffer.putInt(this.insulation);
            buffer.putInt(this.absorbency);
            buffer.putInt(this.heatprotection);
            buffer.putInt(this.radiationprotection);
            buffer.putInt(this.camouflage);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.isarmor);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.istool);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.isheadgear);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.isfootwear);
            InternalUtils.ByteBufferUtils.putString((ByteBuffer)buffer, (String)this.specialasset);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.visiblefp);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hidehair);
            InternalUtils.ByteBufferUtils.putBoolean((ByteBuffer)buffer, (boolean)this.hidebeard);
            buffer.putInt(this.walksound);
        }

        private int getSize() {
            int size = 55;
            size += 2;
            if (this.name != null) {
                size += this.name.length() * 2;
            }
            size += 4;
            if (this.types != null) {
                size += this.types.length * 4;
            }
            size += 2;
            if (this.requirement != null) {
                size += this.requirement.length() * 2;
            }
            size += 2;
            if (this.assetpath != null) {
                size += this.assetpath.length() * 2;
            }
            size += 2;
            if (this.assetpathfemale != null) {
                size += this.assetpathfemale.length() * 2;
            }
            size += 2;
            if (this.alphamask != null) {
                size += this.alphamask.length() * 2;
            }
            size += 2;
            if (this.rootbone != null) {
                size += this.rootbone.length() * 2;
            }
            size += 4;
            if (this.bones != null) {
                for (int i = 0; i < this.bones.length; ++i) {
                    if (this.bones[i] == null) {
                        size += 2;
                        continue;
                    }
                    size += this.bones[i].length() * 2 + 2;
                }
            }
            size += 2;
            if (this.relateditem != null) {
                size += this.relateditem.length() * 2;
            }
            size += 2;
            if (this.specialasset != null) {
                size += this.specialasset.length() * 2;
            }
            return size;
        }

        public void synchronize() {
            ArrayList<Object> synchronizedObjects = new ArrayList<Object>();
            this.synchronize(synchronizedObjects);
        }

        void synchronize(ArrayList<Object> synchronizedObjects) {
            synchronizedObjects.add(this);
            Definitions.synchronizeClothingDefinition(this.serialize());
        }

        @DefinitionMethod
        public TextureAsset getIcon(int texture) {
            return TextureAsset.loadFromGame("#ITEM#" + this.name + "_" + texture);
        }
    }

    public static enum Function {
        None(0),
        Lamp(1),
        Torch(2),
        NVG(3),
        VR(4),
        DivingGoggles(5),
        Saddle(6),
        Saddlebag(7);

        public final int value;
        private static Function[] values;

        private Function(int i) {
            this.value = i;
        }

        public static Function get(int value) {
            if (values == null) {
                values = Function.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Function.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Race {
        None(0),
        Human(1),
        Animal(2),
        Mount(3),
        Skeleton(4);

        public final int value;
        private static Race[] values;

        private Race(int i) {
            this.value = i;
        }

        public static Race get(int value) {
            if (values == null) {
                values = Race.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Race.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Type {
        Head(0),
        Face(1),
        Top(2),
        Legs(3),
        Feet(4);

        public final int value;
        private static Type[] values;

        private Type(int i) {
            this.value = i;
        }

        public static Type get(int value) {
            if (values == null) {
                values = Type.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Type.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }

    public static enum Gender {
        Male(0),
        Female(1),
        All(2);

        public final int value;
        private static Gender[] values;

        private Gender(int i) {
            this.value = i;
        }

        public static Gender get(int value) {
            if (values == null) {
                values = Gender.values();
            }
            for (int i = 0; i < values.length; ++i) {
                if (Gender.values[i].value != value) continue;
                return values[i];
            }
            return null;
        }
    }
}

