/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.collider;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.jiw.unity.runtime.utils.InternalUtils;
import net.risingworld.api.collider.Collider;
import net.risingworld.api.utils.Vector3f;

public class BoxCollider
extends Collider {
    private Vector3f center;
    private Vector3f size;
    private boolean isTrigger;

    public BoxCollider(float sizeX, float sizeY, float sizeZ) {
        this(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ);
    }

    public BoxCollider(float sizeX, float sizeY, float sizeZ, boolean isTrigger) {
        this(0.0f, 0.0f, 0.0f, sizeX, sizeY, sizeZ, isTrigger);
    }

    public BoxCollider(float x, float y, float z, float sizeX, float sizeY, float sizeZ) {
        super(Collider.Type.Box);
        this.center = new Vector3f(x, y, z);
        this.size = new Vector3f(sizeX, sizeY, sizeZ);
    }

    public BoxCollider(float x, float y, float z, float sizeX, float sizeY, float sizeZ, boolean isTrigger) {
        super(Collider.Type.Box);
        this.center = new Vector3f(x, y, z);
        this.size = new Vector3f(sizeX, sizeY, sizeZ);
        this.isTrigger = isTrigger;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public Vector3f getSize() {
        return this.size;
    }

    public boolean isTrigger() {
        return this.isTrigger;
    }

    @Override
    final byte[] serialize() {
        ByteBuffer buffer = ByteBuffer.allocate(26);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)this.getType().ordinal());
        InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.center);
        InternalUtils.ByteBufferUtils.putVector3f((ByteBuffer)buffer, (Vector3f)this.size);
        buffer.put((byte)(this.isTrigger ? 1 : 0));
        return buffer.array();
    }
}

